/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.ju.JuUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Period;
import java.time.Year;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;

public final class DateUtil {
    public static final ZoneId APPLICATION_TIMEZONE = ApplicationConfig.TIMEZONE.toZoneId();
    public static final LocalDate FISCAL_YEAR_END;
    public static final LocalDate FISCAL_YEAR_START;
    private static final int FISCAL_YEAR_LENGTH = 365;

    private DateUtil() {
    }

    public static long annualise(long amount, LocalDate startTime, LocalDate endTime) {
        Objects.requireNonNull(startTime, "Start time cannot be null.");
        Objects.requireNonNull(endTime, "Start time cannot be null.");
        int yearInt = ApplicationConfig.getInstance().getJahr();
        Year year = Year.of(yearInt);
        LocalDate date = year.atDay(1);
        int yearLength = date.lengthOfYear();
        long nombreJours = ChronoUnit.DAYS.between(startTime, endTime) + 1L;
        if (nombreJours >= (long)yearLength) {
            return amount;
        }
        if (nombreJours == 0L) {
            return 0L;
        }
        return BigDecimal.valueOf(amount).divide(BigDecimal.valueOf(nombreJours), JuUtil.MC).multiply(BigDecimal.valueOf(365L)).longValue();
    }

    public static LocalDate getLocalDate(Date date) {
        return date.toInstant().atZone(APPLICATION_TIMEZONE).toLocalDate();
    }

    public static Period getPeriod(Date startDate, Date endDate) {
        LocalDate dateFrom = startDate != null ? DateUtil.getLocalDate(startDate) : FISCAL_YEAR_START;
        LocalDate dateTo = endDate != null ? DateUtil.getLocalDate(endDate) : FISCAL_YEAR_END;
        return Period.between(dateFrom, dateTo);
    }

    static {
        int year = ApplicationConfig.getInstance().getJahr();
        FISCAL_YEAR_START = LocalDate.of(year, Month.JANUARY, 1);
        FISCAL_YEAR_END = LocalDate.of(year, Month.DECEMBER, 31);
    }
}

