/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.ju.JuUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Environment {
    PRODUCTION(true),
    VALIDATION(false),
    LOCAL(false),
    MOCKED(false);

    private static final Logger LOG;
    public static final String ENVIRONMENT_KEY = "environment";
    public static final Environment DEFAULT_ENVIRONMENT;
    private static final Environment CURRENT_ENVIRONMENT;
    private final boolean production;

    private Environment(boolean production) {
        this.production = production;
    }

    public boolean isProduction() {
        return this.production;
    }

    public static @NonNull Environment getCurrentEnvironment() {
        return CURRENT_ENVIRONMENT;
    }

    static {
        LOG = LoggerFactory.getLogger(JuUtil.class);
        DEFAULT_ENVIRONMENT = PRODUCTION;
        Environment env = null;
        String envString = ApplicationConfig.getInstance().getString(ENVIRONMENT_KEY);
        if (envString != null) {
            try {
                env = Environment.valueOf(envString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Invalid environment definition: " + envString, e);
            }
        } else {
            LOG.debug("No environment defined in application config.");
        }
        if (env == null) {
            env = DEFAULT_ENVIRONMENT;
        }
        CURRENT_ENVIRONMENT = env;
    }
}

