/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju;

import ch.dvbern.tax.common.ejb.util.CDIHelper;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DDataDTO;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.bd.DvbTaxSession;
import ch.dvbern.tax.common.presentation.common.Mode;
import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.presentation.common.print.PrintRequest;
import ch.dvbern.tax.common.presentation.common.print.PrintUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.InternalFailureException;
import ch.dvbern.tax.ju.SystemInfo;
import ch.dvbern.tax.ju.engine.expertdisplay.JuBarcodeGenerator;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import java.math.MathContext;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JuUtil {
    public static final MathContext MC = new MathContext(20, RoundingMode.HALF_DOWN);
    public static final Locale APPLICATION_LOCALE = new Locale("fr", "ch");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String PRINT_BARCODE_PROPERTY_KEY = "barcode";
    public static final String PRINT_JUSTIFICATIFS_ADDR_KEY = "justificatifs.adresse";
    public static final DateTimeFormatter DATE_TIME_FORMATTER_PDF = DateTimeFormatter.ofPattern("dd/MM/yyyy \u00e0 HH:mm:ss").withZone(UploadConfiguration.TIMEZONE);

    private JuUtil() {
    }

    @Nonnull
    public static URL parseURL(String urlText) {
        try {
            return new URL(urlText);
        }
        catch (MalformedURLException ignored) {
            throw new IllegalArgumentException("Cannot parse URL: " + urlText);
        }
    }

    public static @NonNull FormRendererConfiguration newPrintConfiguration() {
        return new FormRendererConfiguration().withProperty("version.print", (Object)ApplicationConfig.getInstance().getApplicationVersion());
    }

    public static boolean hasJustificatifs(@NonNull DvbTaxSession session) {
        if (session == null) {
            throw new NullPointerException("User session cannot be null.");
        }
        ModelItemDTO stateItem = session.getModelItem("Televersement.JustificatifState");
        return stateItem != null && stateItem.getState() != 12;
    }

    public static @NonNull PrintRequest initializeFinalPrintRequest(@NonNull PrintRequest request, @NonNull DvbTaxSession session, boolean validationAlreadyPerformed, SystemInfo sysInfo) {
        Object numeroContribuableItemObj;
        if (session == null) {
            throw new NullPointerException("User session cannot be null.");
        }
        List formKeys = PrintUtil.getPrintAllKeys((DvbTaxSession)session);
        formKeys.add(0, new FormKey("Barcode", Mode.EXPERT));
        formKeys.add(1, new FormKey("Justificatifs", Mode.EXPERT));
        request.withFormKeys((Collection)formKeys);
        String taxPayerNumber = null;
        ModelItemDTO taxPayerNumberItem = session.getModelItem("Stammdaten.Declaration.NoContribuable");
        if (taxPayerNumberItem != null && (numeroContribuableItemObj = taxPayerNumberItem.getValue()) != null) {
            taxPayerNumber = numeroContribuableItemObj.toString();
        }
        if (taxPayerNumber == null) {
            throw new IllegalStateException("Failed to fetch tax payer number from data model");
        }
        Instant timestamp = Instant.now();
        JuBarcodeGenerator generator = new JuBarcodeGenerator(true, timestamp, UploadConfiguration.UploadType.PRINT, sysInfo);
        Barcode2DDataDTO barcode = session.generateBarcode((Barcode2DGenerator)generator);
        LocalizationHelper locHelper = request.getConverterContext().getLocalizationHelper();
        FormRendererConfiguration configuration = JuUtil.newPrintConfiguration().withTimestamp(Long.valueOf(timestamp.toEpochMilli())).withProperty(PRINT_BARCODE_PROPERTY_KEY, (Object)barcode).withProperty(PRINT_JUSTIFICATIFS_ADDR_KEY, (Object)locHelper.translate("label.justificatifs.impression.info", new Object[0]));
        if (validationAlreadyPerformed) {
            try {
                configuration.withWatermark(locHelper.translate("label.print.watermark.dejateleverse", new Object[0]));
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                throw new AssertionError((Object)e);
            }
        }
        return request.withConfiguration(configuration);
    }

    public static void prepareSummaryPagePrint(FormRendererConfiguration configuration, String codeDI, Instant timestamp) {
        configuration.withProperty("code.di", (Object)codeDI).withProperty("upload.timestamp", (Object)DATE_TIME_FORMATTER_PDF.format(timestamp)).withProperty("summary.timestamp", (Object)DATE_TIME_FORMATTER_PDF.format(timestamp)).withProperty("pdf.timestamp", (Object)DATE_TIME_FORMATTER_PDF.format(timestamp));
    }

    public static void prepareSummaryPagePrint(PrintRequest printRequest, String codeDI, Instant timestamp) {
        JuUtil.prepareSummaryPagePrint(printRequest.getConfiguration(), codeDI, timestamp);
        printRequest.withExpertKeys(new String[]{"Synthese", "impot_page1"});
    }

    public static String translate(@NonNull String key, Object ... args) {
        if (key == null) {
            throw new NullPointerException("Resource key cannot be null.");
        }
        return CDIHelper.getResourceBundleManager().translate(key, APPLICATION_LOCALE, args);
    }

    public static @NonNull ModelItemDTO createTouchedItem(@Nullable Object value) {
        ModelItemDTO item = new ModelItemDTO(value);
        item.setTouched();
        return item;
    }

    public static @NonNull Profile getApplicationProfile() {
        String profile = ApplicationConfig.getInstance().getString("application.profile");
        if (profile == null) {
            throw new InternalFailureException("No application profile defined in configuration.");
        }
        try {
            return Profile.valueOf(profile.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InternalFailureException("Invalid application profile in configuration: " + profile);
        }
    }

    public static Map<String, ModelItemDTO> createSummaryPrintValues(Instant timestamp, @Nullable String codeDI) {
        HashMap<String, ModelItemDTO> newValues = new HashMap<String, ModelItemDTO>();
        newValues.put("ImpressionVariables.CodeDI", JuUtil.createTouchedItem(codeDI));
        DateTimeFormatter df = DATE_TIME_FORMATTER_PDF;
        newValues.put("ImpressionVariables.PrintDate", JuUtil.createTouchedItem(df.format(timestamp)));
        return newValues;
    }

    public static Map<String, ModelItemDTO> createAddrJustPrintValues(String address) {
        HashMap<String, ModelItemDTO> newValues = new HashMap<String, ModelItemDTO>();
        newValues.put("Impression.AdresseJustificatifs", JuUtil.createTouchedItem(address));
        return newValues;
    }

    public static List<String> getTableIndexesFromModel(LogicModelItem.ProtectedMap dataModel, String tableDmk) {
        ModelItemDTO item = dataModel.get((Object)tableDmk);
        if (item == null) {
            return null;
        }
        Object value = item.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Set) {
            Set indexes = (Set)value;
            ArrayList<String> result = new ArrayList<String>(indexes.size());
            result.addAll(indexes.stream().map(Object::toString).collect(Collectors.toList()));
            Collections.sort(result);
            return result;
        }
        throw new IllegalStateException("Unexpected data type for table indexes: '" + value.getClass().getName() + "' (expected: '" + Set.class.getName() + "')");
    }

    public static enum Profile {
        CD(1),
        ONLINE(2);

        private final int barcodeValue;

        private Profile(int barcodeValue) {
            this.barcodeValue = barcodeValue;
        }

        public int getBarcodeValue() {
            return this.barcodeValue;
        }
    }
}

