/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ju.DateUtil;
import ch.dvbern.tax.ju.JuUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class CFAdmetInstructionAuDehors
implements CalcItem {
    private static final int FRAIS_TOTAL_GLOBAL_MIN = 1000;
    private static final int REVENU_ANNUEL_MAX = 19800;
    private static final int REVENU_MENSUEL_MAX = 600;

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        long revenuNet = StackUtil.getLong((FastStack)stack);
        long fraisTotal = StackUtil.getLong((FastStack)stack);
        long fraisPension = StackUtil.getLong((FastStack)stack);
        long bourse = StackUtil.getLong((FastStack)stack);
        Date dateDebut = (Date)StackUtil.get((FastStack)stack, Date.class, null);
        Date dateFin = (Date)StackUtil.get((FastStack)stack, Date.class, null);
        LocalDate startTime = dateDebut != null ? dateDebut.toInstant().atZone(DateUtil.APPLICATION_TIMEZONE).toLocalDate() : DateUtil.FISCAL_YEAR_START;
        LocalDate endTime = dateFin != null ? dateFin.toInstant().atZone(DateUtil.APPLICATION_TIMEZONE).toLocalDate() : DateUtil.FISCAL_YEAR_END;
        long fraisTotalGlobal = StackUtil.getLong((FastStack)stack);
        long fraisPensionGlobal = StackUtil.getLong((FastStack)stack);
        stack.push((Object)this.admetInstructionAuDehors(revenuNet, fraisTotal, fraisPension, bourse, startTime, endTime, fraisTotalGlobal, fraisPensionGlobal));
    }

    private boolean admetInstructionAuDehors(long revenuNet, long fraisTotal, long fraisPension, long bourse, LocalDate startDate, LocalDate endDate, long fraisTotalGlobal, long fraisPensionGlobal) {
        long revenuDeterminant;
        long revenuMensuel;
        if (fraisPensionGlobal <= 0L && fraisTotalGlobal < 1000L) {
            return false;
        }
        long revenuAnnuel = DateUtil.annualise(revenuNet, startDate, endDate) + bourse;
        if (revenuAnnuel > 19800L) {
            return false;
        }
        return fraisPension > 0L || (revenuMensuel = this.revenuMensuel(revenuDeterminant = Math.max(revenuNet - fraisTotal, 0L) + bourse, startDate, endDate)) <= 600L;
    }

    private long revenuMensuel(long revenu, LocalDate startDate, LocalDate endDate) {
        long nombreMois = ChronoUnit.MONTHS.between(startDate, endDate) + 1L;
        return BigDecimal.valueOf(revenu).divide(BigDecimal.valueOf(nombreMois), JuUtil.MC).longValue();
    }
}

