/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.calcitems.Constant;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.ju.JuUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CFCurrentSelectLabel
implements ComplexCalcItem {
    private final Reference selectRef;
    private LabelEnum labelType = LabelEnum.TEXT;

    public CFCurrentSelectLabel(@NonNull Reference selectRef) {
        this(selectRef, null);
    }

    public CFCurrentSelectLabel(@NonNull Reference selectRef, @Nullable Constant labelType) {
        this.selectRef = Objects.requireNonNull(selectRef, "select item reference cannot be null");
        if (labelType != null) {
            this.labelType = LabelEnum.valueOf(labelType.getValue().toString());
        }
    }

    public void evaluate(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull FastStack stack, @NonNull String dataModelKey) {
        Object selectValue;
        Select select = (Select)this.selectRef.getReference();
        String dmk = EngineUtil.mergeModelKey((String)select.getName(), (String)dataModelKey);
        ModelItemDTO selectValueItem = dataModel.get((Object)dmk);
        String label = "";
        if (selectValueItem != null && (selectValue = selectValueItem.getValue()) != null) {
            OptionItemsDTO items = select.getOptionItems(dataModel, dataModelKey);
            OptionItemDTO item = items.get((Object)selectValue.toString());
            label = LabelEnum.SHORT_TEXT.equals((Object)this.labelType) ? LocalizationHelper.newInstance((Locale)JuUtil.APPLICATION_LOCALE).translate(item.getShortText().toString(), new Object[0]) : item.getText().toString();
        }
        stack.push((Object)label);
    }

    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.selectRef.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    private static enum LabelEnum {
        TEXT,
        SHORT_TEXT;

    }
}

