/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class CFDateParser
implements CalcItem {
    private static final ThreadLocal<DateFormat> DATE_PARSER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("ddMMyyy");
        }
    };

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        String dateStr = StackUtil.getString((FastStack)stack);
        if (dateStr == null) {
            stack.push(null);
        } else {
            try {
                stack.push((Object)DATE_PARSER.get().parse(dateStr));
            }
            catch (ParseException e) {
                throw new ApplicationException("Invalid date string: " + dateStr, (Throwable)e);
            }
        }
    }
}

