/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;

public class CFDeductionDoubleGains
implements CalcItem {
    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        Object montantMaxObj = stack.pop();
        Object revenuFemmeObj = stack.pop();
        Object revenuHommeObj = stack.pop();
        Object collaborationObj = stack.pop();
        long montantMax = 0L;
        long revenuFemme = 0L;
        long revenuHomme = 0L;
        boolean collaboration = false;
        if (montantMaxObj instanceof Number) {
            montantMax = ((Number)montantMaxObj).longValue();
        }
        if (revenuFemmeObj instanceof Number) {
            revenuFemme = ((Number)revenuFemmeObj).longValue();
        }
        if (revenuHommeObj instanceof Number) {
            revenuHomme = ((Number)revenuHommeObj).longValue();
        }
        if (collaborationObj instanceof Boolean) {
            collaboration = (Boolean)collaborationObj;
        }
        long resultDoubleActivite = 0L;
        long resultCollaboration = 0L;
        if (revenuHomme > 0L && revenuFemme > 0L) {
            resultDoubleActivite = montantMax;
            long revenuLePlusBas = revenuHomme > revenuFemme ? revenuFemme : revenuHomme;
            if (resultDoubleActivite > revenuLePlusBas) {
                resultDoubleActivite = revenuLePlusBas;
            }
            if (resultDoubleActivite < 0L) {
                resultDoubleActivite = 0L;
            }
        }
        if (collaboration) {
            resultCollaboration = montantMax;
            if (resultCollaboration > revenuHomme + revenuFemme) {
                resultCollaboration = revenuHomme + revenuFemme;
            }
            if (resultCollaboration < 0L) {
                resultCollaboration = 0L;
            }
        }
        long result = resultCollaboration > resultDoubleActivite ? resultCollaboration : resultDoubleActivite;
        stack.push((Object)result);
    }
}

