/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ju.engine.calcitems.CFDesignationAge;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CFDeductionEnfant
implements CalcItem {
    public static final int AUTORITE_PARENTALE_OUI = 1;
    public static final int AUTORITE_PARENTALE_NON = 2;
    public static final int AUTORITE_PARENTALE_PARTAGEE = 3;
    public static final int MENAGE_MARITAL = 1;
    public static final int MENAGE_CONCUBIN = 2;
    public static final int MENAGE_SEUL = 3;
    public static final int DEDUCTION_ENTIERE = 1;
    public static final int DEMIE_DEDUCTION = 2;
    public static final int AUCUNE_DEDUCTION = 3;
    public static final long REVENU_DETERMINANT_MAX = 12100L;
    private static final DeductionEnfantDTO RIEN_ADMIS = new DeductionEnfantDTO(3, false, 3);

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        long revenuDeterminantTotal = StackUtil.getLong((FastStack)stack);
        boolean gardeAlternee = StackUtil.getBoolean((FastStack)stack);
        boolean menageCommunEnfant = StackUtil.getBoolean((FastStack)stack);
        int menageAutreParent = StackUtil.getInteger((FastStack)stack);
        int autoriteParentale = StackUtil.getInteger((FastStack)stack);
        CFDesignationAge.Designation age = CFDesignationAge.Designation.forCode(StackUtil.getInteger((FastStack)stack));
        long pensionAlimRecue = StackUtil.getLong((FastStack)stack);
        long pensionAlimVersee = StackUtil.getLong((FastStack)stack);
        boolean revenuInfAutreParent = StackUtil.getBoolean((FastStack)stack);
        stack.push(this.determineCharge(revenuDeterminantTotal, gardeAlternee, menageCommunEnfant, menageAutreParent, autoriteParentale, age, pensionAlimRecue, pensionAlimVersee, revenuInfAutreParent).dump());
    }

    private DeductionEnfantDTO determineCharge(long revenuDeterminantTotal, boolean gardeAlternee, boolean menageCommunEnfant, int menageAutreParent, int autoriteParentale, CFDesignationAge.Designation age, long pensionAlimRecue, long pensionAlimVersee, boolean revenuInfAutreParent) {
        if (age == null) {
            return RIEN_ADMIS;
        }
        boolean admetCharge = revenuDeterminantTotal <= 12100L;
        switch (age) {
            case MINEUR: {
                switch (menageAutreParent) {
                    case 1: {
                        return DeductionEnfantDTO.deductionEntiere(admetCharge);
                    }
                    case 2: {
                        if (pensionAlimVersee > 0L) {
                            return RIEN_ADMIS;
                        }
                        if (autoriteParentale == 1 && pensionAlimRecue <= 0L) {
                            return DeductionEnfantDTO.deductionEntiere(admetCharge);
                        }
                        if (autoriteParentale == 2 && pensionAlimRecue <= 0L) {
                            return RIEN_ADMIS;
                        }
                        if (autoriteParentale == 3 && pensionAlimRecue <= 0L) {
                            return new DeductionEnfantDTO(2, revenuInfAutreParent, 2);
                        }
                        return new DeductionEnfantDTO(1, true, 2);
                    }
                    case 3: {
                        switch (autoriteParentale) {
                            case 1: 
                            case 2: {
                                if (menageCommunEnfant) {
                                    return DeductionEnfantDTO.deductionEntiere(admetCharge);
                                }
                                return RIEN_ADMIS;
                            }
                            case 3: {
                                if (!menageCommunEnfant) {
                                    if (!revenuInfAutreParent && pensionAlimVersee == 0L && pensionAlimRecue == 0L) {
                                        return new DeductionEnfantDTO(2, false, 2);
                                    }
                                    return RIEN_ADMIS;
                                }
                                if (pensionAlimVersee > 0L) {
                                    return RIEN_ADMIS;
                                }
                                boolean baremeParental = admetCharge ? !gardeAlternee || revenuInfAutreParent || pensionAlimRecue > 0L : false;
                                if (pensionAlimRecue > 0L) {
                                    if (gardeAlternee) {
                                        return new DeductionEnfantDTO(1, baremeParental, 1);
                                    }
                                    return DeductionEnfantDTO.deductionEntiere(admetCharge);
                                }
                                return new DeductionEnfantDTO(2, baremeParental, 2);
                            }
                        }
                        assert (false);
                        return RIEN_ADMIS;
                    }
                }
                assert (false);
                return RIEN_ADMIS;
            }
            case AGE_18: 
            case MAJEUR: {
                if (menageCommunEnfant) {
                    if (menageAutreParent == 1) {
                        return DeductionEnfantDTO.deductionEntiere(admetCharge);
                    }
                    if (menageAutreParent == 2) {
                        if (pensionAlimRecue <= 0L && pensionAlimVersee <= 0L && revenuInfAutreParent) {
                            return RIEN_ADMIS;
                        }
                        if (pensionAlimRecue <= 0L && pensionAlimVersee <= 0L && !revenuInfAutreParent) {
                            return DeductionEnfantDTO.deductionEntiere(admetCharge);
                        }
                        if (pensionAlimRecue > 0L) {
                            return RIEN_ADMIS;
                        }
                        if (pensionAlimVersee > 0L || revenuInfAutreParent) {
                            return DeductionEnfantDTO.deductionEntiere(admetCharge);
                        }
                        return RIEN_ADMIS;
                    }
                    if (pensionAlimRecue > 0L) {
                        return new DeductionEnfantDTO(3, admetCharge, 3);
                    }
                    return DeductionEnfantDTO.deductionEntiere(admetCharge);
                }
                if (menageAutreParent == 1) {
                    return new DeductionEnfantDTO(admetCharge ? 1 : 3, false, 1);
                }
                if (pensionAlimVersee > 0L) {
                    return new DeductionEnfantDTO(admetCharge ? 1 : 3, false, 1);
                }
                return RIEN_ADMIS;
            }
        }
        assert (false);
        return RIEN_ADMIS;
    }

    public static class DeductionEnfantDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static final String CHARGE = "charge";
        static final String BAREME_PARENTAL = "baremeParental";
        static final String INSTRUCTION_AU_DEHORS = "instructionAuDehors";
        final int charge;
        final boolean baremeParental;
        final int instructionAuDehors;

        DeductionEnfantDTO() {
            this(0, false, 0);
        }

        public DeductionEnfantDTO(int charge, boolean baremeParental, int instructionAuDehors) {
            this.charge = charge;
            this.baremeParental = baremeParental;
            this.instructionAuDehors = instructionAuDehors;
        }

        static DeductionEnfantDTO deductionEntiere(boolean admetCharge) {
            return new DeductionEnfantDTO(admetCharge ? 1 : 3, admetCharge, 1);
        }

        Map<String, Object> dump() {
            HashMap<String, Object> dto = new HashMap<String, Object>(3);
            dto.put(CHARGE, this.charge);
            dto.put(BAREME_PARENTAL, this.baremeParental);
            dto.put(INSTRUCTION_AU_DEHORS, this.instructionAuDehors);
            return dto;
        }

        static DeductionEnfantDTO load(Map<String, Object> data) {
            if (data == null) {
                return new DeductionEnfantDTO();
            }
            Object charge = data.get(CHARGE);
            Object baremeParental = data.get(BAREME_PARENTAL);
            Object instructionAuDehors = data.get(INSTRUCTION_AU_DEHORS);
            return new DeductionEnfantDTO(charge != null ? (Integer)charge : 0, baremeParental != null ? (Boolean)baremeParental : false, instructionAuDehors != null ? (Integer)instructionAuDehors : 0);
        }
    }

    public static class GetInstructionAuDehors
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            Map dto = (Map)StackUtil.get((FastStack)stack, Map.class, null);
            stack.push(dto != null ? dto.get("instructionAuDehors") : null);
        }
    }

    public static class GetBaremeParental
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            Map dto = (Map)StackUtil.get((FastStack)stack, Map.class, null);
            stack.push(dto != null ? dto.get("baremeParental") : null);
        }
    }

    public static class GetDeductionEnfant
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            Map dto = (Map)StackUtil.get((FastStack)stack, Map.class, null);
            stack.push(dto != null ? dto.get("charge") : null);
        }
    }
}

