/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ju.transfer.dto.DeductionPersonnesAgeesModelItem;
import ch.dvbern.tax.ju.transfer.dto.DeductionPersonnesAgeesOuInfirmesMariesModelItem;
import ch.dvbern.tax.ju.transfer.dto.DeductionPersonnesAgeesOuInfirmesNonMariesModelItem;
import java.util.Map;

public class CFDeductionPourPersonnesAgeesOuInfirmes
implements CalcItem {
    private static final String BAREME_MARIE_RESOURCE_NAME = "deductionPersonneAgeeMariee";
    private static final String BAREME_CELIBATAIRE_RESOURCE_NAME = "deductionPersonneAgeeNonMariee";
    private final DataResource dataResource;

    public CFDeductionPourPersonnesAgeesOuInfirmes(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        stack.push((Object)this.computeDeduction(stack));
    }

    private long computeDeduction(FastStack stack) {
        boolean flagRentierFemme;
        long rentesAVSFemme = StackUtil.getLong((FastStack)stack);
        long rentesAVSHomme = StackUtil.getLong((FastStack)stack);
        long revenuImposableSansDeductionPourPersonnesAgeesOuInfirmesICC = Math.max(0L, StackUtil.getLong((FastStack)stack));
        long etatCivil = StackUtil.getLong((FastStack)stack);
        long result = 0L;
        boolean flagRentierHomme = rentesAVSHomme > 0L;
        boolean bl = flagRentierFemme = rentesAVSFemme > 0L;
        if (!flagRentierHomme && !flagRentierFemme) {
            return 0L;
        }
        if (etatCivil == 2L) {
            Map deductionPersonnesAgeesMarie = this.dataResource.get(BAREME_MARIE_RESOURCE_NAME, null, null);
            DeductionPersonnesAgeesOuInfirmesMariesModelItem itm = (DeductionPersonnesAgeesOuInfirmesMariesModelItem)this.lookupDeduction(deductionPersonnesAgeesMarie.values(), revenuImposableSansDeductionPourPersonnesAgeesOuInfirmesICC);
            if (itm != null) {
                result = flagRentierHomme && flagRentierFemme ? itm.getMontantDeductionDouble() : itm.getMontantDeductionUnique();
            }
        } else {
            Map deductionPersonnesAgeesNonMarie = this.dataResource.get(BAREME_CELIBATAIRE_RESOURCE_NAME, null, null);
            DeductionPersonnesAgeesOuInfirmesNonMariesModelItem itm = (DeductionPersonnesAgeesOuInfirmesNonMariesModelItem)this.lookupDeduction(deductionPersonnesAgeesNonMarie.values(), revenuImposableSansDeductionPourPersonnesAgeesOuInfirmesICC);
            if (itm != null) {
                result = itm.getMontantDeduction();
            }
        }
        return result;
    }

    private <T extends DeductionPersonnesAgeesModelItem> T lookupDeduction(Iterable<T> ranges, long revenu) {
        assert (((DeductionPersonnesAgeesModelItem)ranges.iterator().next()).getMontantMin() == 0L) : "First range minimal amount must be 0";
        assert (revenu >= 0L);
        DeductionPersonnesAgeesModelItem result = null;
        for (DeductionPersonnesAgeesModelItem anItem : ranges) {
            if (anItem.getMontantMin() > revenu || anItem.getMontantMax() < revenu) continue;
            result = anItem;
        }
        return (T)result;
    }
}

