/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;

public class CFDeductionsProfessionnellesGeneralesIFD
implements CalcItem {
    private static final int DEPENSES_GENERALES_DEDUCTION_MAX = 4000;
    private static final int DEPENSES_GENERALES_DEDUCTION_MIN = 2000;
    private static final double DEPENSES_GENERALES_PERCENT = 0.03;

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        long revenuPrincipal = StackUtil.getLong((FastStack)stack);
        long revenuAI = StackUtil.getLong((FastStack)stack);
        double tauxTotalAnnualise = StackUtil.getDouble((FastStack)stack);
        double deduction = 0.0;
        if (tauxTotalAnnualise != 0.0) {
            double tauxActiviteEffectif = Math.min(tauxTotalAnnualise, 1.0);
            deduction = (double)(revenuPrincipal + revenuAI) / tauxActiviteEffectif * 0.03;
            deduction = Math.max(2000.0, deduction);
            deduction = Math.min(4000.0, deduction);
            deduction *= tauxActiviteEffectif;
        }
        stack.push((Object)Math.round(deduction));
    }
}

