/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ju.DateUtil;
import java.time.LocalDate;
import java.time.Period;
import java.util.Date;

public class CFDesignationAge
implements CalcItem {
    public static final int MAJORITY_AGE = 18;

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        Date birthDate = (Date)StackUtil.get((FastStack)stack, Date.class, null);
        if (birthDate != null) {
            stack.push((Object)this.getDesignationAge((Date)birthDate).code);
        } else {
            stack.push(null);
        }
    }

    Designation getDesignationAge(Date birthDate) {
        if (birthDate == null) {
            throw new NullPointerException("birth date cannot be null");
        }
        LocalDate birthLocalDate = DateUtil.getLocalDate(birthDate);
        int age = Period.between(birthLocalDate, DateUtil.FISCAL_YEAR_END).getYears();
        if (age > 18) {
            return Designation.MAJEUR;
        }
        if (age < 18) {
            return Designation.MINEUR;
        }
        assert (age == 18);
        return Designation.AGE_18;
    }

    public static enum Designation {
        MINEUR(1),
        AGE_18(2),
        MAJEUR(3);

        public final int code;

        private Designation(int code) {
            this.code = code;
        }

        public static Designation forCode(Integer code) {
            if (code == null) {
                return null;
            }
            for (Designation designation : Designation.values()) {
                if (designation.code != code) continue;
                return designation;
            }
            return null;
        }
    }
}

