/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.ju.presentation.common.JuDataResourceBase;
import java.util.Map;
import java.util.StringTokenizer;

public class CFDetermineImpotFortune
implements CalcItem {
    private final DataResource dataResource;
    private Object[] stufen;

    public CFDetermineImpotFortune(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        Map optionMap;
        Object fortuneObj = stack.pop();
        long fortune = 0L;
        if (fortuneObj instanceof Number) {
            fortune = ((Number)fortuneObj).longValue();
        }
        if ((optionMap = this.dataResource.get(JuDataResourceBase.ResourceEnum.IMPOT_ICC_FORTUNE.getCode(), null, null)) != null) {
            long impot100;
            long mod;
            this.stufen = optionMap.keySet().toArray();
            long montant = fortune - fortune % 1000L;
            double impot = 0.0;
            String stufe = this.getStufe(montant);
            if (stufe != null) {
                long milliersSupplementaires = (montant - Long.parseLong(stufe)) / 1000L;
                double impotAnnuel = Double.parseDouble(this.getImpotAnnuel(montant));
                double montantParMilleFrancsSupp = Double.parseDouble(this.getMontantParMilleFrancsSupp(montant));
                impot = impotAnnuel + (double)milliersSupplementaires * montantParMilleFrancsSupp;
            }
            impot100 = (mod = (impot100 = (long)(100.0 * impot)) % 5L) > 2L ? impot100 + 5L - mod : (impot100 -= impot100 % 5L);
            stack.push((Object)((double)impot100 / 100.0));
        }
    }

    private String getStufe(long montant) {
        long maxStufe = -1L;
        for (int i = 1; i < this.stufen.length; ++i) {
            long currentStuffe = Long.parseLong((String)this.stufen[i]);
            long stufeBefore = Long.parseLong((String)this.stufen[i - 1]);
            if (currentStuffe > maxStufe) {
                maxStufe = currentStuffe;
            }
            if (currentStuffe <= montant) continue;
            if (i == 0) {
                return null;
            }
            return String.valueOf(stufeBefore);
        }
        return String.valueOf(maxStufe);
    }

    private String getImpotAnnuel(long montant) {
        String stufe = this.getStufe(montant);
        OptionItemDTO item = (OptionItemDTO)this.dataResource.get(JuDataResourceBase.ResourceEnum.IMPOT_ICC_FORTUNE.getCode(), null, null).get(stufe);
        String impotAnnuel = null;
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\t");
            impotAnnuel = tokenizer.nextToken();
            String string = tokenizer.nextToken();
        }
        return impotAnnuel;
    }

    private String getMontantParMilleFrancsSupp(long montant) {
        String stufe = this.getStufe(montant);
        OptionItemDTO item = (OptionItemDTO)this.dataResource.get(JuDataResourceBase.ResourceEnum.IMPOT_ICC_FORTUNE.getCode(), null, null).get(stufe);
        String par1000CHFSupp = null;
        if (item != null) {
            String values = (String)item.getText();
            StringTokenizer tokenizer = new StringTokenizer(values, "\t");
            String impotAnnuel = tokenizer.nextToken();
            par1000CHFSupp = tokenizer.nextToken();
        }
        return par1000CHFSupp;
    }
}

