/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.ju.presentation.common.JuDataResourceBase;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFDetermineImpotIfd
implements CalcItem {
    public static final BigDecimal TAUX_MAXIMUM = BigDecimal.valueOf(11.5);
    public static final BigDecimal IMPOT_MINIMUM_MARIE = BigDecimal.valueOf(33.0);
    public static final BigDecimal IMPOT_MINIMUM_CELIBATAIRE = BigDecimal.valueOf(25.41);
    private static final Logger LOG = LoggerFactory.getLogger(CFDetermineImpotIfd.class);
    private static final BigDecimal ROUNDING_UNIT = BigDecimal.valueOf(0.05);
    DataResource dataResource;

    public CFDetermineImpotIfd(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        stack.push((Object)this.computeMontantIfd(stack).doubleValue());
        LOG.debug("Computed ifd: " + String.valueOf(stack.peek()));
    }

    final BigDecimal computeMontantIfd(FastStack stack) {
        BigDecimal montantMinimum;
        String resourceName;
        long montant = StackUtil.getLong((FastStack)stack);
        boolean baremeMarital = StackUtil.getBoolean((FastStack)stack);
        assert (montant % 100L == 0L) : "Income not multiple of 100";
        if (baremeMarital) {
            resourceName = JuDataResourceBase.ResourceEnum.IMPOT_IFD_MARIE.getCode();
            montantMinimum = IMPOT_MINIMUM_MARIE;
        } else {
            resourceName = JuDataResourceBase.ResourceEnum.IMPOT_IFD_CELIBATAIRE.getCode();
            montantMinimum = IMPOT_MINIMUM_CELIBATAIRE;
        }
        Map optionMap = this.dataResource.get(resourceName, null, null);
        String[] tranches = optionMap.keySet().toArray(new String[optionMap.size()]);
        long montantMinimumImposable = Long.valueOf(tranches[0]);
        long montantMaximumImposable = Long.valueOf(tranches[tranches.length - 1]);
        if (montant < montantMinimumImposable) {
            return BigDecimal.ZERO;
        }
        if (montant >= montantMaximumImposable) {
            return this.computeRangee(TAUX_MAXIMUM, montant / 100L);
        }
        boolean rangeeTerminale = false;
        BigDecimal result = montantMinimum;
        boolean premiereRangee = true;
        for (int i = 1; i < tranches.length && !rangeeTerminale; ++i) {
            long nombreDeTranche;
            String trancheSupKey = tranches[i];
            long trancheSup = Long.parseLong(trancheSupKey);
            long trancheInf = Long.parseLong(tranches[i - 1]);
            assert (trancheInf % 100L == 0L && trancheSup % 100L == 0L) : "Invalid data: ranges must be multiple of 100";
            assert (trancheSup > trancheInf) : "Invalid data: ranges must be increasing";
            long remains = montant - trancheSup;
            BigDecimal taux = new BigDecimal((String)((OptionItemDTO)optionMap.get(trancheSupKey)).getText());
            if (remains < 0L) {
                nombreDeTranche = (montant - trancheInf) / 100L;
                if (!premiereRangee) {
                    ++nombreDeTranche;
                }
                rangeeTerminale = true;
            } else {
                nombreDeTranche = (trancheSup - trancheInf) / 100L;
                if (premiereRangee) {
                    --nombreDeTranche;
                }
            }
            result = this.computeRangee(result, taux, nombreDeTranche);
            premiereRangee = false;
        }
        return result;
    }

    private BigDecimal computeRangee(BigDecimal taux, long nombreDeTranche) {
        return this.computeRangee(BigDecimal.ZERO, taux, nombreDeTranche);
    }

    private BigDecimal computeRangee(BigDecimal initial, BigDecimal taux, long nombreDeTranche) {
        initial = initial.add(taux.multiply(BigDecimal.valueOf(nombreDeTranche)));
        initial = initial.divide(ROUNDING_UNIT).setScale(0, RoundingMode.DOWN).multiply(ROUNDING_UNIT);
        return initial;
    }
}

