/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ju.presentation.common.JuDataResourceBase;
import ch.dvbern.tax.ju.transfer.dto.ImpotDTO;
import java.util.Map;

public class CFDetermineImpotSurRevenuICC
implements CalcItem {
    private final DataResource dataResource;
    private Object[] stufen;

    public CFDetermineImpotSurRevenuICC(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        long revenu = StackUtil.getLong((FastStack)stack);
        boolean baremeMarital = StackUtil.getBoolean((FastStack)stack);
        String resourceName = baremeMarital ? JuDataResourceBase.ResourceEnum.IMPOT_ICC_SUR_REVENU_MARIE.getCode() : JuDataResourceBase.ResourceEnum.IMPOT_ICC_SUR_REVENU_CELIBATAIRE.getCode();
        Map optionMap = this.dataResource.get(resourceName, null, null);
        if (optionMap != null) {
            long impot100;
            long mod;
            this.stufen = optionMap.keySet().toArray();
            double impot = 0.0;
            String stufe = this.getStufe(revenu);
            if (stufe != null) {
                long montantSupplementaire = revenu - Long.parseLong(stufe);
                double impotAnnuel = Double.parseDouble(this.getImpotAnnuel(revenu, optionMap));
                double montantParCentFrancsSupp = Double.parseDouble(this.getMontantParCentFrancsSupp(revenu, optionMap));
                impot = impotAnnuel + (double)montantSupplementaire * montantParCentFrancsSupp / 100.0;
            }
            impot100 = (mod = (impot100 = (long)(100.0 * impot)) % 5L) > 2L ? impot100 + 5L - mod : (impot100 -= impot100 % 5L);
            stack.push((Object)((double)impot100 / 100.0));
        }
    }

    private String getStufe(long montant) {
        long maxStufe = -1L;
        for (int i = 1; i < this.stufen.length; ++i) {
            long currentStuffe = Long.parseLong((String)this.stufen[i]);
            long stufeBefore = Long.parseLong((String)this.stufen[i - 1]);
            if (currentStuffe > maxStufe) {
                maxStufe = currentStuffe;
            }
            if (currentStuffe <= montant) continue;
            if (i == 0) {
                return null;
            }
            return String.valueOf(stufeBefore);
        }
        return String.valueOf(maxStufe);
    }

    private String getImpotAnnuel(long montant, Map<?, ?> optionMap) {
        String stufe = this.getStufe(montant);
        ImpotDTO item = (ImpotDTO)optionMap.get(stufe);
        if (item != null) {
            return item.getImpotAnnuel();
        }
        return null;
    }

    private String getMontantParCentFrancsSupp(long montant, Map<?, ?> optionMap) {
        String stufe = this.getStufe(montant);
        ImpotDTO item = (ImpotDTO)optionMap.get(stufe);
        if (item != null) {
            return item.getPar100CHFSupp();
        }
        return null;
    }
}

