/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import java.io.Serializable;

public final class CFFraisAdmisInstructionAuDehors
implements CalcItem {
    private static final int FRAIS_DEPLACEMENT_MAX = 2700;
    private static final int FRAIS_REPAS_MAX = 3000;
    private static final int BOURSE_UPPER_RANGE_LIMIT = 11000;
    private static final int BOURSE_LOWER_RANGE_LIMIT = 8000;
    private static final int DEDUCTION_MAX = 10600;
    private static final int DEDUCTION_SMALL = 5300;
    private static final FraisInstructionDTO AUCUN_FRAIS_ADMIS = new FraisInstructionDTO(0L, 0L, 0L);

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        boolean admetDeduction = StackUtil.getBoolean((FastStack)stack);
        long bourse = StackUtil.getLong((FastStack)stack);
        long fraisDeplacement = StackUtil.getLong((FastStack)stack);
        long fraisRepas = StackUtil.getLong((FastStack)stack);
        long fraisPension = StackUtil.getLong((FastStack)stack);
        stack.push((Object)this.montantAdmis(admetDeduction, bourse, fraisDeplacement, fraisRepas, fraisPension));
    }

    private FraisInstructionDTO montantAdmis(boolean admetDeduction, long bourse, long fraisDeplacement, long fraisRepas, long fraisPension) {
        long fraisRepasAdmis;
        long fraisPensionAdmis;
        if (!admetDeduction) {
            return AUCUN_FRAIS_ADMIS;
        }
        if (bourse > 11000L || bourse > 0L && fraisPension <= 0L) {
            return AUCUN_FRAIS_ADMIS;
        }
        long fraisDeplacementAdmis = Math.min(fraisDeplacement, 2700L);
        if (fraisPension > 0L) {
            long max = bourse <= 8000L ? 10600L : 5300L;
            fraisPensionAdmis = Math.min(fraisPension + fraisRepas, max - fraisDeplacementAdmis);
            fraisRepasAdmis = 0L;
        } else {
            fraisPensionAdmis = 0L;
            fraisRepasAdmis = Math.min(fraisRepas, 3000L);
        }
        return new FraisInstructionDTO(fraisDeplacementAdmis, fraisRepasAdmis, fraisPensionAdmis);
    }

    public static final class FraisInstructionDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long fraisDeplacement;
        private final long fraisRepas;
        private final long fraisPension;

        private FraisInstructionDTO(long fraisDeplacement, long fraisRepas, long fraisPension) {
            this.fraisDeplacement = fraisDeplacement;
            this.fraisRepas = fraisRepas;
            this.fraisPension = fraisPension;
        }
    }

    public static class GetFraisPension
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            stack.push((Object)((FraisInstructionDTO)StackUtil.get((FastStack)stack, FraisInstructionDTO.class, (Object)CFFraisAdmisInstructionAuDehors.AUCUN_FRAIS_ADMIS)).fraisPension);
        }
    }

    public static class GetFraisRepas
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            stack.push((Object)((FraisInstructionDTO)StackUtil.get((FastStack)stack, FraisInstructionDTO.class, (Object)CFFraisAdmisInstructionAuDehors.AUCUN_FRAIS_ADMIS)).fraisRepas);
        }
    }

    public static class GetFraisDeplacement
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            stack.push((Object)((FraisInstructionDTO)StackUtil.get((FastStack)stack, FraisInstructionDTO.class, (Object)CFFraisAdmisInstructionAuDehors.AUCUN_FRAIS_ADMIS)).fraisDeplacement);
        }
    }

    public static class CFSumFraisInstruction
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            long sumFraisRepas = 0L;
            long sumFraisPension = 0L;
            long sumFraisDeplacement = 0L;
            while (!stack.isEmpty()) {
                FraisInstructionDTO fraisInstructionDTO = (FraisInstructionDTO)StackUtil.get((FastStack)stack, FraisInstructionDTO.class, (Object)AUCUN_FRAIS_ADMIS);
                sumFraisDeplacement += fraisInstructionDTO.fraisDeplacement;
                sumFraisRepas += fraisInstructionDTO.fraisRepas;
                sumFraisPension += fraisInstructionDTO.fraisPension;
            }
            sumFraisDeplacement = Math.min(sumFraisDeplacement, 2700L);
            sumFraisRepas = Math.min(sumFraisRepas, 3000L);
            sumFraisPension = Math.min(sumFraisPension, 10600L - sumFraisRepas - sumFraisDeplacement);
            stack.push((Object)new FraisInstructionDTO(sumFraisDeplacement, sumFraisRepas, sumFraisPension));
        }
    }
}

