/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class CFFraisdeGarde
implements CalcItem {
    private static final BigDecimal FRAIS_DE_GARDE_ICC_MAX = BigDecimal.valueOf(10600L);
    private static final BigDecimal FRAIS_DE_GARDE_ICC_PARTIEL = BigDecimal.valueOf(5300L);
    private static final BigDecimal FRAIS_DE_GARDE_IFD_MAX = BigDecimal.valueOf(25800L);
    private static final BigDecimal FRAIS_DE_GARDE_IFD_PARTIEL = BigDecimal.valueOf(12900L);
    private static final BigDecimal HALF_RATIO = new BigDecimal("0.5", new MathContext(10, RoundingMode.HALF_DOWN));
    private static final FraisDeGardeDTO AUCUN_FRAIS = new FraisDeGardeDTO(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    private static final FraisDeGardeDTO FRAIS_STANDARD = new FraisDeGardeDTO(FRAIS_DE_GARDE_ICC_MAX, FRAIS_DE_GARDE_IFD_MAX);

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        long pensionAlimVersee = StackUtil.getLong((FastStack)stack);
        long pensionAlimRecue = StackUtil.getLong((FastStack)stack);
        long menageAutreParent = StackUtil.getLong((FastStack)stack);
        long autoriteParentale = StackUtil.getLong((FastStack)stack);
        boolean menageEnfant = StackUtil.getBoolean((FastStack)stack);
        boolean gardeAlternee = StackUtil.getBoolean((FastStack)stack);
        stack.push(this.computeFraisDeGarde(pensionAlimVersee, pensionAlimRecue, menageAutreParent, autoriteParentale, menageEnfant, gardeAlternee).dump());
    }

    private FraisDeGardeDTO computeFraisDeGarde(long pensionAlimVersee, long pensionAlimRecue, long menageAutreParent, long autoriteParentale, boolean menageEnfant, boolean gardeAlternee) {
        if (pensionAlimVersee > 0L && menageAutreParent == 2L) {
            return new FraisDeGardeDTO(BigDecimal.ZERO, FRAIS_DE_GARDE_IFD_PARTIEL);
        }
        if (pensionAlimRecue > 0L) {
            if (menageAutreParent == 2L) {
                return new FraisDeGardeDTO(FRAIS_DE_GARDE_ICC_MAX, FRAIS_DE_GARDE_IFD_PARTIEL);
            }
            if (menageAutreParent == 3L && menageEnfant) {
                if (gardeAlternee) {
                    return new FraisDeGardeDTO(FRAIS_DE_GARDE_ICC_MAX, FRAIS_DE_GARDE_IFD_PARTIEL);
                }
                return FRAIS_STANDARD;
            }
            return AUCUN_FRAIS;
        }
        assert (pensionAlimRecue <= 0L);
        if (menageAutreParent == 1L) {
            return FRAIS_STANDARD;
        }
        if (menageAutreParent == 2L) {
            if (autoriteParentale == 1L) {
                return FRAIS_STANDARD;
            }
            if (autoriteParentale == 2L) {
                return AUCUN_FRAIS;
            }
            if (autoriteParentale == 3L) {
                return new FraisDeGardeDTO(FRAIS_DE_GARDE_ICC_PARTIEL, FRAIS_DE_GARDE_IFD_PARTIEL);
            }
            return AUCUN_FRAIS;
        }
        if (menageAutreParent == 3L && menageEnfant) {
            if (gardeAlternee) {
                return new FraisDeGardeDTO(FRAIS_DE_GARDE_ICC_PARTIEL, FRAIS_DE_GARDE_IFD_PARTIEL, HALF_RATIO, BigDecimal.ONE);
            }
            return FRAIS_STANDARD;
        }
        return AUCUN_FRAIS;
    }

    private static long computeFraisAdmis(FastStack stack, boolean icc) {
        FraisDeGardeDTO fraisDeGardeDTO = FraisDeGardeDTO.load((Map)StackUtil.get((FastStack)stack, Map.class, null));
        long frais = StackUtil.getLong((FastStack)stack);
        if (frais > 0L && fraisDeGardeDTO != null) {
            BigDecimal ratio;
            BigDecimal max;
            if (icc) {
                max = fraisDeGardeDTO.maxICC;
                ratio = fraisDeGardeDTO.ratioICC;
            } else {
                max = fraisDeGardeDTO.maxIFD;
                ratio = fraisDeGardeDTO.ratioIFD;
            }
            return BigDecimal.valueOf(frais).multiply(ratio).min(max).longValue();
        }
        return 0L;
    }

    public static class FraisDeGardeDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static final String MAX_ICC = "maxICC";
        static final String MAX_IFD = "maxIFD";
        static final String RATIO_ICC = "ratioICC";
        static final String RATIO_IFD = "ratioIFD";
        final BigDecimal maxICC;
        final BigDecimal maxIFD;
        final BigDecimal ratioICC;
        final BigDecimal ratioIFD;

        FraisDeGardeDTO() {
            this(BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
        }

        FraisDeGardeDTO(BigDecimal maxICC, BigDecimal maxIFD) {
            this(maxICC, maxIFD, BigDecimal.ONE, BigDecimal.ONE);
        }

        FraisDeGardeDTO(BigDecimal maxICC, BigDecimal maxIFD, BigDecimal ratioICC, BigDecimal ratioIFD) {
            assert (maxICC != null && maxIFD != null && ratioICC != null && ratioIFD != null);
            this.maxICC = maxICC;
            this.maxIFD = maxIFD;
            this.ratioICC = ratioICC;
            this.ratioIFD = ratioIFD;
        }

        Map<String, Object> dump() {
            HashMap<String, Object> dto = new HashMap<String, Object>(3);
            dto.put(MAX_ICC, this.maxICC);
            dto.put(MAX_IFD, this.maxIFD);
            dto.put(RATIO_ICC, this.ratioICC);
            dto.put(RATIO_IFD, this.ratioIFD);
            return dto;
        }

        static FraisDeGardeDTO load(Map<?, ?> data) {
            if (data == null) {
                return new FraisDeGardeDTO();
            }
            Object maxICC = data.get(MAX_ICC);
            Object maxIFD = data.get(MAX_IFD);
            Object ratioICC = data.get(RATIO_ICC);
            Object ratioIFD = data.get(RATIO_IFD);
            return new FraisDeGardeDTO(maxICC != null ? (BigDecimal)maxICC : BigDecimal.ZERO, maxIFD != null ? (BigDecimal)maxIFD : BigDecimal.ZERO, ratioICC != null ? (BigDecimal)ratioICC : BigDecimal.ZERO, ratioIFD != null ? (BigDecimal)ratioIFD : BigDecimal.ZERO);
        }
    }

    public static class FraisAdmisIFD
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            stack.push((Object)CFFraisdeGarde.computeFraisAdmis(stack, false));
        }
    }

    public static class FraisAdmisICC
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            stack.push((Object)CFFraisdeGarde.computeFraisAdmis(stack, true));
        }
    }

    public static class GetFraisDeGardeMax
    implements CalcItem {
        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
            FraisDeGardeDTO fraisDeGardeDTO = FraisDeGardeDTO.load((Map)StackUtil.get((FastStack)stack, Map.class, null));
            BigDecimal maxICC = GetFraisDeGardeMax.effectiveMaximum(fraisDeGardeDTO.maxICC, fraisDeGardeDTO.ratioICC);
            BigDecimal maxIFD = GetFraisDeGardeMax.effectiveMaximum(fraisDeGardeDTO.maxIFD, fraisDeGardeDTO.ratioIFD);
            stack.push((Object)maxICC.max(maxIFD).longValue());
        }

        private static BigDecimal effectiveMaximum(BigDecimal max, BigDecimal ratio) {
            if (BigDecimal.ZERO.compareTo(ratio) == 0) {
                return BigDecimal.ZERO;
            }
            return max.divide(ratio);
        }
    }
}

