/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ju.transfer.dto.ImpotsCommunauxModelItem;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.Map;

public class CFImpotEcclesiastique
implements CalcItem {
    private static final MathContext MC = new MathContext(5, RoundingMode.HALF_DOWN);
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
    private static final BigDecimal ROUNDING_UNIT = BigDecimal.valueOf(0.05);
    private final DataResource dataResource;

    public CFImpotEcclesiastique(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        BigDecimal impotEcclesiastique;
        String fileName = StackUtil.getString((FastStack)stack);
        long confessionConjoint = StackUtil.getLong((FastStack)stack);
        long confessionContribuable = StackUtil.getLong((FastStack)stack);
        long etatCivil = StackUtil.getLong((FastStack)stack);
        long idCommune = StackUtil.getLong((FastStack)stack);
        BigDecimal baseCalcul = BigDecimal.valueOf(StackUtil.getFloat((FastStack)stack));
        Map impotsCommunaux = this.dataResource.get(fileName, null, null);
        if (etatCivil == 2L) {
            BigDecimal tauxConfessionContribuable = this.lookupTauxConfession(impotsCommunaux, idCommune, confessionContribuable);
            BigDecimal tauxConfessionConjoint = this.lookupTauxConfession(impotsCommunaux, idCommune, confessionConjoint);
            baseCalcul = baseCalcul.divide(TWO, MC);
            impotEcclesiastique = tauxConfessionContribuable.multiply(baseCalcul).add(tauxConfessionConjoint.multiply(baseCalcul));
        } else {
            BigDecimal tauxConfessionContribuable = this.lookupTauxConfession(impotsCommunaux, idCommune, confessionContribuable);
            impotEcclesiastique = tauxConfessionContribuable.multiply(baseCalcul);
        }
        impotEcclesiastique = impotEcclesiastique.divide(ROUNDING_UNIT).setScale(0, RoundingMode.UP).multiply(ROUNDING_UNIT);
        stack.push((Object)impotEcclesiastique.doubleValue());
    }

    private BigDecimal lookupTauxConfession(Map<?, ?> aMap, long id, long confession) {
        Iterator<?> enumItems = aMap.values().iterator();
        BigDecimal result = null;
        block4: while (enumItems.hasNext()) {
            ImpotsCommunauxModelItem anItem = (ImpotsCommunauxModelItem)enumItems.next();
            if (anItem.getIdCommune() != id) continue;
            switch ((int)confession) {
                case 1: {
                    result = BigDecimal.valueOf(anItem.getPourcentImpotCatholique());
                    continue block4;
                }
                case 2: {
                    result = BigDecimal.valueOf(anItem.getPourcentImpotReforme());
                    continue block4;
                }
            }
            result = BigDecimal.ZERO;
        }
        return result != null ? result.divide(ONE_HUNDRED, MC) : BigDecimal.ZERO;
    }
}

