/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.ju.presentation.common.JuDataResourceBase;
import java.util.Map;

public class CFMonnaie
implements CalcItem {
    private final DataResource dataResource;
    private int decimalPlaces = 0;

    public CFMonnaie(DataResource dataResource) {
        this.dataResource = dataResource;
    }

    public CFMonnaie(DataResource dataResource, int decimalPlaces) {
        this.dataResource = dataResource;
        this.decimalPlaces = decimalPlaces;
    }

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        Map optionMap;
        OptionItemDTO optionItemDTO;
        Object coursObj = stack.pop();
        Object monnaieObj = stack.pop();
        Object avoirObj = stack.pop();
        double cours = 0.0;
        String monnaie = "";
        double avoir = 0.0;
        if (coursObj instanceof Number) {
            cours = ((Number)coursObj).doubleValue();
        }
        if (monnaieObj != null) {
            monnaie = monnaieObj.toString();
        }
        if (avoirObj instanceof Number) {
            avoir = ((Number)avoirObj).doubleValue();
        }
        if ("1".equals(monnaie)) {
            cours = 1.0;
        }
        if ((optionItemDTO = (OptionItemDTO)(optionMap = this.dataResource.get(JuDataResourceBase.ResourceEnum.MONNAIE.getCode(), null, null)).get(String.valueOf(monnaie))) != null) {
            if (this.decimalPlaces > 0) {
                double factor = Math.pow(10.0, this.decimalPlaces);
                long result = Math.round(cours * avoir * factor);
                stack.push((Object)((double)result / factor));
            } else {
                long result = Math.round(cours * avoir);
                stack.push((Object)result);
            }
        } else {
            stack.push((Object)0);
        }
    }
}

