/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ju.presentation.common.JuDataResourceBase;
import java.util.Map;

public class CFNoFederalCommune
implements CalcItem {
    private final DataResource dataResource;

    public CFNoFederalCommune(DataResource dataResource) {
        if (dataResource == null) {
            throw new NullPointerException("Data resource cannot be null");
        }
        this.dataResource = dataResource;
    }

    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        stack.push((Object)this.getNoFederal((Long)StackUtil.get((FastStack)stack, Long.class, null)));
    }

    private Long getNoFederal(Long noCantonal) {
        if (noCantonal == null) {
            return null;
        }
        Map mappings = this.dataResource.get(JuDataResourceBase.ResourceEnum.COMMUNES_NO_FEDERAUX.getCode(), null, null);
        Long noFederal = (Long)mappings.get(noCantonal);
        if (noFederal == null) {
            throw new IllegalArgumentException("Cannot find mapping for municipality id " + noCantonal);
        }
        return noFederal;
    }
}

