/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.util.StackUtil;
import ch.dvbern.tax.ju.DateUtil;
import ch.dvbern.tax.ju.engine.calcitems.CFDesignationAge;
import java.time.LocalDate;
import java.util.Date;

public class CFPensionAlimEnfantAdmis
implements CalcItem {
    public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String dataModelKey) {
        Date birthDate = (Date)StackUtil.get((FastStack)stack, Date.class, null);
        CFDesignationAge.Designation designation = CFDesignationAge.Designation.forCode(StackUtil.getInteger((FastStack)stack));
        long amount = StackUtil.getLong((FastStack)stack);
        stack.push((Object)this.getMontantAdmis(designation, birthDate, amount));
    }

    private long getMontantAdmis(CFDesignationAge.Designation designation, Date birthDate, long amount) {
        if (designation == null || birthDate == null) {
            return 0L;
        }
        LocalDate birthLocalDate = DateUtil.getLocalDate(birthDate);
        switch (designation) {
            case MINEUR: {
                return amount;
            }
            case AGE_18: {
                return amount * (long)birthLocalDate.getMonthValue() / 12L;
            }
            case MAJEUR: {
                return 0L;
            }
        }
        assert (false) : "Unknown enum member";
        return 0L;
    }
}

