/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitText
implements CalcItem {
    private static final Logger LOG = LoggerFactory.getLogger(SplitText.class);

    public void evaluate(LogicModelItem.ProtectedMap model, FastStack stack, String dataModelKey) {
        if (stack == null || stack.size() != 3 || stack.peek() == null) {
            return;
        }
        String part = stack.pop().toString();
        if (stack.peek() == null || part == null) {
            return;
        }
        if (!part.equals("first") && !part.equals("last")) {
            throw new IllegalArgumentException("The argument 'part' has to be 'first' or 'last'. The argument you supplied is: " + part);
        }
        Long lineLength = (Long)stack.pop();
        if (stack.peek() == null || lineLength == null) {
            return;
        }
        String text = stack.pop().toString();
        if (text.isEmpty()) {
            stack.push((Object)"");
            return;
        }
        String result = "";
        try {
            result = this.getStringPart(part, lineLength, text).trim();
        }
        catch (Exception d) {
            LOG.error("CANNOT SPLIT TEXT. Part={} Lengh={}, Text=>>>{}<<<", new Object[]{part, lineLength, text, d});
        }
        stack.push((Object)result);
    }

    public String getStringPart(@NonNull String part, @NonNull Long lineLength, @NonNull String text) {
        ArrayList<String> textToken = new ArrayList<String>();
        String regEx = "\\S.{1," + (lineLength - 3L) + "}\\s?\\W?(\\s|$)";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            textToken.add(matcher.group());
        }
        if (!textToken.isEmpty()) {
            if (part.equals("first")) {
                return ((String)textToken.get(0)).trim();
            }
            if (textToken.size() > 1 && part.equals("last")) {
                return ((String)textToken.get(1)).trim();
            }
        }
        return "";
    }
}

