/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.expertdisplay;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.engine.expertdisplay.BarcodeItem;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BarcodeFormTableGenerator {
    private static final String KEY_TOTAL_ERTRAG_OHNE_VST = ".TotalErtragOhneVST";
    private static final String KEY_TOTAL_ERTRAG_VST = ".TotalErtragVST";
    private static final String KEY_TOTAL_STEUERWERT = ".TotalSteuerwert";
    private static final String KEY_DATUM_EROEFFNUNG = ".DatumEroeffnung";
    private static final String KEY_HERKUNFT = ".Herkunft";
    private static final String KEY_ERELEVE = ".HasEreleve";
    private final Map<FORM, List<List<BarcodeItem>>> tables = new EnumMap<FORM, List<List<BarcodeItem>>>(FORM.class);
    private static final String FORMULAR_TITRES = "0005";
    private final ExpertDisplayModel.ProtectedMap dataModel;

    public BarcodeFormTableGenerator(ExpertDisplayModel.ProtectedMap dataModel) {
        if (dataModel == null) {
            throw new NullPointerException("Data model cannot be null.");
        }
        this.dataModel = dataModel;
    }

    public synchronized List<List<BarcodeItem>> getFormTable(FORM form) {
        List<List<BarcodeItem>> result = this.tables.get((Object)form);
        if (result != null) {
            return result;
        }
        switch (form.ordinal()) {
            case 0: {
                result = this.generateWertschrifften();
                break;
            }
            default: {
                throw new AssertionError((Object)("Table form not supported: " + String.valueOf((Object)form)));
            }
        }
        this.tables.put(form, result);
        return result;
    }

    private List<List<BarcodeItem>> generateWertschrifften() {
        LinkedList<List<BarcodeItem>> table = new LinkedList<List<BarcodeItem>>();
        BarcodeFormTableGenerator.getComptes(this.dataModel, table);
        BarcodeFormTableGenerator.getActions(this.dataModel, table);
        BarcodeFormTableGenerator.getDividendes(this.dataModel, table);
        BarcodeFormTableGenerator.getObligations(this.dataModel, table);
        BarcodeFormTableGenerator.getPrets(this.dataModel, table);
        BarcodeFormTableGenerator.getRelevesBanquaires(this.dataModel, table);
        BarcodeFormTableGenerator.getDivers(this.dataModel, table);
        BarcodeFormTableGenerator.getLoto(this.dataModel, table);
        BarcodeFormTableGenerator.getDa1Rus(this.dataModel, table);
        BarcodeFormTableGenerator.getParticipationSuccession(this.dataModel, table);
        BarcodeFormTableGenerator.getDonationsRecues(this.dataModel, table);
        BarcodeFormTableGenerator.getDonationsVersees(this.dataModel, table);
        return table;
    }

    private static void getDonationsVersees(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesReleveBancaire = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Donation.DonationFaite");
        if (linesReleveBancaire != null) {
            for (String lineKey : linesReleveBancaire) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Donation.DonationFaite." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + ".DonationOuAvancement"));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.220-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ImmeubleOuAutre"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.221-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".NomPrenom"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.222-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Adresse"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.223-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".LienParente"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.224-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".DateDonation"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.225-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Montant"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.226-01", "N", value);
                    line.add(item);
                }
                table.add(line);
            }
        }
    }

    private static void getDonationsRecues(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesReleveBancaire = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Donation.DonationRecue");
        if (linesReleveBancaire != null) {
            for (String lineKey : linesReleveBancaire) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Donation.DonationRecue." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + ".DonationOuAvancement"));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.210-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ImmeubleOuAutre"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.211-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".NomPrenom"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.212-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Adresse"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.213-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".LienParente"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.214-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".DateDonation"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.215-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Montant"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.216-01", "N", value);
                    line.add(item);
                }
                table.add(line);
            }
        }
    }

    private static void getParticipationSuccession(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesReleveBancaire = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Succession.Succession");
        if (linesReleveBancaire != null) {
            for (String lineKey : linesReleveBancaire) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Succession.Succession." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + ".Nom"));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.200-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Adresse"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.201-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".DatePartage"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.202-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Montant"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.203-01", "N", value);
                    line.add(item);
                }
                table.add(line);
            }
        }
    }

    private static void getDa1Rus(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        ModelItemDTO modelItemDTOErtrag = dataModel.get((Object)"Wertschriften.Ergaenzungsblaetter.TotalErtragOhneVST");
        ModelItemDTO modelItemDTOSteuerwert = dataModel.get((Object)"Wertschriften.Ergaenzungsblaetter.TotalSteuerwert");
        ModelItemDTO modelItemDTORus164MontantRetenueSupplementaire = dataModel.get((Object)"Wertschriften.Ergaenzungsblaetter.MontantRetenueSupplementaire");
        ModelItemDTO modelItemDTODa1MontantImpotEtranger = dataModel.get((Object)"Wertschriften.Ergaenzungsblaetter.MontantImpotEtranger");
        ModelItemDTO modelItemDTODa1Ereleve = dataModel.get((Object)"Wertschriften.Ergaenzungsblaetter.DA1RUS.HasEreleve");
        ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
        if (modelItemDTOErtrag != null && modelItemDTOErtrag.getValue() != null || modelItemDTOSteuerwert != null && modelItemDTOSteuerwert.getValue() != null) {
            BarcodeItem item = new BarcodeItem(FORMULAR_TITRES, "340.82-01", "A", "Report annexe DA-1 et R-US");
            line.add(item);
            Object value = modelItemDTOSteuerwert.getValue();
            item = new BarcodeItem(FORMULAR_TITRES, "340.87-01", "N", value);
            line.add(item);
            value = modelItemDTOErtrag.getValue();
            item = new BarcodeItem(FORMULAR_TITRES, "340.89-01", "N", value);
            line.add(item);
            if (modelItemDTORus164MontantRetenueSupplementaire != null && modelItemDTORus164MontantRetenueSupplementaire.getValue() != null) {
                value = modelItemDTORus164MontantRetenueSupplementaire.getValue();
                item = new BarcodeItem(FORMULAR_TITRES, "340.890-01", "F2", value);
                line.add(item);
            }
            if (modelItemDTODa1MontantImpotEtranger != null && modelItemDTODa1MontantImpotEtranger.getValue() != null) {
                value = modelItemDTODa1MontantImpotEtranger.getValue();
                item = new BarcodeItem(FORMULAR_TITRES, "340.990-01", "F2", value);
                line.add(item);
            }
            if (modelItemDTODa1Ereleve != null) {
                value = modelItemDTODa1Ereleve.getValue();
                boolean isEreleve = value != null && (Boolean)value != false;
                item = new BarcodeItem(FORMULAR_TITRES, "340.999-01", "N", isEreleve ? 1 : 0);
                line.add(item);
            }
            table.add(line);
        }
    }

    private static void getLoto(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        Object value;
        ModelItemDTO modelItemDTOErtragVst = dataModel.get((Object)"Wertschriften.Lotto.ErtragVST");
        ModelItemDTO modelItemDTOErtragOhneVst = dataModel.get((Object)"Wertschriften.Lotto.ErtragOhneVST");
        ModelItemDTO modelItemDTONaturalgewinneOhneVST = dataModel.get((Object)"Wertschriften.Lotto.NaturalgewinneOhneVST");
        ModelItemDTO modelItemDTOAbzugLottoBund = dataModel.get((Object)"Wertschriften.Lotto.AbzugLottoBund");
        ArrayList<BarcodeItem> lineLoterie = new ArrayList<BarcodeItem>();
        if (modelItemDTOErtragVst != null && (value = modelItemDTOErtragVst.getValue()) != null) {
            lineLoterie.add(new BarcodeItem(FORMULAR_TITRES, "340.68-01", "N", value));
        }
        if (modelItemDTOErtragOhneVst != null && (value = modelItemDTOErtragOhneVst.getValue()) != null) {
            lineLoterie.add(new BarcodeItem(FORMULAR_TITRES, "340.69-01", "N", value));
        }
        if (modelItemDTOAbzugLottoBund != null && (value = modelItemDTOAbzugLottoBund.getValue()) != null) {
            lineLoterie.add(new BarcodeItem(FORMULAR_TITRES, "340.70-02", "N", value));
        }
        if (!lineLoterie.isEmpty()) {
            lineLoterie.add(0, new BarcodeItem(FORMULAR_TITRES, "340.61-01", "A", "G"));
            lineLoterie.add(1, new BarcodeItem(FORMULAR_TITRES, "340.62-01", "A", "Gains de loterie, Sport-Toto et PMU"));
            table.add(lineLoterie);
        }
        ArrayList<BarcodeItem> lineNature = new ArrayList<BarcodeItem>();
        if (modelItemDTONaturalgewinneOhneVST != null && modelItemDTONaturalgewinneOhneVST.getValue() != null) {
            BarcodeItem item = new BarcodeItem(FORMULAR_TITRES, "340.72-01", "A", "Gains en nature");
            lineNature.add(item);
            Object value2 = modelItemDTONaturalgewinneOhneVST.getValue();
            item = new BarcodeItem(FORMULAR_TITRES, "340.79-01", "N", value2);
            lineNature.add(item);
            table.add(lineNature);
        }
    }

    private static void getDivers(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesDivers = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Diverse.Diverse");
        if (linesDivers != null) {
            for (String lineKey : linesDivers) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Diverse.Diverse." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + KEY_HERKUNFT));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.50-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Nennwert"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.51-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Bezeichnung"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.52-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_DATUM_EROEFFNUNG))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.53-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".DatumVerfall"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.54-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ZinssatzProzent"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.55-01", "F4", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".SteuerwertProzent"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.56-01", "F4", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_STEUERWERT))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.57-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.58-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_OHNE_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.59-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_ERELEVE))) != null) {
                    value = modelItemDTO.getValue();
                    boolean isEreleve = value != null && (Boolean)value != false;
                    BarcodeItem item2 = new BarcodeItem(FORMULAR_TITRES, "340.999-01", "N", isEreleve ? 1 : 0);
                    line.add(item2);
                }
                table.add(line);
            }
        }
    }

    private static void getRelevesBanquaires(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesReleveBancaire = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Bankverzeichnis.Bankverzeichnis");
        if (linesReleveBancaire != null) {
            for (String lineKey : linesReleveBancaire) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Bankverzeichnis.Bankverzeichnis." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + KEY_HERKUNFT));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.40-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ConcatNameBezeichnung"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.42-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".TotalKosten"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.43-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_STEUERWERT))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.47-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.48-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_OHNE_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.49-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".TotalErtragGV"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.490-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".TotalSteuerwertGV"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.491-01", "N", value);
                    line.add(item);
                }
                table.add(line);
            }
        }
    }

    private static void getPrets(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesPrets = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Darlehen.Darlehen");
        if (linesPrets != null) {
            for (String lineKey : linesPrets) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Darlehen.Darlehen." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + KEY_HERKUNFT));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.30-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".BezeichnungToPrint"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.32-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_DATUM_EROEFFNUNG))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.33-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".DatumVerfall"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.34-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_STEUERWERT))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.37-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.38-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_OHNE_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.39-01", "N", value);
                    line.add(item);
                }
                table.add(line);
            }
        }
    }

    private static void getObligations(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesObligations = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Obligationen.Obligationen");
        if (linesObligations != null) {
            for (String lineKey : linesObligations) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Obligationen.Obligationen." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + KEY_HERKUNFT));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.20-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Nennwert"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.21-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ValorenNr"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.2200-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Bezeichnung"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.22-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_DATUM_EROEFFNUNG))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.23-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".DatumVerfall"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.24-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ZinssatzProzent"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.25-01", "F4", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".SteuerwertProzent"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.26-01", "F4", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_STEUERWERT))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.27-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.28-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_OHNE_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.29-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_ERELEVE))) != null) {
                    value = modelItemDTO.getValue();
                    boolean isEreleve = value != null && (Boolean)value != false;
                    BarcodeItem item2 = new BarcodeItem(FORMULAR_TITRES, "340.999-01", "N", isEreleve ? 1 : 0);
                    line.add(item2);
                }
                table.add(line);
            }
        }
    }

    private static void getDividendes(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesDividendes = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Dividendes.Dividendes");
        if (linesDividendes != null) {
            for (String lineKey : linesDividendes) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Dividendes.Dividendes." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + ".HerkunftPrint"));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.100-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".AnzahlEndeJahr"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.101-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Bezeichnung"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.102-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".KaufToPrint"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.103-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".VerkaufToPrint"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.104-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ErtragProStk"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.105-01", "F4", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".SteuerwertProStk"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.106-01", "F4", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_STEUERWERT))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.107-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.108-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_OHNE_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.109-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ReductionOhneVST"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.110-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ReductionVST"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.111-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ImposableOhneVST"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.112-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ImposableVST"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.113-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ValorenNr"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.115-01", "A", value);
                    line.add(item);
                }
                table.add(line);
            }
        }
    }

    private static void getActions(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesActions = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Aktien.Aktien");
        if (linesActions != null) {
            for (String lineKey : linesActions) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Aktien.Aktien." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + KEY_HERKUNFT));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.10-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".AnzahlEndeJahr"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.11-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ValorenNr"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.120-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Bezeichnung"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.12-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".KaufToPrint"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.13-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".VerkaufToPrint"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.14-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".ErtragProStk"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.15-01", "F4", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".SteuerwertProStk"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.16-01", "F4", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_STEUERWERT))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.17-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.18-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_OHNE_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.19-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_ERELEVE))) != null) {
                    value = modelItemDTO.getValue();
                    boolean isEreleve = value != null && (Boolean)value != false;
                    BarcodeItem item2 = new BarcodeItem(FORMULAR_TITRES, "340.999-01", "N", isEreleve ? 1 : 0);
                    line.add(item2);
                }
                table.add(line);
            }
        }
    }

    private static void getComptes(ExpertDisplayModel.ProtectedMap dataModel, List<List<BarcodeItem>> table) {
        List<String> linesAvoirs = JuUtil.getTableIndexesFromModel((LogicModelItem.ProtectedMap)dataModel, "Wertschriften.Konti.Konti");
        if (linesAvoirs != null) {
            for (String lineKey : linesAvoirs) {
                BarcodeItem item;
                Object value;
                ArrayList<BarcodeItem> line = new ArrayList<BarcodeItem>();
                String key = "Wertschriften.Konti.Konti." + lineKey;
                ModelItemDTO modelItemDTO = dataModel.get((Object)(key + KEY_HERKUNFT));
                if (modelItemDTO != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.00-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Kontonummer"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.01-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".Bankname"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.02-01", "A", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_DATUM_EROEFFNUNG))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.03-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".DatumAufloesung"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.04-01", "D", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".TotalKostenKontiErfasst"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.05-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_STEUERWERT))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.07-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.08-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_TOTAL_ERTRAG_OHNE_VST))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.09-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + ".KostenKonto"))) != null) {
                    value = modelItemDTO.getValue();
                    item = new BarcodeItem(FORMULAR_TITRES, "340.05-01", "N", value);
                    line.add(item);
                }
                if ((modelItemDTO = dataModel.get((Object)(key + KEY_ERELEVE))) != null) {
                    value = modelItemDTO.getValue();
                    boolean isEreleve = value != null && (Boolean)value != false;
                    BarcodeItem item2 = new BarcodeItem(FORMULAR_TITRES, "340.999-01", "N", isEreleve ? 1 : 0);
                    line.add(item2);
                }
                table.add(line);
            }
        }
    }

    public static enum FORM {
        WERTSCHRIFFTEN;

    }
}

