/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.expertdisplay;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.DateUtil;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.SystemInfo;
import ch.dvbern.tax.ju.engine.expertdisplay.BarcodeFormTableGenerator;
import ch.dvbern.tax.ju.engine.expertdisplay.BarcodeItem;
import ch.dvbern.tax.ju.engine.util.PKey;
import ch.dvbern.tax.ju.engine.util.PKeyTemplate;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BarcodeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BarcodeHelper.class);
    private static final DateTimeFormatter TIMESTAMP_FMT = DateTimeFormatter.ofPattern("yyyy-MM-dd", JuUtil.APPLICATION_LOCALE).withZone(DateUtil.APPLICATION_TIMEZONE);
    private static final String BARCODE_TXT_RESOURCE_FPATH = "barcode.txt";
    private static final String PERSISTENCE_KEY_SEP = ";";
    private static final String BARCODE_COMMENT_TAG = "#";
    private static final String BARCODE_FORM_START_TAG_PREFIX = "<Form";
    private static final String BARCODE_FORM_END_TAG = "</Form>";
    private static final String BARCODE_FORM_TABLE_START_TAG_PREFIX = "<form-table";
    private static final String BARCODE_FORM_TABLE_END_TAG_PREFIX = "</form-table";
    private static final String BARCODE_TABLE_START_TAG = "<table>";
    private static final String BARCODE_TABLE_END_TAG = "</table>";
    private static final char SPACE = ' ';
    private static final String CRLF = "\r\n";
    private static final String QUOTE = "\"";
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>";
    private static final String BEGIN_DOC = "<doc xmlns=\"http://dvbern.ch/taxme/ju/barcode/\">";
    private static final String END_DOC = "</doc>";
    private static final String INTERFACE_HEADER = "ii";
    private static final String INTERFACE_DEF = "id";
    private static final String BEGIN_FORMULAR_HEADER = "<fh id=";
    private static final String END_FORMULAR_HEADER = "</fh>";
    private static final String FORMULAR_DESC = "desc=";
    private static final String BEGIN_FORMULAR_DATA = "<fd>";
    private static final String END_FORMULAR_DATA = "</fd>";
    private static final String BEGIN_TABLE = "<tb>";
    private static final String END_TABLE = "</tb>";
    private static final String BEGIN_TABLE_ROW = "<td>";
    private static final String END_TABLE_ROW = "</td>";
    private static final String BEGIN_TAG = "<";
    private static final String END_TAG = "/>";
    private static final String END_LINE_TAG = ">";
    private static final String PERIOD = "period=";
    private static final String DATE_NOW = "date=";
    private static final String PROVIDER = "provider=";
    private static final String VERSION = "version=";
    private static final String FIRSTNAME = "firstname=";
    private static final String LASTNAME = "lastname=";
    private static final String ADDRESS = "addr=";
    private static final String ZIP = "zip=";
    private static final String CITY = "city=";
    private static final String NO_CONTRIBUABLE = "sno=";
    private static final String BEGIN_FIELD = "<dr f=";
    private static final String CODE = "c=";
    private static final String VALUE = "v=";
    private static final String IMMEUBLES_FRAIS_FORFAITAIRE_LMK = "Liegenschaft.Immeubles.TableImmeubles.RecapFraisEntretien.DeductionForfaitaireOuiNon";
    private static final String IMMEUBLES_FRAIS_EFFECTIFS_TABLE_LMK = "Liegenschaft.Immeubles.TableImmeubles.FraisEntretien.TableFraisEntretien";

    private BarcodeHelper() {
    }

    public static String generate(ExpertDisplayModel.ProtectedMap dataModel, Map<String, LogicModelItem> logicModel, Instant timestamp, String anneeTaxation, String firstname, String lastname, String addr, String zip, String city, String noContribuable, UploadConfiguration.UploadType uploadType, SystemInfo sysInfo) throws IOException {
        BarcodeFormTableGenerator formTableGenerator = new BarcodeFormTableGenerator(dataModel);
        String now = TIMESTAMP_FMT.format(timestamp);
        String provider = "JU";
        String version = ApplicationConfig.getInstance().getApplicationVersion();
        StringBuffer buf = new StringBuffer();
        buf.append(BarcodeHelper.generateBeginDoc());
        buf.append(BarcodeHelper.generateBeginFile(anneeTaxation, now, "JU", version));
        buf.append(BarcodeHelper.generateTaxInformation(firstname, lastname, addr, zip, city, noContribuable));
        BarcodeStructure barcodeStructure = BarcodeHelper.generateBarcodeStructure();
        BarcodeHelper.generateBarcodeData(barcodeStructure, dataModel, logicModel);
        BarcodeHelper.generateContextData(barcodeStructure, JuUtil.getApplicationProfile(), uploadType, sysInfo);
        BarcodeHelper.writeBarcodeData(buf, barcodeStructure.getRoot());
        buf.append(BarcodeHelper.generateFormularTitre(formTableGenerator));
        buf.append(BarcodeHelper.generateEndDoc());
        return buf.toString();
    }

    private static void writeBarcodeData(StringBuffer buf, Map<String, Object> barcodeData) {
        for (Object o : barcodeData.values()) {
            if (o instanceof BarcodeLevelFormular) {
                BarcodeLevelFormular blf = (BarcodeLevelFormular)o;
                for (Object value : blf.values()) {
                    Map tableEntryData = (Map)value;
                    buf.append(BarcodeHelper.generateBeginFormular(blf.formKey, blf.formName));
                    BarcodeHelper.writeBarcodeData(buf, tableEntryData);
                    buf.append(BarcodeHelper.generateEndFormular());
                }
                continue;
            }
            if (o instanceof Map) {
                buf.append(BarcodeHelper.generateTableBegin());
                for (Object value : ((Map)o).values()) {
                    Map tableEntryData = (Map)value;
                    buf.append(BarcodeHelper.generateTableLineBegin());
                    BarcodeHelper.writeBarcodeData(buf, tableEntryData);
                    buf.append(BarcodeHelper.generateTableLineEnd());
                }
                buf.append(BarcodeHelper.generateTableEnd());
                continue;
            }
            if (o instanceof BarcodeItem) {
                buf.append(BarcodeHelper.generateField((BarcodeItem)o));
                continue;
            }
            if (o == null) continue;
            buf.append(o.toString());
        }
    }

    private static BufferedReader getBarcodeReader() {
        return new BufferedReader(new InputStreamReader(BarcodeHelper.class.getResourceAsStream(BARCODE_TXT_RESOURCE_FPATH), JuUtil.UTF_8));
    }

    private static void generateBarcodeData(BarcodeStructure barcodeStructure, ExpertDisplayModel.ProtectedMap dataModel, Map<String, LogicModelItem> logicModel) throws IOException {
        LinkedList set = new LinkedList(dataModel.keySet());
        ArrayList<String> list = BarcodeHelper.getAllBarcodeKeys();
        list.stream().filter(aList -> !set.contains(aList)).forEach(set::add);
        Collections.sort(set);
        for (String dmk : set) {
            Boolean fraisImmeubleForfait;
            ModelItemDTO item;
            String lmk;
            Object value;
            ModelItemDTO modelItemDTO = dataModel.get((Object)dmk);
            if (modelItemDTO == null || (value = modelItemDTO.getValue()) == null || value.equals("0") || (lmk = EngineUtil.removeTableIndices((String)dmk)).startsWith(IMMEUBLES_FRAIS_EFFECTIFS_TABLE_LMK) && (item = dataModel.get((Object)EngineUtil.mergeModelKey((String)IMMEUBLES_FRAIS_FORFAITAIRE_LMK, (String)dmk))) != null && (fraisImmeubleForfait = (Boolean)item.getValue()) != null && fraisImmeubleForfait.booleanValue()) continue;
            LogicModelItem logicModelItem = logicModel.get(EngineUtil.removeTableIndices((String)dmk));
            if (logicModelItem != null) {
                List pkts = logicModelItem.getPersistenceKeyTemplates();
                for (String persistenceKey : pkts) {
                    if (!persistenceKey.contains(PERSISTENCE_KEY_SEP)) {
                        LOG.debug("Ignore non-standard persistence key '{}' for dmk '{}'", (Object)persistenceKey, (Object)dmk);
                        continue;
                    }
                    PKeyTemplate pKeyTemplate = PKeyTemplate.parse(persistenceKey);
                    if (pKeyTemplate.pkTuple.isIntern()) continue;
                    String formular = null;
                    String code = null;
                    String format = null;
                    LinkedList<String> tableRefs = new LinkedList<String>();
                    boolean isValidPKey = true;
                    persistenceKey = EngineUtil.convertPersistenceKey((String)persistenceKey, (String)dmk);
                    String[] lmkTableTokens = logicModelItem.getNameWithTableIndexShapes().split("\\.#\\.");
                    assert (lmkTableTokens.length > 0 && lmkTableTokens.length <= 3) : "Only two table level supported.";
                    String[] tokens = persistenceKey.split(PERSISTENCE_KEY_SEP);
                    switch (tokens.length) {
                        case 5: {
                            isValidPKey = lmkTableTokens.length == 3;
                            tableRefs.add(lmkTableTokens[0] + "." + lmkTableTokens[1] + ":" + tokens[4]);
                        }
                        case 4: {
                            isValidPKey = isValidPKey && lmkTableTokens.length >= 2;
                            tableRefs.add(0, lmkTableTokens[0] + ":" + tokens[3]);
                        }
                        case 3: {
                            formular = tokens[0];
                            code = tokens[1];
                            format = tokens[2];
                            break;
                        }
                        default: {
                            isValidPKey = false;
                        }
                    }
                    if (!isValidPKey) {
                        String msg = String.format("Invalid pkey '%s' for dmk '%s'.", persistenceKey, dmk);
                        assert (false) : msg;
                        LOG.warn(msg);
                        continue;
                    }
                    BarcodeItem item2 = new BarcodeItem(formular, code, format, value, dmk);
                    StringBuilder sb = new StringBuilder(formular).append(PERSISTENCE_KEY_SEP).append(code);
                    Map<String, Object> itemLevel = BarcodeHelper.getItemLevel(barcodeStructure, sb.toString(), tableRefs);
                    if (itemLevel != null) {
                        boolean duplicate;
                        boolean bl = duplicate = itemLevel.put(sb.toString(), item2) != null;
                        assert (!duplicate) : "Duplicate value resolved in barcode.";
                        continue;
                    }
                    LOG.debug("No barcode mapping found for pkey '" + persistenceKey + "' (dmk: '" + dmk + "')");
                }
                continue;
            }
            LOG.warn("No LMI found for dmk: '" + dmk + "'. Skip it.");
        }
    }

    private static Map<String, Object> getItemLevel(BarcodeStructure barcodeStructure, String key, List<String> indizes) {
        List levels = barcodeStructure.getItems().get(key);
        if (levels == null) {
            return null;
        }
        LinkedHashMap result = barcodeStructure.getRoot();
        for (int i = 1; i < levels.size(); ++i) {
            BarcodeLevel barcodeLevel = (BarcodeLevel)levels.get(i);
            Map<Object, Map> indexMap = (Map<Object, Map>)result.get(barcodeLevel.getKey());
            if (indexMap == null) {
                indexMap = barcodeLevel.newLevelMap();
                result.put(barcodeLevel.getKey(), indexMap);
            }
            try {
                String index = indizes.get(i - 1);
                LinkedHashMap currentLevel = indexMap.get(index);
                if (currentLevel == null) {
                    currentLevel = new LinkedHashMap(barcodeLevel);
                    indexMap.put(index, currentLevel);
                }
                result = currentLevel;
                continue;
            }
            catch (IndexOutOfBoundsException ioobe) {
                assert (false) : "Data structure inconsistencies.";
                LOG.warn("warning: missing index in structure " + key);
                return null;
            }
        }
        return result;
    }

    private static ArrayList<String> getAllBarcodeKeys() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = BarcodeHelper.getBarcodeReader();
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("000")) {
                    list.add(line);
                }
                line = reader.readLine();
            }
        }
        finally {
            BarcodeHelper.tryClose(reader);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BarcodeStructure generateBarcodeStructure() throws IOException {
        BarcodeLevel rootLevel = new BarcodeLevel("root");
        Stack<BarcodeLevel> levelStack = new Stack<BarcodeLevel>();
        levelStack.push(rootLevel);
        int structureId = 0;
        LinkedHashMap<String, LinkedList<BarcodeLevel>> barcodeItems = new LinkedHashMap<String, LinkedList<BarcodeLevel>>();
        String currentFormKey = null;
        String currentFormName = null;
        boolean isDokumentMehrfachvorkommen = false;
        BufferedReader reader = null;
        try {
            reader = BarcodeHelper.getBarcodeReader();
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith(BARCODE_COMMENT_TAG)) {
                    if (line.startsWith(BARCODE_FORM_START_TAG_PREFIX)) {
                        String formName;
                        String formKey;
                        String[] tokens = line.split(PERSISTENCE_KEY_SEP);
                        switch (tokens.length) {
                            case 4: {
                                isDokumentMehrfachvorkommen = true;
                            }
                            case 3: {
                                assert (tokens[0].equals(BARCODE_FORM_START_TAG_PREFIX));
                                formKey = tokens[1];
                                formName = tokens[2];
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Invalid Form syntax in barcode.txt, cannot continue");
                            }
                        }
                        currentFormKey = formKey;
                        currentFormName = formName;
                        if (!isDokumentMehrfachvorkommen) {
                            ((BarcodeLevel)levelStack.peek()).put("FB" + structureId++, BarcodeHelper.generateBeginFormular(formKey, formName));
                        }
                    } else if (line.equals(BARCODE_FORM_END_TAG)) {
                        if (!isDokumentMehrfachvorkommen) {
                            ((BarcodeLevel)levelStack.peek()).put("FE" + structureId++, BarcodeHelper.generateEndFormular());
                        } else {
                            isDokumentMehrfachvorkommen = false;
                        }
                    } else if (line.startsWith(BARCODE_FORM_TABLE_START_TAG_PREFIX)) {
                        if (!isDokumentMehrfachvorkommen) {
                            String msg = "Form-table found in barcode.txt, but current form not marked as repeatable.";
                            LOG.error("Form-table found in barcode.txt, but current form not marked as repeatable.");
                            assert (false) : "Form-table found in barcode.txt, but current form not marked as repeatable.";
                        }
                        newLevel = new BarcodeLevelFormular("TFC" + structureId++, currentFormKey, currentFormName);
                        ((BarcodeLevel)levelStack.peek()).put(newLevel.getKey(), null);
                        levelStack.push(newLevel);
                    } else if (line.startsWith(BARCODE_FORM_TABLE_END_TAG_PREFIX)) {
                        levelStack.pop();
                    } else if (line.equals(BARCODE_TABLE_START_TAG)) {
                        newLevel = new BarcodeLevel("TC" + structureId++);
                        ((BarcodeLevel)levelStack.peek()).put(newLevel.getKey(), null);
                        levelStack.push(newLevel);
                    } else if (line.equals(BARCODE_TABLE_END_TAG)) {
                        levelStack.pop();
                    } else {
                        ((BarcodeLevel)levelStack.peek()).put(line, null);
                        barcodeItems.put(line, new LinkedList(levelStack));
                    }
                }
                line = reader.readLine();
            }
        }
        finally {
            BarcodeHelper.tryClose(reader);
        }
        return new BarcodeStructure(barcodeItems, rootLevel);
    }

    private static String generateBeginDoc() {
        StringBuilder buf = new StringBuilder();
        buf.append(XML_VERSION);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateBeginFile(String period, String date, String provider, String version) {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_DOC);
        buf.append(CRLF);
        buf.append(BEGIN_TAG);
        buf.append(INTERFACE_HEADER);
        buf.append(' ');
        buf.append(PERIOD);
        buf.append(QUOTE).append(period).append(QUOTE);
        buf.append(' ');
        buf.append(DATE_NOW);
        buf.append(QUOTE).append(date).append(QUOTE);
        buf.append(' ');
        buf.append(PROVIDER);
        buf.append(QUOTE).append(provider).append(QUOTE);
        buf.append(' ');
        buf.append(VERSION);
        buf.append(QUOTE).append(version).append(QUOTE);
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTaxInformation(String firstname, String lastname, String addr, String zip, String city, String noContribuable) {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_TAG);
        buf.append(INTERFACE_DEF);
        buf.append(' ');
        buf.append(FIRSTNAME).append(QUOTE).append(firstname).append(QUOTE).append(' ');
        buf.append(LASTNAME).append(QUOTE).append(lastname).append(QUOTE).append(' ');
        buf.append(ADDRESS);
        buf.append(QUOTE).append(addr).append(QUOTE).append(' ');
        buf.append(ZIP);
        buf.append(QUOTE).append(zip).append(QUOTE).append(' ');
        buf.append(CITY);
        buf.append(QUOTE).append(city).append(QUOTE).append(' ');
        buf.append(NO_CONTRIBUABLE);
        buf.append(QUOTE).append(noContribuable).append(QUOTE);
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateEndDoc() {
        StringBuilder buf = new StringBuilder();
        buf.append(END_DOC);
        return buf.toString();
    }

    private static String generateBeginFormular(String formularId, String formularDesc) {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_FORMULAR_HEADER);
        buf.append(QUOTE).append(formularId).append(QUOTE).append(' ');
        buf.append(FORMULAR_DESC);
        buf.append(QUOTE).append(formularDesc).append(QUOTE);
        buf.append(END_LINE_TAG);
        buf.append(CRLF);
        buf.append(BEGIN_FORMULAR_DATA);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateEndFormular() {
        StringBuilder buf = new StringBuilder();
        buf.append(END_FORMULAR_DATA);
        buf.append(CRLF);
        buf.append(END_FORMULAR_HEADER);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableBegin() {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_TABLE);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableEnd() {
        StringBuilder buf = new StringBuilder();
        buf.append(END_TABLE);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableLineBegin() {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_TABLE_ROW);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateTableLineEnd() {
        StringBuilder buf = new StringBuilder();
        buf.append(END_TABLE_ROW);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateField(BarcodeItem item) {
        StringBuilder buf = new StringBuilder();
        buf.append(BEGIN_FIELD);
        buf.append(QUOTE).append(item.getCodeF()).append(QUOTE);
        buf.append(' ');
        buf.append(CODE);
        buf.append(QUOTE).append(item.getCodeC()).append(QUOTE);
        buf.append(' ');
        buf.append(VALUE);
        buf.append(QUOTE).append(item.getValue()).append(QUOTE);
        buf.append(END_TAG);
        buf.append(CRLF);
        return buf.toString();
    }

    private static String generateFormularTitre(BarcodeFormTableGenerator formTableGenerator) {
        StringBuilder buf = new StringBuilder();
        List<List<BarcodeItem>> titres = formTableGenerator.getFormTable(BarcodeFormTableGenerator.FORM.WERTSCHRIFFTEN);
        if (titres != null && !titres.isEmpty()) {
            buf.append(BarcodeHelper.generateBeginFormular("0005", "Titres"));
            buf.append(BarcodeHelper.generateTableBegin());
            for (List<BarcodeItem> itemPerZelle : titres) {
                buf.append(BarcodeHelper.generateTableLineBegin());
                for (BarcodeItem item : itemPerZelle) {
                    buf.append(BarcodeHelper.generateField(item));
                }
                buf.append(BarcodeHelper.generateTableLineEnd());
            }
            buf.append(BarcodeHelper.generateTableEnd());
            buf.append(BarcodeHelper.generateEndFormular());
        }
        return buf.toString();
    }

    private static void generateContextData(BarcodeStructure barcodeStructure, JuUtil.Profile profile, UploadConfiguration.UploadType uploadType, SystemInfo sysInfo) {
        assert (profile != null && uploadType != null);
        BarcodeHelper.generateBarcodeItem(barcodeStructure, UploadConfiguration.UPLOAD_TYPE_PKEY, uploadType.getBarcodeValue());
        BarcodeHelper.generateBarcodeItem(barcodeStructure, UploadConfiguration.APPLICATION_PROFILE_PKEY, profile.getBarcodeValue());
        if (sysInfo != null) {
            BarcodeHelper.generateBarcodeItem(barcodeStructure, UploadConfiguration.OS_IDENTIFIER_PKEY, sysInfo.getOperatingSystemIdentifier());
            BarcodeHelper.generateBarcodeItem(barcodeStructure, UploadConfiguration.JVM_IDENTIFIER_PKEY, sysInfo.getJvmIdentifier());
        }
    }

    private static void generateBarcodeItem(BarcodeStructure barcodeStructure, PKey pKey, Object value) {
        String code = pKey.pkTuple.toExternalForm();
        BarcodeItem item = new BarcodeItem(pKey.pkTuple.dokument, pKey.pkTuple.ziffer + "-" + pKey.pkTuple.zelle, pKey.pkType.toString(), value, null);
        BarcodeHelper.getItemLevel(barcodeStructure, code, Collections.emptyList()).put(code, item);
    }

    private static void tryClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.debug("I/O Exception while closing stream.", (Throwable)e);
            }
        }
    }

    static class BarcodeStructure {
        private final Map<String, LinkedList<BarcodeLevel>> items;
        private final BarcodeLevel root;

        BarcodeStructure(Map<String, LinkedList<BarcodeLevel>> items, BarcodeLevel root) {
            this.items = items;
            this.root = root;
        }

        public BarcodeLevel getRoot() {
            return this.root;
        }

        public Map<String, LinkedList<BarcodeLevel>> getItems() {
            return this.items;
        }
    }

    static class BarcodeLevel
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;
        private String key;

        BarcodeLevel(String key) {
            this.key = key;
        }

        public BarcodeLevel() {
        }

        public String getKey() {
            return this.key;
        }

        public Map<Object, Map> newLevelMap() {
            return new LinkedHashMap<Object, Map>();
        }
    }

    static class BarcodeLevelFormular
    extends BarcodeLevel {
        private static final long serialVersionUID = 1L;
        private final String formKey;
        private final String formName;

        BarcodeLevelFormular(String key, String formKey, String formName) {
            super(key);
            this.formKey = formKey;
            this.formName = formName;
        }

        private BarcodeLevelFormular(String formKey, String formName) {
            this.formKey = formKey;
            this.formName = formName;
        }

        @Override
        public Map<Object, Map> newLevelMap() {
            return new BarcodeLevelFormular(this.formKey, this.formName);
        }
    }
}

