/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.expertdisplay;

import ch.dvbern.tax.common.presentation.common.util.StringUtil;
import ch.dvbern.tax.ju.JuUtil;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarcodeItem
implements Comparable<BarcodeItem> {
    private static final Logger LOG = LoggerFactory.getLogger(BarcodeItem.class);
    private static final ThreadLocal<NumberFormat> INTEGER_FORMAT = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getIntegerInstance(JuUtil.APPLICATION_LOCALE);
            fmt.setRoundingMode(RoundingMode.HALF_UP);
            fmt.setGroupingUsed(false);
            return fmt;
        }
    };
    private final String formular;
    private final String code;
    private final String codeC;
    private final String codeF;
    private final String format;
    private final String value;
    private final String key;

    public BarcodeItem(String formular, String code, String format, Object val) {
        this(formular, code, format, val, "");
    }

    public BarcodeItem(String formular, String code, String format, Object val, String key) {
        this.code = code;
        this.format = format;
        this.formular = formular;
        this.key = key;
        this.value = this.convertValue(val);
        Character sepChar = null;
        if (code.indexOf(45) != -1) {
            sepChar = Character.valueOf('-');
        } else if (code.indexOf(95) != -1) {
            sepChar = Character.valueOf('_');
        } else if (code.indexOf(42) != -1) {
            sepChar = Character.valueOf('*');
        }
        if (sepChar == null) {
            this.codeC = code;
            this.codeF = code;
        } else {
            String[] tokens = code.split(Pattern.quote(String.valueOf(sepChar)));
            this.codeF = tokens[0];
            this.codeC = tokens[1];
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getFormat() {
        return this.format;
    }

    public String getFormular() {
        return this.formular;
    }

    public String getValue() {
        return this.value;
    }

    private String convertValue(Object val) {
        if (val == null) {
            return "";
        }
        if (this.getFormat().equals("A")) {
            return StringUtil.escapeAndFilterXml((CharSequence)val.toString());
        }
        if (this.getFormat().startsWith("F")) {
            int numberAfterComa = Integer.parseInt(this.format.substring(1));
            StringBuilder buf = new StringBuilder("0.");
            for (int i = 0; i < numberAfterComa; ++i) {
                buf.append("0");
            }
            DecimalFormatSymbols symbol = new DecimalFormatSymbols();
            symbol.setDecimalSeparator('.');
            DecimalFormat df = new DecimalFormat(buf.toString(), symbol);
            return df.format(((Number)val).doubleValue());
        }
        if (this.getFormat().equals("N")) {
            if (val instanceof Number) {
                return INTEGER_FORMAT.get().format(val);
            }
            LOG.error("Incorrect pkey type mapping detected for code {}, expected {}, got {}", new Object[]{this.code, Number.class.getName(), val.getClass().getName()});
            assert (false) : "Incorrect pkey type for " + this.code;
            return StringUtil.escapeAndFilterXml((CharSequence)val.toString());
        }
        if (this.getFormat().equals("D")) {
            Date dateToDisplay = new Date();
            try {
                dateToDisplay = (Date)val;
            }
            catch (ClassCastException e) {
                LOG.error("error converting date " + String.valueOf(val) + ": ", (Throwable)e);
            }
            return new SimpleDateFormat("yyyyMMdd").format(dateToDisplay);
        }
        if (this.getFormat().equals("DM")) {
            Date dateToDisplay = (Date)val;
            return new SimpleDateFormat("ddMM").format(dateToDisplay);
        }
        if (this.getFormat().equals("C")) {
            if (this.code.equals("2.1.1_1")) {
                if (val instanceof Long) {
                    long longValue = (Long)val;
                    if (longValue == 1L) {
                        return "AS";
                    }
                    if (longValue == 2L) {
                        return "AL";
                    }
                    return StringUtil.escapeAndFilterXml((CharSequence)val.toString());
                }
                return "";
            }
            return "";
        }
        return StringUtil.escapeAndFilterXml((CharSequence)val.toString());
    }

    public String getCodeF() {
        return this.codeF;
    }

    public String getCodeC() {
        return this.codeC;
    }

    @Override
    public int compareTo(@NonNull BarcodeItem toCompare) {
        if (this.getKey() != null && toCompare.getKey() != null) {
            return this.getKey().compareTo(toCompare.getKey());
        }
        return 0;
    }

    public String getKey() {
        return this.key;
    }
}

