/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.expertdisplay;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DGenerator;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.presentation.common.util.StringUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.util.ZipHelper;
import ch.dvbern.tax.ju.SystemInfo;
import ch.dvbern.tax.ju.engine.expertdisplay.BarcodeHelper;
import ch.dvbern.tax.ju.engine.expertdisplay.BarcodeSchemaProvider;
import ch.dvbern.tax.ju.upload.UploadConfiguration;
import java.io.IOException;
import java.io.StringReader;
import java.time.Instant;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Random;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JuBarcodeGenerator
implements Barcode2DGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JuBarcodeGenerator.class);
    public static final String ENCODING = "ISO-8859-1";
    private final boolean compressOutput;
    private final Instant timestamp;
    private final UploadConfiguration.UploadType uploadType;
    private final SystemInfo sysInfo;
    private final Random random = new Random();

    public JuBarcodeGenerator(boolean compressOutput, Instant timestamp,  @NonNull UploadConfiguration.UploadType uploadType, @Nullable SystemInfo sysInfo) {
        Objects.requireNonNull(timestamp, "Timestamp cannot be null.");
        Objects.requireNonNull(uploadType, "Upload type cannot be null.");
        this.compressOutput = compressOutput;
        this.timestamp = timestamp;
        this.uploadType = uploadType;
        this.sysInfo = sysInfo;
    }

    public byte[] generateId(ExpertDisplayModel.RequestContext req) {
        byte[] id = new byte[4];
        id[0] = 3;
        id[1] = 1;
        byte[] rand = new byte[2];
        this.random.nextBytes(rand);
        id[2] = rand[0];
        id[3] = rand[1];
        return id;
    }

    public byte getContentType() {
        return 0;
    }

    public byte[] generateData(ExpertDisplayModel.RequestContext requestContext) {
        ExpertDisplayModel.ProtectedMap dataModel = requestContext.getDataModel();
        Map logicModel = requestContext.getLogicModelItems();
        try {
            return this.generateBarcodeContent(dataModel, logicModel);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] generateBarcodeContent(ExpertDisplayModel.ProtectedMap dataModel, Map<String, LogicModelItem> logicModel) throws Exception {
        String noContribuable;
        String city;
        String zip;
        String addr;
        String lastname;
        String firstname;
        String anneeTaxation = this.getStringValue(dataModel, "Stammdaten.Declaration.PeriodeTaxation");
        String content = BarcodeHelper.generate(dataModel, logicModel, this.timestamp, anneeTaxation, firstname = this.getStringValue(dataModel, "Stammdaten.Monsieur.Prenom"), lastname = this.getStringValue(dataModel, "Stammdaten.Monsieur.Nom"), addr = this.getStringValue(dataModel, "Stammdaten.Declaration.RueNo"), zip = this.getStringValue(dataModel, "Stammdaten.Declaration.Npa"), city = this.getStringValue(dataModel, "Stammdaten.Declaration.Localite"), noContribuable = this.getStringValue(dataModel, "Stammdaten.Declaration.NoContribuable"), this.uploadType, this.sysInfo);
        if (this.validate(content)) {
            LOG.info("Barcode content successfuly validated.");
        } else {
            String msg = "Schema validation unsuccessful.";
            LOG.error("Schema validation unsuccessful.");
            assert (false) : "Schema validation unsuccessful.";
        }
        byte[] data = content.getBytes(ENCODING);
        String filename = noContribuable.concat(".xml");
        return this.compressOutput ? ZipHelper.zip((byte[])data, (String)filename) : data;
    }

    private String getStringValue(ExpertDisplayModel.ProtectedMap dataModel, String key) {
        ModelItemDTO mi = dataModel.get((Object)key);
        if (mi != null && mi.getValue() != null) {
            return StringUtil.escapeAndFilterXml((CharSequence)mi.getValue().toString());
        }
        return "";
    }

    private boolean validate(String xml) {
        Schema schema;
        if (xml == null) {
            LOG.error("XML parameter is null, will not validate.");
            return false;
        }
        try {
            schema = BarcodeSchemaProvider.retrieveSchema();
        }
        catch (SAXException e) {
            LOG.error("Schema retrieval failed, abording validation.", (Throwable)e);
            return false;
        }
        catch (MissingResourceException e) {
            LOG.error("Schema retrieval failed, abording validation.", (Throwable)e);
            return false;
        }
        catch (IllegalStateException e) {
            LOG.error("Schema retrieval failed, abording validation.", (Throwable)e);
            return false;
        }
        try {
            schema.newValidator().validate(new StreamSource(new StringReader(xml)));
        }
        catch (IOException e) {
            LOG.error("Validation failed due to I/O Error.", (Throwable)e);
            return false;
        }
        catch (SAXParseException e) {
            LOG.error("Failed to parse barcode file [{}:{}]", new Object[]{e.getLineNumber(), e.getColumnNumber(), e});
        }
        catch (SAXException e) {
            LOG.error("Validation failed.", (Throwable)e);
            return false;
        }
        return true;
    }
}

