/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.justificatifs;

import ch.dvbern.tax.ju.engine.justificatifs.ExtraUserDocument;
import ch.dvbern.tax.ju.engine.justificatifs.MappedUserDocument;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedCategories;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedDocument;
import ch.dvbern.tax.ju.engine.justificatifs.UserDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DocumentStoreIndex
implements Serializable {
    private static final long serialVersionUID = 6989685847374105206L;
    private final List<UserDocument> userDocs;
    private final ResolvedCategories resolvedCategories;
    private final Map<ResolvedDocument, List<MappedUserDocument>> resolvedDocsMap;
    private final List<ExtraUserDocument> extraDocs;
    private final long totalSize;
    private final boolean missingDescriptions;
    private final boolean everyResolvedDocumentMapped;

    private DocumentStoreIndex(ResolvedCategories resolvedCategories, List<UserDocument> userDocs, Map<ResolvedDocument, List<MappedUserDocument>> resolvedDocsMap, List<ExtraUserDocument> extraDocs, long totalSize, boolean missingDescriptions, boolean everyResolvedDocumentMapped) {
        this.resolvedCategories = resolvedCategories;
        this.userDocs = userDocs;
        this.resolvedDocsMap = resolvedDocsMap;
        this.extraDocs = extraDocs;
        this.totalSize = totalSize;
        this.missingDescriptions = missingDescriptions;
        this.everyResolvedDocumentMapped = everyResolvedDocumentMapped;
    }

    public static DocumentStoreIndex build(ResolvedCategories resolvedCategories, List<UserDocument> userDocs) {
        HashMap<ResolvedDocument, List<MappedUserDocument>> resolvedDocsMap = new HashMap<ResolvedDocument, List<MappedUserDocument>>();
        ArrayList<ExtraUserDocument> extraDocs = new ArrayList<ExtraUserDocument>();
        long totalSize = 0L;
        boolean missingDescriptions = false;
        for (UserDocument userDoc : userDocs) {
            totalSize += userDoc.getSize();
            if (userDoc instanceof MappedUserDocument) {
                MappedUserDocument mappedUserDoc = (MappedUserDocument)userDoc;
                ResolvedDocument resolvedDoc = mappedUserDoc.getResolvedDoc();
                ArrayList<MappedUserDocument> mappedUserDocs = (ArrayList<MappedUserDocument>)resolvedDocsMap.get(resolvedDoc);
                if (mappedUserDocs == null) {
                    mappedUserDocs = new ArrayList<MappedUserDocument>(5);
                    resolvedDocsMap.put(resolvedDoc, mappedUserDocs);
                }
                mappedUserDocs.add(mappedUserDoc);
                continue;
            }
            ExtraUserDocument extraDoc = (ExtraUserDocument)userDoc;
            extraDocs.add(extraDoc);
            missingDescriptions |= extraDoc.getDescription() == null;
        }
        boolean everyResolvedDocumentMapped = true;
        if (!resolvedCategories.isAllRequired()) {
            block1: for (Set<ResolvedDocument> resolvedDocuments : resolvedCategories.getResolvedMap().values()) {
                for (ResolvedDocument resolvedDocument : resolvedDocuments) {
                    if (resolvedDocsMap.containsKey(resolvedDocument)) continue;
                    everyResolvedDocumentMapped = false;
                    continue block1;
                }
            }
        }
        return new DocumentStoreIndex(resolvedCategories, userDocs, resolvedDocsMap, extraDocs, totalSize, missingDescriptions, everyResolvedDocumentMapped);
    }

    public @NonNull List<UserDocument> getAllUserDocuments() {
        return this.userDocs;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public @NonNull List<MappedUserDocument> getResolvedUserDocs(ResolvedDocument document) {
        return this.resolvedDocsMap.getOrDefault(document, Collections.emptyList());
    }

    public ResolvedCategories getResolvedCategories() {
        return this.resolvedCategories;
    }

    public @NonNull List<ExtraUserDocument> getExtraDocs() {
        return this.extraDocs;
    }

    public boolean hasMissingDescriptions() {
        return this.missingDescriptions;
    }

    public boolean isEveryResolvedDocumentMapped() {
        return this.everyResolvedDocumentMapped;
    }
}

