/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.justificatifs;

import ch.dvbern.tax.ju.engine.justificatifs.Category;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Justificatif
extends Enum<Justificatif> {
    public static final /* enum */ Justificatif ARRIVE_CANTON = new Justificatif(0, Category.GENERAL, false, "Stammdaten.FlagJustificatifNouveauCanton", false, "label.justificatifs.tous", new String[0]);
    public static final /* enum */ Justificatif CERT_TRAVAIL_CTR = new Justificatif(1, Category.REVENU, false, "Einkommen.ActivitesDependantesHomme.Table.FlagJustificatifCert", false, "label.justificatifs.revenu.cert", "Einkommen.ActivitesDependantesHomme.Table.Employeur");
    public static final /* enum */ Justificatif CERT_TRAVAIL_CJT = new Justificatif(2, Category.REVENU, true, "Einkommen.ActivitesDependantesFemme.Table.FlagJustificatifCert", false, "label.justificatifs.revenu.cert", "Einkommen.ActivitesDependantesFemme.Table.Employeur");
    public static final /* enum */ Justificatif INDEMNITE_AI_CTR = new Justificatif(3, Category.REVENU, false, "Einkommen.ActivitesDependantesHomme.Table.FlagJustificatifIndemniteAI", false, "label.justificatifs.revenu.indemnite_ai", new String[0]);
    public static final /* enum */ Justificatif INDEMNITE_AI_CJT = new Justificatif(4, Category.REVENU, true, "Einkommen.ActivitesDependantesFemme.Table.FlagJustificatifIndemniteAI", false, "label.justificatifs.revenu.indemnite_ai", new String[0]);
    public static final /* enum */ Justificatif AUTRES_REVENUS_CTR = new Justificatif(5, Category.REVENU, false, "Einkommen.AutresRevenusHomme.Table.FlagJustificatifNature", false, "label.justificatifs.revenu.autre", "Einkommen.AutresRevenusHomme.Table.Nature");
    public static final /* enum */ Justificatif AUTRES_REVENUS_CJT = new Justificatif(6, Category.REVENU, true, "Einkommen.AutresRevenusFemme.Table.FlagJustificatifNature", false, "label.justificatifs.revenu.autre", "Einkommen.AutresRevenusFemme.Table.Nature");
    public static final /* enum */ Justificatif INDEPENDANT_COMPTA = new Justificatif(7, Category.INDEPENDANT, false, "Einkommen.IndependantSNC.IndependantSNC.DonneesRef.FlagJustificatifCompta", false, "label.justificatifs.independant.compta", new String[0]);
    public static final /* enum */ Justificatif INDEPENDANT_COMPTA_NON = new Justificatif(8, Category.INDEPENDANT, false, "Einkommen.IndependantSNC.IndependantSNC.DonneesRef.FlagJustificatifComptaNon", false, "label.justificatifs.independant.compta.non", new String[0]);
    public static final /* enum */ Justificatif AGRICULTEUR_COMPTA = new Justificatif(9, Category.AGRICULTEUR, false, "Einkommen.AgricoleHomme.Table.DonneesRef.FlagJustificatifCompta", false, "label.justificatifs.agriculteur.compta", new String[0]);
    public static final /* enum */ Justificatif AGRICULTEUR_COMPTA_NON = new Justificatif(10, Category.AGRICULTEUR, false, "Einkommen.AgricoleHomme.Table.DonneesRef.FlagJustificatifComptaNon", false, "label.justificatifs.agriculteur.compta.non", new String[0]);
    public static final /* enum */ Justificatif GAIN_LIQUIDATION_CTR = new Justificatif(11, Category.GAIN_LIQUIDATION, false, "Uebersicht.FlagJustificatifDI188", false, "label.justificatifs.independant.calculGainLiquidation", new String[0]);
    public static final /* enum */ Justificatif GAIN_LIQUIDATION_CJT = new Justificatif(12, Category.GAIN_LIQUIDATION, true, "Uebersicht.FlagJustificatifDI188C", false, "label.justificatifs.independant.calculGainLiquidation", new String[0]);
    public static final /* enum */ Justificatif RENTE_CTR = new Justificatif(13, Category.RENTE, false, "Einkommen.RentesEtPensionsHomme.Table.FlagJustificatif", true, "Einkommen.RentesEtPensionsHomme.Table.LabelJustificatif", new String[0]);
    public static final /* enum */ Justificatif RENTE_CJT = new Justificatif(14, Category.RENTE, true, "Einkommen.RentesEtPensionsFemme.Table.FlagJustificatif", true, "Einkommen.RentesEtPensionsFemme.Table.LabelJustificatif", new String[0]);
    public static final /* enum */ Justificatif RENTE_VIAGERE_NOUVELLE_CTR = new Justificatif(15, Category.RENTE, false, "Einkommen.RentesViageresHomme.Table.FlagJustificatifRenteViagereNouvelle", false, "label.justificatifs.rentes.renteViagere.nouvelle", "Einkommen.RentesViageresHomme.Table.PrintNomPrenomRentesViageresHomme");
    public static final /* enum */ Justificatif RENTE_VIAGERE_NOUVELLE_CJT = new Justificatif(16, Category.RENTE, true, "Einkommen.RentesViageresFemme.Table.FlagJustificatifRenteViagereNouvelle", false, "label.justificatifs.rentes.renteViagere.nouvelle", "Einkommen.RentesViageresFemme.Table.PrintNomPrenomRentesViageresFemme");
    public static final /* enum */ Justificatif SOUS_LOCATION_CTR = new Justificatif(17, Category.RENTE, false, "Einkommen.RentesViageresHomme.Table.FlagJustificatifSousLocation", false, "label.justificatifs.rentes.sousLocation", new String[0]);
    public static final /* enum */ Justificatif SOUS_LOCATION_CJT = new Justificatif(18, Category.RENTE, true, "Einkommen.RentesViageresFemme.Table.FlagJustificatifSousLocation", false, "label.justificatifs.rentes.sousLocation", new String[0]);
    public static final /* enum */ Justificatif PENSIONS_ALIMENTAIRES_CTR = new Justificatif(19, Category.PENSION_ALIM, false, "Einkommen.PensionAlimentaireHomme.Table.FlagJustificatif", false, "label.justificatifs.pension_alim.detail", "Einkommen.PensionAlimentaireHomme.Table.Nom", "Einkommen.PensionAlimentaireHomme.Table.Prenom");
    public static final /* enum */ Justificatif PENSIONS_ALIMENTAIRES_CJT = new Justificatif(20, Category.PENSION_ALIM, true, "Einkommen.PensionAlimentaireFemme.Table.FlagJustificatif", false, "label.justificatifs.pension_alim.detail", "Einkommen.PensionAlimentaireFemme.Table.Nom", "Einkommen.PensionAlimentaireFemme.Table.Prenom");
    public static final /* enum */ Justificatif FRAIS_PERFECTIONNEMENT_CTR = new Justificatif(21, Category.FRAIS_PERFECTIONNEMENT, false, "Abzuege.FraisPerfectionnementHomme.FlagJustificatif", false, "label.justificatifs.frais_perfectionnement.detail", new String[0]);
    public static final /* enum */ Justificatif FRAIS_PERFECTIONNEMENT_CJT = new Justificatif(22, Category.FRAIS_PERFECTIONNEMENT, true, "Abzuege.FraisPerfectionnementFemme.FlagJustificatif", false, "label.justificatifs.frais_perfectionnement.detail", new String[0]);
    public static final /* enum */ Justificatif COTISATIONS_SYNDICALES_CTR = new Justificatif(23, Category.FRAIS_PROFESSIONNELS, false, "Berufskosten.AutresFraisHomme.FlagJustificatifCotisationsSyndicales", false, "label.justificatifs.frais_perfectionnement.cotisationsSyndicales", new String[0]);
    public static final /* enum */ Justificatif COTISATIONS_SYNDICALES_CJT = new Justificatif(24, Category.FRAIS_PROFESSIONNELS, true, "Berufskosten.AutresFraisFemme.FlagJustificatifCotisationsSyndicales", false, "label.justificatifs.frais_perfectionnement.cotisationsSyndicales", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_FRAIS_EXPLOITATION_ASSURANCE = new Justificatif(25, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.FraisExploitation.FlagJustificatifAssurance", false, "label.justificatifs.immeuble.fraisExploitation.assurance", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_FRAIS_EXPLOITATION_RESPONSABILITE_CIVILE = new Justificatif(26, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.FraisExploitation.FlagJustificatifResponsabiliteCivile", false, "label.justificatifs.immeuble.fraisExploitation.responsabiliteCivile", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_FRAIS_EXPLOITATION_RAMONAGE = new Justificatif(27, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.FraisExploitation.FlagJustificatifRamonage", false, "label.justificatifs.immeuble.fraisExploitation.ramonage", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_FRAIS_EXPLOITATION_ORDURE_MENAGERE = new Justificatif(28, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.FraisExploitation.FlagJustificatifOrdureMenageres", false, "label.justificatifs.immeuble.fraisExploitation.orduresMenageres", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_FRAIS_EXPLOITATION_AUTRES_CONTRIBUTIONS = new Justificatif(29, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.FraisExploitation.FlagJustificatifAutresContributions", false, "label.justificatifs.immeuble.fraisExploitation.autresContributions", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_FRAIS_ENTRETIEN = new Justificatif(30, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.FraisEntretien.TableFraisEntretien.FlagJustificatif", false, "label.justificatifs.immeuble.frais_entretien", "Liegenschaft.Immeubles.TableImmeubles.FraisEntretien.TableFraisEntretien.DateFacture", "Liegenschaft.Immeubles.TableImmeubles.FraisEntretien.TableFraisEntretien.Entreprise", "Liegenschaft.Immeubles.TableImmeubles.FraisEntretien.TableFraisEntretien.MontantFraisEntretien");
    public static final /* enum */ Justificatif IMMEUBLE_PHOTOVOLTAIQUE = new Justificatif(31, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.DonneesRef.FlagJustificatifPhotovoltaique", false, "label.justificatifs.immeuble.photovoltaique", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_RETRIBUTION_UNIQUE = new Justificatif(32, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.ProductionPhotovoltaique.FlagJustificatifRetributionUnique", false, "label.justificatifs.immeuble.photovoltaique.retributionUnique", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_RENDEMENT = new Justificatif(33, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.FlagJustificatifRendement", false, "label.justificatifs.immeuble.rendement", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_VALEUR_OFFICIELLE = new Justificatif(83, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.DonneesRef.FlagJustificatifValeurOfficielleImmeuble", false, "label.justificatifs.immeuble.donneesReference.valeurOfficielle", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_VALEUR_OFFICIELLE_VALEUR_LOCATIVE = new Justificatif(84, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.DonneesRef.FlagJustificatifValeurOfficielleEtLocativeImmeuble", false, "label.justificatifs.immeuble.donneesReference.valeurOfficielleEtLocative", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_ACTE_VENTE = new Justificatif(85, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.DonneesRef.FlagJustificatifActeVenteImmeuble", false, "label.justificatifs.immeuble.donneesReference.acteVente", new String[0]);
    public static final /* enum */ Justificatif IMMEUBLE_NOUVEAU_CONTRAT = new Justificatif(88, Category.IMMEUBLE, false, "Liegenschaft.Immeubles.TableImmeubles.ImmeubleLoue.FlagNouveauContrat", false, "label.justificatifs.immeuble.immeubleLoue.nouveau.contrat", new String[0]);
    public static final /* enum */ Justificatif TITRE_ACTION = new Justificatif(34, Category.TITRE, false, "Wertschriften.Aktien.Aktien.FlagJustificatif", true, "Wertschriften.Aktien.Aktien.LabelJustificatif", "Wertschriften.Aktien.Aktien.Bezeichnung", "Wertschriften.Aktien.Aktien.WaehrungLabel");
    public static final /* enum */ Justificatif TITRE_COMPTE = new Justificatif(35, Category.TITRE, false, "Wertschriften.Konti.Konti.FlagJustificatifDatumEroeffnung", false, "label.justificatifs,titre.compte.ouverture", "Wertschriften.Konti.Konti.Kontonummer");
    public static final /* enum */ Justificatif TITRE_DIVIDENDE = new Justificatif(36, Category.TITRE, false, "Wertschriften.Dividendes.Dividendes.FlagJustificatif", true, "Wertschriften.Dividendes.Dividendes.LabelJustificatif", "Wertschriften.Dividendes.Dividendes.Bezeichnung", "Wertschriften.Dividendes.Dividendes.WaehrungLabel");
    public static final /* enum */ Justificatif TITRE_OBLIGATION_ACHAT = new Justificatif(37, Category.TITRE, false, "Wertschriften.Obligationen.Obligationen.FlagJustificatifAchat", false, "label.justificatifs.titre.obligation.achat", "Wertschriften.Obligationen.Obligationen.Bezeichnung");
    public static final /* enum */ Justificatif TITRE_OBLIGATION_VENTE = new Justificatif(38, Category.TITRE, false, "Wertschriften.Obligationen.Obligationen.FlagJustificatifVente", false, "label.justificatifs.titre.obligation.vente", "Wertschriften.Obligationen.Obligationen.Bezeichnung");
    public static final /* enum */ Justificatif TITRE_PRET = new Justificatif(39, Category.TITRE, false, "Wertschriften.Darlehen.Darlehen.FlagJustificatif", false, "label.justificatifs.titre.pret", "Wertschriften.Darlehen.Darlehen.Bezeichnung");
    public static final /* enum */ Justificatif TITRE_BANQUE = new Justificatif(40, Category.TITRE, false, "Wertschriften.Bankverzeichnis.Bankverzeichnis", false, "label.justificatifs.titre.banque", "Wertschriften.Bankverzeichnis.Bankverzeichnis.NameBank", "Wertschriften.Bankverzeichnis.Bankverzeichnis.Bezeichnung");
    public static final /* enum */ Justificatif TITRE_DA1_RUS = new Justificatif(41, Category.TITRE, false, "Wertschriften.Ergaenzungsblaetter.FlagJustificatifDA1RUS", false, "label.justificatifs.titre.da1.rus", new String[0]);
    public static final /* enum */ Justificatif TITRE_LOTTERIE_SOUMIS_IA = new Justificatif(42, Category.TITRE, false, "Wertschriften.Lotto.FlagJustificatifVST", false, "label.justificatifs.titre.loterie.soumis_ia", "Wertschriften.Lotto.ErtragVST");
    public static final /* enum */ Justificatif TITRE_LOTTERIE_NON_SOUMIS_IA = new Justificatif(43, Category.TITRE, false, "Wertschriften.Lotto.FlagJustificatifOhneVST", false, "label.justificatifs.titre.loterie.non_soumis_ia", "Wertschriften.Lotto.ErtragOhneVST");
    public static final /* enum */ Justificatif TITRE_LOTTERIE_NATURE = new Justificatif(44, Category.TITRE, false, "Wertschriften.Lotto.FlagJustificatifNature", false, "label.justificatifs.titre.loterie.nature", "Wertschriften.Lotto.NaturalgewinneOhneVST");
    public static final /* enum */ Justificatif TITRE_LOTTERIE_MISE = new Justificatif(45, Category.TITRE, false, "Wertschriften.Lotto.FlagJustificatifMise", false, "label.justificatifs.titre.loterie.mise", new String[0]);
    public static final /* enum */ Justificatif TITRE_FRAIS_ADMIN = new Justificatif(46, Category.TITRE, false, "Wertschriften.Abzuege.FlagJustificatifFraisAdmin", false, "label.justificatifs.titre.frais_admin", new String[0]);
    public static final /* enum */ Justificatif SUCCESSION = new Justificatif(47, Category.TITRE, false, "Wertschriften.Succession.Succession.FlagJustificatifSuccession", false, "label.justificatifs.titre.succession", "Wertschriften.Succession.Succession.Nom", "Wertschriften.Succession.Succession.DatePartage");
    public static final /* enum */ Justificatif COPROPRIETE_ADMIN = new Justificatif(48, Category.COPROPRIETE, false, "Coproprietaires.AdministrateurHomme.Table.Administrateur.CommuneSituation", false, "label.justificatifs.copropriete.admin", "Coproprietaires.AdministrateurHomme.Table.Administrateur.CommuneSituation");
    public static final /* enum */ Justificatif COPROPRIETE_ADMIN_IMMEUBLE_FRAIS_ENTRETIEN = new Justificatif(90, Category.COPROPRIETE, false, "Coproprietaires.AdministrateurHomme.Table.FraisEntretien.TableFraisEntretien.FlagJustificatif", false, "label.justificatifs.immeuble.frais_entretien", "Coproprietaires.AdministrateurHomme.Table.FraisEntretien.TableFraisEntretien.DateFacture", "Coproprietaires.AdministrateurHomme.Table.FraisEntretien.TableFraisEntretien.Entreprise", "Coproprietaires.AdministrateurHomme.Table.FraisEntretien.TableFraisEntretien.MontantFraisEntretien");
    public static final /* enum */ Justificatif COPROPRIETE_NON_ADMIN = new Justificatif(49, Category.COPROPRIETE, false, "Coproprietaires.NonAdministrateurHomme.Table.FlagJustificatifNonAdmin", false, "label.justificatifs.copropriete.non_admin", "Coproprietaires.NonAdministrateurHomme.Table.Nom");
    public static final /* enum */ Justificatif DETTE_HYPOTHECAIRE_NOUVEAU = new Justificatif(50, Category.DETTE, false, "Schulden.PrivatHypo.FlagJustificatifNouveauPret", false, "label.justificatifs.dette.hypothecaire_nouveau", new String[0]);
    public static final /* enum */ Justificatif DETTE_HYPOTHECAIRE_RESILIATION = new Justificatif(51, Category.DETTE, false, "Schulden.PrivatHypo.FlagJustificatifResiliationPret", false, "label.justificatifs.dette.hypothecaire_resiliation", new String[0]);
    public static final /* enum */ Justificatif DETTE_AUTRE = new Justificatif(52, Category.DETTE, false, "Schulden.PrivatAutre.FlagJustificatifAutre", false, "label.justificatifs.dette.autre", new String[0]);
    public static final /* enum */ Justificatif DONS = new Justificatif(53, Category.DEDUCTION, false, "Abzuege.Vergabungen.Vergabungen.FlagJustificatif", false, "label.justificatifs.deduction.dons", "Abzuege.Vergabungen.Vergabungen.Name");
    public static final /* enum */ Justificatif PARTIS_POLITIQUES = new Justificatif(54, Category.DEDUCTION, false, "Abzuege.PartisPolitiques.FlagJustificatif", false, "label.justificatifs.deduction.partisPolitiques", new String[0]);
    public static final /* enum */ Justificatif PENSION_ALIMENTAIRE_VERSEE = new Justificatif(55, Category.PENSION_ALIM, false, "Abzuege.Alimente.Alimente.FlagJustificatif", false, "label.justificatifs.pension_alim.versee", "Abzuege.Alimente.Alimente.NomPrenom");
    public static final /* enum */ Justificatif COTISATION_AHV_NICHT_ERWERBSTAETIG_CTR = new Justificatif(56, Category.COTISATION, false, "Abzuege.Vorsorge.FlagJustificatifAhvNichterwerbstaetigCtr", false, "label.justificatifs.cotisation.ahvNichterwerbstaetig", new String[0]);
    public static final /* enum */ Justificatif COTISATION_AHV_NICHT_ERWERBSTAETIG_CJT = new Justificatif(57, Category.COTISATION, true, "Abzuege.Vorsorge.FlagJustificatifAhvNichterwerbstaetigCjt", false, "label.justificatifs.cotisation.ahvNichterwerbstaetig", new String[0]);
    public static final /* enum */ Justificatif COTISATION_INDIP_2EME_PILIER_CTR = new Justificatif(58, Category.COTISATION, false, "Abzuege.Vorsorge.FlagJustIndependent2PilierCtr", false, "label.justificatifs.cotisation.indip.2pilier.ctr", new String[0]);
    public static final /* enum */ Justificatif COTISATION_INDIP_2EME_PILIER_CJT = new Justificatif(59, Category.COTISATION, false, "Abzuege.Vorsorge.FlagJustIndependent2PilierCjt", false, "label.justificatifs.cotisation.indip.2pilier.cjt", new String[0]);
    public static final /* enum */ Justificatif COTISATION_2EME_PILIER_CTR = new Justificatif(60, Category.COTISATION, false, "Abzuege.Vorsorge.FlagJustificatif2emePilierCtr", false, "label.justificatifs.cotisation.2eme_pilier", new String[0]);
    public static final /* enum */ Justificatif COTISATION_2EME_PILIER_CJT = new Justificatif(61, Category.COTISATION, true, "Abzuege.Vorsorge.FlagJustificatif2emePilierCjt", false, "label.justificatifs.cotisation.2eme_pilier", new String[0]);
    public static final /* enum */ Justificatif COTISATION_2EME_PILIER_50000_CTR = new Justificatif(62, Category.COTISATION, false, "Abzuege.Vorsorge.FlagJustificatifDeuxiemePilier50000Ctr", false, "label.justificatifs.deduction.deuxiemePilier50000", new String[0]);
    public static final /* enum */ Justificatif COTISATION_2EME_PILIER_50000_CJT = new Justificatif(63, Category.COTISATION, true, "Abzuege.Vorsorge.FlagJustificatifDeuxiemePilier50000Cjt", false, "label.justificatifs.deduction.deuxiemePilier50000", new String[0]);
    public static final /* enum */ Justificatif COTISATION_3EME_PILIER_CTR = new Justificatif(64, Category.COTISATION, false, "Abzuege.Vorsorge.FlagJustificatif3emePilierCtr", false, "label.justificatifs.cotisation.3eme_pilier", new String[0]);
    public static final /* enum */ Justificatif COTISATION_3EME_PILIER_CJT = new Justificatif(65, Category.COTISATION, true, "Abzuege.Vorsorge.FlagJustificatif3emePilierCjt", false, "label.justificatifs.cotisation.3eme_pilier", new String[0]);
    public static final /* enum */ Justificatif FRAIS_HANDICAP_CTR = new Justificatif(66, Category.FRAIS_HANDICAP, false, "Abzuege.FraisMaladieEtHandicapContribuable.RecapHandicap.FlagJustificatif", false, "label.justificatifs.frais_handicap.detail", new String[0]);
    public static final /* enum */ Justificatif FRAIS_HANDICAP_CJT = new Justificatif(67, Category.FRAIS_HANDICAP, true, "Abzuege.FraisMaladieEtHandicapConjoint.RecapHandicap.FlagJustificatif", false, "label.justificatifs.frais_handicap.detail", new String[0]);
    public static final /* enum */ Justificatif FRAIS_MALADIE = new Justificatif(68, Category.FRAIS_MALADIE, false, "Uebersicht.FlagJustificatifDI580", false, "label.justificatifs.frais_maladie.total", new String[0]);
    public static final /* enum */ Justificatif FRAIS_MALADIE_PRESTATIONS_COMPL_CTR = new Justificatif(69, Category.FRAIS_MALADIE, false, "Abzuege.FraisMaladieEtHandicapContribuable.FlagJustificatifPrestationsComplementaires", false, "label.justificatifs.frais_maladie.prestationsComplementaires", new String[0]);
    public static final /* enum */ Justificatif FRAIS_MALADIE_PRESTATIONS_COMPL_CJT = new Justificatif(70, Category.FRAIS_MALADIE, true, "Abzuege.FraisMaladieEtHandicapConjoint.FlagJustificatifPrestationsComplementaires", false, "label.justificatifs.frais_maladie.prestationsComplementaires", new String[0]);
    public static final /* enum */ Justificatif MUCOVISCIDOSE_CTR = new Justificatif(71, Category.FRAIS_MALADIE, false, "Abzuege.FraisMaladieEtHandicapContribuable.RecapMaladie.FlagJustificatifMucoviscidose", false, "label.justificatifs.frais_maladie.mucoviscidose", new String[0]);
    public static final /* enum */ Justificatif MUCOVISCIDOSE_CJT = new Justificatif(72, Category.FRAIS_MALADIE, true, "Abzuege.FraisMaladieEtHandicapConjoint.RecapMaladie.FlagJustificatifMucoviscidose", false, "label.justificatifs.frais_maladie.mucoviscidose", new String[0]);
    public static final /* enum */ Justificatif PERSONNE_SECOURUE = new Justificatif(73, Category.PERSONNE_SECOURUE, false, "Abzuege.Unterstuetzungen", false, "label.justificatifs.personne_secourue.detail", new String[0]);
    public static final /* enum */ Justificatif ENFANTS_AUTORITE_PARENTALE = new Justificatif(74, Category.ENFANTS, false, "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.FlagJustificatifAutoriteParentale", false, "label.justificatifs.enfants.autorite.parentale", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Nom", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Prenom");
    public static final /* enum */ Justificatif ENFANTS_ETUDES = new Justificatif(75, Category.ENFANTS, false, "Stammdaten.Enfants.TableEnfants.RevenuEtudes.FlagJustificatifEtudes", false, "label.justificatifs.enfants.etudes", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Nom", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Prenom");
    public static final /* enum */ Justificatif ENFANTS_PENSION_ALIMENTAIRE_VERSEE = new Justificatif(76, Category.ENFANTS, false, "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.FlagJustificatifPensionAlimentaireVersee", false, "label.justificatifs.enfants.pensionalimentaire.versee", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Nom", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Prenom");
    public static final /* enum */ Justificatif ENFANTS_PENSION_ALIMENTAIRE_RECUE = new Justificatif(77, Category.ENFANTS, false, "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.FlagJustificatifPensionAlimentaireRecue", false, "label.justificatifs.enfants.pensionalimentaire.recue", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Nom", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Prenom");
    public static final /* enum */ Justificatif ENFANTS_FRAIS_DE_GARDE = new Justificatif(78, Category.ENFANTS, false, "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.FlagJustificatifFraisDeGarde", false, "label.justificatifs.enfants.frais_garde.detail", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.FraisDeGarde", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Nom", "Stammdaten.Enfants.TableEnfants.DonneesPersonnelles.Prenom");
    public static final /* enum */ Justificatif SUBSIDE_CAISSE_MALADIE = new Justificatif(79, Category.SUBSIDE_CAISSE_MALADIE, false, "Abzuege.PrimesEtCotisationsAssurances", false, "label.justificatifs.subside_caisse_maladie.detail", new String[0]);
    public static final /* enum */ Justificatif ASSURANCES_VIE = new Justificatif(80, Category.FORTUNE, false, "Vermoegen.Lebensversicherungen.Lebensversicherungen.FlagLebensversicherung", false, "label.justificatifs.fortune.assurancevie", "Vermoegen.Lebensversicherungen.Lebensversicherungen.Versicherungsgesellschaft");
    public static final /* enum */ Justificatif ENTREPRISE_INNOVANTE_CTR = new Justificatif(81, Category.DEDUCTION, false, "Uebersicht.FlagJustificatifDI915Ctr", false, "label.justificatifs.investissement.entrepisesInnovantes", new String[0]);
    public static final /* enum */ Justificatif ENTREPRISE_INNOVANTE_CJT = new Justificatif(82, Category.DEDUCTION, true, "Uebersicht.FlagJustificatifDI915Cjt", false, "label.justificatifs.investissement.entrepisesInnovantes", new String[0]);
    public static final /* enum */ Justificatif REVENUS_ETRANGER_CTR = new Justificatif(86, Category.RENTE, false, "Einkommen.RentesEtPensionsHomme.Table.FlagRevenuEtranger", false, "label.justificatifs.rentes.etranger", "Einkommen.RentesEtPensionsHomme.Table.TypeShortText");
    public static final /* enum */ Justificatif REVENUS_ETRANGER_CJT = new Justificatif(87, Category.RENTE, true, "Einkommen.RentesEtPensionsFemme.Table.FlagRevenuEtranger", false, "label.justificatifs.rentes.etranger", "Einkommen.RentesEtPensionsFemme.Table.TypeShortText");
    private final int id;
    private final Category category;
    private final boolean conjoint;
    private final String stateLmk;
    private final boolean getLabelFromModel;
    private final String label;
    private final String[] addOnLmks;
    private static final Map<Category, Set<Justificatif>> CATEGORIES;
    private static final Map<Integer, Justificatif> ID_MAPS;
    private static final /* synthetic */ Justificatif[] $VALUES;

    public static Justificatif[] values() {
        return (Justificatif[])$VALUES.clone();
    }

    public static Justificatif valueOf(String name) {
        return Enum.valueOf(Justificatif.class, name);
    }

    private Justificatif(int id, Category category, boolean conjoint, String stateLmk, boolean getLabelFromModel, String label, String ... addOnLmks) {
        assert (category != null && stateLmk != null && label != null);
        this.id = id;
        this.category = category;
        this.conjoint = conjoint;
        this.stateLmk = stateLmk;
        this.getLabelFromModel = getLabelFromModel;
        this.label = label;
        this.addOnLmks = addOnLmks == null ? new String[]{} : addOnLmks;
    }

    public static @NonNull Map<Category, Set<Justificatif>> getCategoryMap() {
        return CATEGORIES;
    }

    public int getId() {
        return this.id;
    }

    public @NonNull Category getCategory() {
        return this.category;
    }

    public boolean isConjoint() {
        return this.conjoint;
    }

    public @NonNull String getStateLmk() {
        return this.stateLmk;
    }

    public boolean isGetLabelFromModel() {
        return this.getLabelFromModel;
    }

    public @NonNull String getLabel() {
        return this.label;
    }

    public @Nullable String[] getAddOnLmks() {
        return this.addOnLmks;
    }

    public static @NonNull Optional<Justificatif> forId(int id) {
        return Optional.ofNullable(ID_MAPS.get(id));
    }

    private static /* synthetic */ Justificatif[] $values() {
        return new Justificatif[]{ARRIVE_CANTON, CERT_TRAVAIL_CTR, CERT_TRAVAIL_CJT, INDEMNITE_AI_CTR, INDEMNITE_AI_CJT, AUTRES_REVENUS_CTR, AUTRES_REVENUS_CJT, INDEPENDANT_COMPTA, INDEPENDANT_COMPTA_NON, AGRICULTEUR_COMPTA, AGRICULTEUR_COMPTA_NON, GAIN_LIQUIDATION_CTR, GAIN_LIQUIDATION_CJT, RENTE_CTR, RENTE_CJT, RENTE_VIAGERE_NOUVELLE_CTR, RENTE_VIAGERE_NOUVELLE_CJT, SOUS_LOCATION_CTR, SOUS_LOCATION_CJT, PENSIONS_ALIMENTAIRES_CTR, PENSIONS_ALIMENTAIRES_CJT, FRAIS_PERFECTIONNEMENT_CTR, FRAIS_PERFECTIONNEMENT_CJT, COTISATIONS_SYNDICALES_CTR, COTISATIONS_SYNDICALES_CJT, IMMEUBLE_FRAIS_EXPLOITATION_ASSURANCE, IMMEUBLE_FRAIS_EXPLOITATION_RESPONSABILITE_CIVILE, IMMEUBLE_FRAIS_EXPLOITATION_RAMONAGE, IMMEUBLE_FRAIS_EXPLOITATION_ORDURE_MENAGERE, IMMEUBLE_FRAIS_EXPLOITATION_AUTRES_CONTRIBUTIONS, IMMEUBLE_FRAIS_ENTRETIEN, IMMEUBLE_PHOTOVOLTAIQUE, IMMEUBLE_RETRIBUTION_UNIQUE, IMMEUBLE_RENDEMENT, IMMEUBLE_VALEUR_OFFICIELLE, IMMEUBLE_VALEUR_OFFICIELLE_VALEUR_LOCATIVE, IMMEUBLE_ACTE_VENTE, IMMEUBLE_NOUVEAU_CONTRAT, TITRE_ACTION, TITRE_COMPTE, TITRE_DIVIDENDE, TITRE_OBLIGATION_ACHAT, TITRE_OBLIGATION_VENTE, TITRE_PRET, TITRE_BANQUE, TITRE_DA1_RUS, TITRE_LOTTERIE_SOUMIS_IA, TITRE_LOTTERIE_NON_SOUMIS_IA, TITRE_LOTTERIE_NATURE, TITRE_LOTTERIE_MISE, TITRE_FRAIS_ADMIN, SUCCESSION, COPROPRIETE_ADMIN, COPROPRIETE_ADMIN_IMMEUBLE_FRAIS_ENTRETIEN, COPROPRIETE_NON_ADMIN, DETTE_HYPOTHECAIRE_NOUVEAU, DETTE_HYPOTHECAIRE_RESILIATION, DETTE_AUTRE, DONS, PARTIS_POLITIQUES, PENSION_ALIMENTAIRE_VERSEE, COTISATION_AHV_NICHT_ERWERBSTAETIG_CTR, COTISATION_AHV_NICHT_ERWERBSTAETIG_CJT, COTISATION_INDIP_2EME_PILIER_CTR, COTISATION_INDIP_2EME_PILIER_CJT, COTISATION_2EME_PILIER_CTR, COTISATION_2EME_PILIER_CJT, COTISATION_2EME_PILIER_50000_CTR, COTISATION_2EME_PILIER_50000_CJT, COTISATION_3EME_PILIER_CTR, COTISATION_3EME_PILIER_CJT, FRAIS_HANDICAP_CTR, FRAIS_HANDICAP_CJT, FRAIS_MALADIE, FRAIS_MALADIE_PRESTATIONS_COMPL_CTR, FRAIS_MALADIE_PRESTATIONS_COMPL_CJT, MUCOVISCIDOSE_CTR, MUCOVISCIDOSE_CJT, PERSONNE_SECOURUE, ENFANTS_AUTORITE_PARENTALE, ENFANTS_ETUDES, ENFANTS_PENSION_ALIMENTAIRE_VERSEE, ENFANTS_PENSION_ALIMENTAIRE_RECUE, ENFANTS_FRAIS_DE_GARDE, SUBSIDE_CAISSE_MALADIE, ASSURANCES_VIE, ENTREPRISE_INNOVANTE_CTR, ENTREPRISE_INNOVANTE_CJT, REVENUS_ETRANGER_CTR, REVENUS_ETRANGER_CJT};
    }

    static {
        $VALUES = Justificatif.$values();
        EnumMap<Category, EnumSet<Justificatif>> tmpMap = new EnumMap<Category, EnumSet<Justificatif>>(Category.class);
        for (Justificatif justificatif : Justificatif.values()) {
            EnumSet<Justificatif> justificatifs = (EnumSet<Justificatif>)tmpMap.get((Object)justificatif.category);
            if (justificatifs == null) {
                justificatifs = EnumSet.noneOf(Justificatif.class);
                tmpMap.put(justificatif.category, justificatifs);
            }
            justificatifs.add(justificatif);
        }
        CATEGORIES = Collections.unmodifiableMap(tmpMap);
        assert (Arrays.stream(Justificatif.values()).mapToInt(Justificatif::getId).distinct().count() == (long)Justificatif.values().length) : "All ids must be unique.";
        ID_MAPS = Collections.unmodifiableMap(Arrays.stream(Justificatif.values()).collect(Collectors.toMap(Justificatif::getId, Function.identity())));
    }
}

