/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.justificatifs;

import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.ModelChangeListener;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.engine.justificatifs.Category;
import ch.dvbern.tax.ju.engine.justificatifs.Justificatif;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedCategory;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResolvedCategories
implements Serializable {
    private static final long serialVersionUID = -7349928468089290636L;
    private static final char KEY_SEP = '.';
    private static final Pattern KEY_SEP_PTN = Pattern.compile(Pattern.quote(String.valueOf('.')));
    private final boolean allRequired;
    private final boolean userDocumentsAllowed;
    private final Map<ResolvedCategory, Set<ResolvedDocument>> resolvedMap;

    private ResolvedCategories(Map<ResolvedCategory, Set<ResolvedDocument>> resolvedMap, boolean allRequired, boolean userDocumentsAllowed) {
        assert (resolvedMap != null);
        this.resolvedMap = resolvedMap;
        this.allRequired = allRequired;
        this.userDocumentsAllowed = userDocumentsAllowed;
    }

    public boolean isAllRequired() {
        return this.allRequired;
    }

    public boolean isUserDocumentsAllowed() {
        return this.userDocumentsAllowed;
    }

    public Map<ResolvedCategory, Set<ResolvedDocument>> getResolvedMap() {
        return this.resolvedMap;
    }

    public static @NonNull ResolvedCategories resolve(@NonNull Map<String, ModelItemDTO> dataModel, @NonNull Map<String, LogicModelItem> logicModel) {
        Objects.requireNonNull(dataModel, "Data model cannot be null.");
        Objects.requireNonNull(logicModel, "Logic model cannot be null.");
        boolean allRequired = ResolvedCategories.isFlagActive(dataModel.get("Stammdaten.FlagJustificatifNouveauCanton"));
        LinkedHashMap<ResolvedCategory, Set<ResolvedDocument>> resolvedMap = new LinkedHashMap<ResolvedCategory, Set<ResolvedDocument>>();
        for (Map.Entry<Category, Set<Justificatif>> categoryEntry : Justificatif.getCategoryMap().entrySet()) {
            Category category = categoryEntry.getKey();
            String[] categoryAddOnLmks = category.getAddOnsLmk();
            if (categoryAddOnLmks != null && categoryAddOnLmks.length > 0) {
                ResolvedCategories.buildDynamicCategories(resolvedMap, dataModel, logicModel, categoryEntry, category, categoryAddOnLmks);
                continue;
            }
            ResolvedCategories.buildSimpleCategory(resolvedMap, dataModel, logicModel, categoryEntry, category);
        }
        boolean userDocumentsAllowed = true;
        block1: for (Set resolvedDocs : resolvedMap.values()) {
            for (ResolvedDocument resolvedDoc : resolvedDocs) {
                Justificatif justificatif = resolvedDoc.getJustificatif();
                if (justificatif != Justificatif.INDEPENDANT_COMPTA && justificatif != Justificatif.AGRICULTEUR_COMPTA) continue;
                userDocumentsAllowed = false;
                continue block1;
            }
        }
        return new ResolvedCategories(resolvedMap, allRequired, userDocumentsAllowed);
    }

    private static void buildSimpleCategory(Map<ResolvedCategory, Set<ResolvedDocument>> resolvedMap, Map<String, ModelItemDTO> dataModel, Map<String, LogicModelItem> logicModel, Map.Entry<Category, Set<Justificatif>> categoryEntry, Category category) throws LocalizationHelper.LocalizationHelperException {
        LinkedHashSet docs = new LinkedHashSet();
        for (Justificatif justificatif : categoryEntry.getValue()) {
            List<String> stateDmks = ResolvedCategories.getAllDmksFromLmk(dataModel, logicModel, justificatif.getStateLmk());
            ResolvedCategories.buildDocs(dataModel, justificatif, stateDmks, docs);
        }
        if (!docs.isEmpty()) {
            resolvedMap.put(new ResolvedCategory(category, null), Collections.unmodifiableSet(docs));
        }
    }

    private static void buildDynamicCategories(Map<ResolvedCategory, Set<ResolvedDocument>> resolvedMap, Map<String, ModelItemDTO> dataModel, Map<String, LogicModelItem> logicModel, Map.Entry<Category, Set<Justificatif>> categoryEntry, Category category, String[] categoryAddOnLmks) throws LocalizationHelper.LocalizationHelperException {
        assert (logicModel != null && dataModel != null && categoryEntry != null && categoryAddOnLmks != null);
        assert (categoryAddOnLmks.length > 0);
        String categoryMainAddOnLmk = categoryAddOnLmks[0];
        for (String categoryMainAddOnDmk : ResolvedCategories.getAllDmksFromLmk(dataModel, logicModel, categoryMainAddOnLmk)) {
            LinkedHashSet docs = new LinkedHashSet();
            for (Justificatif justificatif : categoryEntry.getValue()) {
                String baseLmk = ResolvedCategories.commonBaseLmk(categoryMainAddOnLmk, justificatif.getStateLmk());
                List<String> stateDmks = ResolvedCategories.getAllDmksFromLmk(dataModel, logicModel, new StringBuilder(EngineUtil.mergeModelKey((String)baseLmk, (String)categoryMainAddOnDmk)), new StringBuilder(baseLmk), justificatif.getStateLmk().substring(baseLmk.length()));
                ResolvedCategories.buildDocs(dataModel, justificatif, stateDmks, docs);
            }
            if (docs.isEmpty()) continue;
            resolvedMap.put(new ResolvedCategory(category, categoryMainAddOnDmk), docs);
        }
    }

    private static String commonBaseLmk(String lmkA, String lmkB) {
        assert (lmkA != null && lmkB != null);
        int lastSep = 0;
        int minLength = Math.min(lmkA.length(), lmkB.length());
        for (int i = 0; i < minLength; ++i) {
            char c = lmkA.charAt(i);
            if (c != lmkB.charAt(i)) {
                return lmkA.substring(0, lastSep);
            }
            if (c != '.') continue;
            lastSep = i;
        }
        return lmkA.substring(0, minLength);
    }

    private static void buildDocs(Map<String, ModelItemDTO> dataModel, Justificatif justificatif, List<String> stateDmks, Collection<? super ResolvedDocument> docs) throws LocalizationHelper.LocalizationHelperException {
        docs.addAll(stateDmks.stream().filter(stateDmk -> ResolvedCategories.isFlagActive((ModelItemDTO)dataModel.get(stateDmk))).map(stateDmk -> new ResolvedDocument(justificatif, (String)stateDmk)).collect(Collectors.toList()));
    }

    public static boolean isFlagActive(@Nullable ModelItemDTO stateItem) {
        return stateItem != null && stateItem.getState() != 12 && stateItem.getState() != 11;
    }

    static Object getAddOnValue(Map<String, ModelItemDTO> dataModel, String lmk, String contextDmk) {
        assert (dataModel != null && lmk != null && contextDmk != null);
        return ResolvedCategories.getAddOnValue(dataModel, EngineUtil.mergeModelKey((String)lmk, (String)contextDmk));
    }

    static Object getAddOnValue(Map<String, ModelItemDTO> dataModel, String dmk) {
        Object value;
        assert (dataModel != null && dmk != null);
        ModelItemDTO item = dataModel.get(dmk);
        Object object = value = item != null ? item.getValue() : "";
        if (value == null) {
            value = "";
        }
        return value;
    }

    private static List<String> getAllDmksFromLmk(Map<String, ModelItemDTO> dataModel, Map<String, LogicModelItem> logicModel, String lmk) {
        return ResolvedCategories.getAllDmksFromLmk(dataModel, logicModel, new StringBuilder(), new StringBuilder(), lmk);
    }

    private static List<String> getAllDmksFromLmk(Map<String, ModelItemDTO> dataModel, Map<String, LogicModelItem> logicModel, StringBuilder dmkBuilder, StringBuilder lmkBuilder, String lmk) {
        assert (dataModel != null && logicModel != null && lmk != null);
        Scanner lmkScanner = new Scanner(lmk);
        lmkScanner.useDelimiter(KEY_SEP_PTN);
        int startPos = lmkBuilder.length();
        while (lmkScanner.hasNext()) {
            String lmkToken = lmkScanner.next();
            ResolvedCategories.addToken(lmkBuilder, lmkToken);
            LogicModelItem lmi = logicModel.get(lmkBuilder.toString());
            if (lmi == null) {
                lmkScanner.close();
                throw new IllegalArgumentException("Cannot retrieve intermediate node " + lmkToken + " in LMK " + String.valueOf(lmkBuilder));
            }
            ResolvedCategories.addToken(dmkBuilder, lmkToken);
            if (!(lmi instanceof Table)) continue;
            lmkScanner.close();
            String tableDmk = dmkBuilder.toString();
            ModelItemDTO tableItem = dataModel.get(tableDmk);
            if (tableItem == null) {
                return Collections.emptyList();
            }
            Object indexesObj = tableItem.getValue();
            if (indexesObj == null) {
                return Collections.emptyList();
            }
            if (!(indexesObj instanceof Set)) {
                assert (false);
                return Collections.emptyList();
            }
            ArrayList indexes = new ArrayList((Set)indexesObj);
            Collections.sort(indexes);
            ArrayList<String> result = new ArrayList<String>();
            int dmkMark = dmkBuilder.length();
            int lmkMark = lmkBuilder.length();
            String remainingLmk = lmk.substring(lmkBuilder.length() - startPos);
            for (String index : indexes) {
                ResolvedCategories.addToken(dmkBuilder, index);
                result.addAll(ResolvedCategories.getAllDmksFromLmk(dataModel, logicModel, dmkBuilder, lmkBuilder, remainingLmk));
                dmkBuilder.setLength(dmkMark);
                lmkBuilder.setLength(lmkMark);
            }
            return result;
        }
        return Collections.singletonList(dmkBuilder.toString());
    }

    private static void addToken(StringBuilder sb, String token) {
        assert (sb != null && token != null);
        if (sb.length() > 0) {
            sb.append('.');
        }
        sb.append(token);
    }

    public static class CFHasJustificatif
    implements ComplexCalcItem {
        private Map<String, LogicModelItem> logicModel;

        public void initializeReferences(Map<String, LogicModelItem> logicModel, LogicModelItem logicModelItem) throws InvalidModelException {
            this.logicModel = logicModel;
            for (Justificatif justificatif : Justificatif.values()) {
                LogicModelItem item = logicModel.get(justificatif.getStateLmk());
                if (item == null) {
                    throw new InvalidModelException("Cannot find state item: " + justificatif.getStateLmk());
                }
                item.addDataModelListener((ModelChangeListener)logicModelItem);
            }
        }

        public void evaluate(LogicModelItem.ProtectedMap dataModel, FastStack stack, String s) {
            assert (this.logicModel != null);
            boolean result = false;
            block0: for (Justificatif justificatif : Justificatif.values()) {
                List<String> stateDmks = ResolvedCategories.getAllDmksFromLmk((Map<String, ModelItemDTO>)dataModel, this.logicModel, justificatif.getStateLmk());
                for (String stateDmk : stateDmks) {
                    if (!ResolvedCategories.isFlagActive(dataModel.get((Object)stateDmk))) continue;
                    result = true;
                    continue block0;
                }
            }
            stack.push((Object)result);
        }
    }
}

