/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.justificatifs;

import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.engine.justificatifs.Category;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedCategories;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedDocument;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ResolvedCategory
implements Serializable {
    private static final long serialVersionUID = 4845254201575777701L;
    public static final Map<ResolvedCategory, Set<ResolvedDocument>> ALL = Collections.unmodifiableMap(new HashMap(0));
    private static final LocalizationHelper LOC_HELPER = LocalizationHelper.newInstance((Locale)JuUtil.APPLICATION_LOCALE);
    private final String dmk;
    private final Category category;

    ResolvedCategory(Category category, String dmk) {
        assert (category != null);
        this.category = category;
        this.dmk = dmk;
    }

    public @NonNull String getLabel(Map<String, ModelItemDTO> dataModel) {
        Object[] categoryAddOns;
        String[] categoryAddOnLmks = this.category.getAddOnsLmk();
        if (categoryAddOnLmks != null && categoryAddOnLmks.length > 0) {
            categoryAddOns = new Object[categoryAddOnLmks.length];
            categoryAddOns[0] = ResolvedCategories.getAddOnValue(dataModel, this.dmk);
            for (int i = 1; i < categoryAddOnLmks.length; ++i) {
                String categoryAddOnLmk = categoryAddOnLmks[i];
                categoryAddOns[i] = ResolvedCategories.getAddOnValue(dataModel, categoryAddOnLmk, this.dmk);
            }
        } else {
            categoryAddOns = null;
        }
        return LOC_HELPER.translate(this.category.getKey(), categoryAddOns);
    }

    public @NonNull Category getCategory() {
        return this.category;
    }

    public String getDmk() {
        return this.dmk;
    }
}

