/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.justificatifs;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.engine.justificatifs.Justificatif;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedCategories;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ResolvedDocument
implements Serializable {
    private static final long serialVersionUID = 8845338199687591623L;
    private static final LocalizationHelper LOC_HELPER = LocalizationHelper.newInstance((Locale)JuUtil.APPLICATION_LOCALE);
    private final Justificatif justificatif;
    private final String dmk;
    private final int hashcode;

    public ResolvedDocument(@NonNull Justificatif justificatif, @NonNull String dmk) {
        this.justificatif = Objects.requireNonNull(justificatif, "Justificatif type cannot be null.");
        this.dmk = Objects.requireNonNull(dmk, "User dmk cannot be null.");
        this.hashcode = new HashCodeBuilder(1387593157, 1470156487).append((Object)this.dmk).append((Object)justificatif).build();
    }

    public @NonNull String getDmk() {
        return this.dmk;
    }

    public @NonNull String getLabel(Map<String, ModelItemDTO> dataModel) {
        String labelKey = null;
        if (this.justificatif.isGetLabelFromModel()) {
            Object labelObj;
            String labelKeyDMK = EngineUtil.mergeModelKey((String)this.justificatif.getLabel(), (String)this.dmk);
            ModelItemDTO labelItem = dataModel.get(labelKeyDMK);
            if (labelItem != null && (labelObj = labelItem.getValue()) != null) {
                labelKey = labelObj.toString();
            }
            if (labelKey == null) {
                throw new IllegalArgumentException("Missing label key in datamodel: " + labelKeyDMK);
            }
        } else {
            labelKey = this.justificatif.getLabel();
        }
        String[] addOnLmks = this.justificatif.getAddOnLmks();
        Object[] addOns = new Object[addOnLmks.length];
        for (int i = 0; i < addOnLmks.length; ++i) {
            addOns[i] = ResolvedCategories.getAddOnValue(dataModel, addOnLmks[i], this.dmk);
        }
        Object label = LOC_HELPER.translate(labelKey, addOns);
        if (this.justificatif.isConjoint()) {
            label = (String)label + " (conjoint)";
        }
        return label;
    }

    public @NonNull Justificatif getJustificatif() {
        return this.justificatif;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResolvedDocument) {
            ResolvedDocument that = (ResolvedDocument)obj;
            return this.hashcode == that.hashcode && this.dmk.equals(that.getDmk()) && this.justificatif == that.getJustificatif();
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }
}

