/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.justificatifs;

import ch.dvbern.tax.ju.engine.justificatifs.JusticatifHandle;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class UserDocument
implements Serializable {
    private static final long serialVersionUID = -5227680424056000946L;
    private final JusticatifHandle handle;
    private final String filename;
    private final long size;
    private final int fileCount;

    protected UserDocument(@NonNull JusticatifHandle handle, @NonNull String filename, long size, int fileCount) {
        this.handle = Objects.requireNonNull(handle, "Document handle cannot be null.");
        this.filename = Objects.requireNonNull(filename, "Filename cannot be null.");
        if (size < 0L) {
            throw new IllegalArgumentException("File size cannot be negative.");
        }
        if (fileCount < 1) {
            throw new IllegalArgumentException("File count must be greater or equals to one.");
        }
        this.size = size;
        this.fileCount = fileCount;
    }

    public @NonNull JusticatifHandle getHandle() {
        return this.handle;
    }

    public @NonNull String getFilename() {
        return this.filename;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public long getSize() {
        return this.size;
    }
}

