/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.modelitems;

import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.persistence.PersistenceHint;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableEntryEAuszugDeleteListener
extends LogicModelItem
implements LogicModelItem.TableItem.TableEventListener {
    private final @NonNull Reference eAuszugIdRef;
    private Table konten = null;
    private Table hypotheken = null;
    private Table schulden = null;
    private Table aktien = null;
    private Table obligationen = null;
    private Table diverse = null;
    private Table spesen = null;
    private Table da1 = null;

    public TableEntryEAuszugDeleteListener(@NonNull String name, @NonNull Reference eAuszugIdRef) {
        super(Objects.requireNonNull(name), null, null, true, "false", true, false, (PersistenceHint)new SimpleValuePersistenceHint());
        this.eAuszugIdRef = Objects.requireNonNull(eAuszugIdRef);
    }

    protected void additionalInitializeReferences(@NonNull Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.eAuszugIdRef.initializeReference(logicModel, (LogicModelItem)this, true);
        LogicModelItem eAuszugTable = this.eAuszugIdRef.getReference().getParent();
        if (!(eAuszugTable instanceof LogicModelItem.TableItem)) {
            throw new InvalidModelException("The Id you referenced is invalid, it does not belong to the EAuszug Table: " + String.valueOf(this.eAuszugIdRef));
        }
        ((LogicModelItem.TableItem)eAuszugTable).addTableEventListener((LogicModelItem.TableItem.TableEventListener)this);
        this.konten = this.validRootlevelTable("Wertschriften.Konti.Konti", logicModel);
        this.aktien = this.validRootlevelTable("Wertschriften.Aktien.Aktien", logicModel);
        this.obligationen = this.validRootlevelTable("Wertschriften.Obligationen.Obligationen", logicModel);
        this.diverse = this.validRootlevelTable("Wertschriften.Diverse.Diverse", logicModel);
        this.spesen = this.validRootlevelTable("Wertschriften.Abzuege.FraisAdministatif", logicModel);
        this.hypotheken = this.validRootlevelTable("Schulden.PrivatHypo.Table", logicModel);
        this.schulden = this.validRootlevelTable("Schulden.PrivatAutre.Table", logicModel);
        this.da1 = this.validRootlevelTable("Wertschriften.Ergaenzungsblaetter.DA1RUS", logicModel);
    }

    private @NonNull Table validRootlevelTable(@NonNull String tableLMK, @NonNull Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        LogicModelItem lmi = logicModel.get(tableLMK);
        if (!(lmi instanceof Table)) {
            throw new InvalidModelException("Table-LMI not found: " + tableLMK);
        }
        Table table = (Table)lmi;
        if (table.findContainingTable().isPresent()) {
            throw new InvalidModelException(String.format("LMI may not be contained in another table: %s", tableLMK));
        }
        return table;
    }

    public void onTableEntryAdd(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
    }

    public void onTableEntryRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
    }

    public void onTableValueRemove(@NonNull LogicModelItem source, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap dataModel, @Nullable ModelItemDTO removedDTO, @NonNull String tableDMK) {
        if (source.getName().equals("TaxStatement.TaxStatementTable.Id") && removedDTO != null) {
            this.removeAllElementsConnectedToEauszug(dataModel, removedDTO);
        }
    }

    private void removeAllElementsConnectedToEauszug(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull ModelItemDTO removedDTO) {
        String eAuszugId = String.valueOf(removedDTO.getValue());
        this.removeEauszugItems(dataModel, eAuszugId, this.konten);
        this.removeEauszugItems(dataModel, eAuszugId, this.aktien);
        this.removeEauszugItems(dataModel, eAuszugId, this.diverse);
        this.removeEauszugItems(dataModel, eAuszugId, this.obligationen);
        this.removeEauszugItems(dataModel, eAuszugId, this.hypotheken);
        this.removeEauszugItems(dataModel, eAuszugId, this.schulden);
        this.removeEauszugItems(dataModel, eAuszugId, this.spesen);
        this.removeEauszugItems(dataModel, eAuszugId, this.da1);
    }

    private void removeEauszugItems(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String eAuszugId, @NonNull Table table) {
        List<DMK> rowsToDelete = this.findRowsForESteuerauszugId(eAuszugId, table, dataModel);
        this.deleteRows(table, rowsToDelete, dataModel);
    }

    private void deleteRows(@NonNull Table table, @NonNull List<DMK> rowDMKs, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap dataModel) {
        rowDMKs.forEach(rowDMK -> table.deleteValue(dataModel, rowDMK.toExternalForm()));
    }

    private @NonNull List<DMK> findRowsForESteuerauszugId(@NonNull String eAuszugId, @NonNull Table table, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap dataModel) {
        DMK tableDMK = table.getLMK().toRootlevelDMK();
        return tableDMK.findRowDMKs((Map)dataModel).orElseGet(Collections::emptySet).stream().filter(rowDMK -> this.isEauszugIdmatch((DMK)rowDMK, eAuszugId, dataModel)).collect(Collectors.toList());
    }

    private boolean isEauszugIdmatch(@NonNull DMK rowDMK, @NonNull String eAuszugId, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull LogicModelItem.ProtectedMap dataModel) {
        ModelItemDTO eAuszugMI = dataModel.get((Object)rowDMK.append("ESteuerauszugId").toExternalForm());
        return eAuszugMI != null && Objects.equals(eAuszugMI.getValue(), eAuszugId);
    }
}

