/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.printer;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.transfer.dto.CustomPrinterDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.ju.JuUtil;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfWriter;
import java.util.Map;

abstract class BasePrinter
extends ExpertItemPrinter<CustomPrinterDTO> {
    private static final Font HEADER_FONT = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1);
    private static final float MARGIN_TOP = Utilities.millimetersToPoints((float)10.0f);
    private static final float MARGIN_BOTTOM = Utilities.millimetersToPoints((float)20.0f);
    private static final float MARGIN_LEFT = Utilities.millimetersToPoints((float)15.0f);
    private static final float MARGIN_RIGHT = Utilities.millimetersToPoints((float)15.0f);
    static final Rectangle PAGE_BODY = new Rectangle(MARGIN_LEFT, MARGIN_BOTTOM, PageSize.A4.getRight() - MARGIN_RIGHT, PageSize.A4.getTop() - MARGIN_TOP);
    static final Font BOLD_FONT = FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)1);
    static final Font DEFAULT_FONT = FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)0);
    protected Map<String, LogicModelItem> logicModel = null;
    protected LogicModelItem.ProtectedMap dataModel = null;
    private final String titleKey;
    private final String outlineKey;
    private final String outlineAccessKey;

    protected BasePrinter(String titleKey, String outlineKey, String outlineAccessKey) {
        if (titleKey == null) {
            throw new NullPointerException("Title key cannot be null.");
        }
        if (outlineKey == null) {
            throw new NullPointerException("Outline key cannot be null.");
        }
        if (outlineAccessKey == null) {
            throw new NullPointerException("Outline access key cannot be null.");
        }
        this.titleKey = titleKey;
        this.outlineKey = outlineKey;
        this.outlineAccessKey = outlineAccessKey;
    }

    protected void initalize(CustomPrinterDTO item) {
        this.logicModel = item.getLogicModel();
        this.dataModel = item.getDataModel();
    }

    protected void printInternal(float xOffset, float yOffset) throws FormRendererException {
        assert (this.dataModel != null && this.logicModel != null);
        try {
            if (!this.initPrint()) {
                return;
            }
            DocumentContext context = this.getDocumentContext();
            Document doc = context.getDocument();
            PdfWriter writer = context.getWriter();
            ExpertDisplayInfoDTO.PageSettingsDTO pageSettings = context.getPageSettings();
            float topYLine = PAGE_BODY.getTop() - HEADER_FONT.getSize();
            this.pageSetup(doc, writer);
            this.doPrintInternal(doc, writer, topYLine);
            doc.setMargins((float)pageSettings.getMarginLeft(), (float)pageSettings.getMarginRight(), (float)pageSettings.getMarginTop(), (float)pageSettings.getMarginBottom());
        }
        catch (DocumentException e) {
            throw new FormRendererException("PDF rendering failure", (Throwable)e);
        }
    }

    private void pageSetup(Document doc, PdfWriter writer) {
        this.newPage(doc, writer, false);
        PdfOutline parentOutline = (PdfOutline)this.getDocumentContext().getOutlines().get(this.outlineAccessKey);
        if (parentOutline != null) {
            int crtPage = writer.getCurrentPageNumber();
            new PdfOutline(parentOutline, PdfAction.gotoLocalPage((int)crtPage, (PdfDestination)new PdfDestination(crtPage), (PdfWriter)writer), JuUtil.translate(this.outlineKey, new Object[0]));
        }
    }

    protected void newPage(Document doc, PdfWriter writer) {
        this.newPage(doc, writer, true);
    }

    private void newPage(Document doc, PdfWriter writer, boolean continued) {
        doc.newPage();
        Object title = JuUtil.translate(this.titleKey, new Object[0]);
        if (continued) {
            title = (String)title + " (suite)";
        }
        ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)new Phrase((String)title, HEADER_FONT), (float)PAGE_BODY.getLeft(), (float)PAGE_BODY.getTop(), (float)0.0f);
    }

    protected float drawHLine(PdfWriter writer, float yLine) {
        return this.drawHLine(writer, yLine, 4.5f);
    }

    protected float drawHLine(PdfWriter writer, float yLine, float vSep) {
        return this.drawHLine(writer, yLine, vSep, vSep);
    }

    protected float drawDoubleHLine(PdfWriter writer, float yLine) {
        yLine = this.drawHLine(writer, yLine, 4.5f, 1.25f);
        return this.drawHLine(writer, yLine, 0.0f, 1.25f);
    }

    private float drawHLine(PdfWriter writer, float yLine, float vSepBefore, float vSepAfter) {
        PdfContentByte pdfcb = writer.getDirectContent();
        pdfcb.moveTo(PAGE_BODY.getLeft() + 25.0f, yLine -= vSepBefore);
        pdfcb.lineTo(PAGE_BODY.getRight() - 25.0f, yLine);
        pdfcb.setLineWidth(0.75f);
        pdfcb.setGrayStroke(0.3f);
        pdfcb.stroke();
        return yLine -= vSepAfter;
    }

    protected abstract boolean initPrint();

    protected abstract void doPrintInternal(Document var1, PdfWriter var2, float var3) throws DocumentException;
}

