/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.printer;

import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.engine.printer.BasePrinter;
import ch.dvbern.tax.ju.engine.printer.TableBuilder;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfWriter;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Set;

public class EnfantsPrinter
extends BasePrinter {
    private static final int SIMPLE_ENTRY_PER_PAGE = 2;
    private Set<String> indexes;

    public EnfantsPrinter() {
        super("label.stammdaten.enfants.print.title", "label.stammdaten.enfants.print.outline", "decla_page1#");
    }

    @Override
    protected boolean initPrint() {
        ModelItemDTO item = this.dataModel.get((Object)"Stammdaten.Enfants.TableEnfants");
        if (item == null) {
            return false;
        }
        Set indexes = (Set)item.getValue();
        if (indexes == null || indexes.isEmpty()) {
            return false;
        }
        this.indexes = indexes;
        return true;
    }

    @Override
    protected void doPrintInternal(Document doc, PdfWriter writer, float topYLine) throws DocumentException {
        ArrayList<CallSite> simpleEntries = new ArrayList<CallSite>();
        ArrayList<CallSite> entriesWithDetail = new ArrayList<CallSite>();
        for (String index : this.indexes) {
            Boolean state;
            String dmk = "Stammdaten.Enfants.TableEnfants." + index;
            String stateDmk = EngineUtil.mergeModelKey((String)"Stammdaten.Enfants.TableEnfants.Deductions.StateImpressionDetailEnfant", (String)dmk);
            ModelItemDTO stateItem = this.dataModel.get((Object)stateDmk);
            boolean printDetail = false;
            if (stateItem != null && (state = (Boolean)stateItem.getValue()) != null && state.booleanValue()) {
                printDetail = true;
            }
            if (printDetail) {
                entriesWithDetail.add((CallSite)((Object)dmk));
                continue;
            }
            simpleEntries.add((CallSite)((Object)dmk));
        }
        if (entriesWithDetail.isEmpty() && simpleEntries.isEmpty()) {
            return;
        }
        Collections.sort(entriesWithDetail);
        Collections.sort(simpleEntries);
        ListIterator itr = entriesWithDetail.listIterator();
        while (itr.hasNext()) {
            String dmk = (String)itr.next();
            EnfantsTableBuilder builder = new EnfantsTableBuilder(writer, dmk, true, topYLine);
            builder.build();
            if (!itr.hasNext() && simpleEntries.isEmpty()) continue;
            this.newPage(doc, writer);
        }
        itr = simpleEntries.listIterator();
        int entryIndex = 0;
        float yLine = topYLine;
        while (itr.hasNext()) {
            String dmk = (String)itr.next();
            EnfantsTableBuilder builder = new EnfantsTableBuilder(writer, dmk, false, yLine);
            yLine = builder.build();
            if (!itr.hasNext()) continue;
            if ((entryIndex = (entryIndex + 1) % 2) == 0) {
                this.newPage(doc, writer);
                yLine = topYLine;
                continue;
            }
            yLine = this.drawDoubleHLine(writer, yLine);
        }
    }

    private class EnfantsTableBuilder
    extends TableBuilder {
        private final boolean printDetail;

        EnfantsTableBuilder(PdfWriter writer, String dmk, boolean printDetail, float yLine) {
            super(EnfantsPrinter.this, writer, dmk, yLine);
            this.printDetail = printDetail;
            this.lmkPrefix = "Stammdaten.Enfants.TableEnfants";
        }

        @Override
        public void doBuild() {
            this.printBaseInfo();
            if (this.printDetail) {
                this.printDetail();
            }
        }

        private void printBaseInfo() {
            this.startTable(new float[]{0.17f, 0.17f, 0.12f, 0.05f, 0.17f, 0.17f, 0.12f});
            this.addLabelCell("label.stammdaten.enfants.print.nom");
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.Nom", 2);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.prenom");
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.Prenom", 2);
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.dateDeNaissance", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.DateNaissance");
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.statut", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.DesignationAgeLabel");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.menageEnfant", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.MenageEnfant");
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.sexe", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.Sexe");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.menageAutreParent", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.MenageAutreParent");
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.autoriteParentale", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.AutoriteParentaleOfficielle");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.revenuSupAutreParent", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.RevenuInferieurAutreParent");
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.gardeAlternee", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.GardeAlternee");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.pensionAlimVersee", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.PensionAlimentaireVersee");
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.pensionAlimRecue", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.PensionAlimentaireRecue");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.pensionAlimBeneficiaire", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.PensionEnFaveurOUVersePar", 3);
            this.addLabelCell("label.stammdaten.enfants.print.pensionAlimPourEnfantDe");
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.PensionAlimentairePour");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.pensionAlimAdresse", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.PensionAdresse", 5);
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.fraisGarde", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.FraisDeGarde");
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.formation", 2);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.Formation");
            this.flushTable(6.0f);
            this.startTable(new float[]{0.34f, 0.17f, 0.05f, 0.17f, 0.09f, 0.18f});
            this.addLabelCell("label.stammdaten.enfants.print.chargeICC", 5, true);
            this.addValueCellWithVAlignmentCenter("Deductions.DeductionICCLabel", true);
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.baremeParental", 5, true);
            this.addValueCellWithVAlignmentCenter("Deductions.DeductionIFDLabel", true);
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.autreDemiDeduction");
            this.addValueCellWithVAlignmentCenter("Deductions.Nom");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("Deductions.Prenom");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.cotisationsAssMaladie", 5);
            this.addValueCellWithVAlignmentCenter("Deductions.AssuranceMaladieLabel", true);
            this.addLineBreak();
            this.flushTable();
            this.startTable(new float[]{0.17f, 0.12f, 0.01f, 0.12f, 0.01f, 0.12f, 0.01f, 0.12f, 0.01f, 0.12f, 0.01f, 0.12f});
            this.addLabelCell("label.stammdaten.enfants.print.debut");
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.DateDebut");
            this.addEmptyCell(3);
            this.addLabelCell("label.stammdaten.enfants.print.cloture");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.DateCloture");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.employeur");
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.Employeur", 3);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.etablissementInstruction", 3);
            this.addValueCellWithVAlignmentCenter("DonneesPersonnelles.EtablissementInstruction", 4);
            this.flushTable();
        }

        private void printDetail() {
            this.yLine = this.printer.drawHLine(this.writer, this.yLine, 13.0f);
            this.addLabelCell("label.stammdaten.enfants.print.revenuNetApprentissage", 5);
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.RevenuNetApprentissage");
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.bourseApprentissage", 4);
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.BourseApprentissage");
            this.addLineBreak();
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.dateDebut", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.dateFin", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.deplacement", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.repas", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.pension", true);
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.fraisApprentissage", true);
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.DateDebutApprentissage");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.DateFinApprentissage");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.FraisDeplacementApprentissage");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.FraisRepasApprentissage");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.FraisChambreEtPensionApprentissage");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.TotalFraisApprentissage");
            this.addLineBreak();
            this.addEmptyCell(7);
            this.addLabelCell("label.stammdaten.enfants.print.revenuDeterminant", 4, true);
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.RevenuDeterminantApprentissage");
            this.addLineBreak();
            this.flushTable();
            this.yLine = EnfantsPrinter.this.drawHLine(this.writer, this.yLine);
            this.addLabelCell("label.stammdaten.enfants.print.revenuNetEtudes", 5);
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.RevenuNetEtudes");
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.bourseEtudes", 4);
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.BourseEtudes");
            this.addLineBreak();
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.dateDebut", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.dateFin", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.deplacement", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.repas", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.pension", true);
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.fraisEtudes", true);
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.DateDebutEtudes");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.DateFinEtudes");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.FraisDeplacementEtudes");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.FraisRepasEtudes");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.FraisChambreEtPensionEtudes");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.TotalFraisEtudes");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.fraisRevenuAccessoire", true);
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.DateDebutRevenuAccessoire");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.DateFinRevenuAccessoire");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.FraisDeplacementRevenuAccessoire");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.FraisRepasRevenuAccessoire");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.FraisChambreEtPensionRevenuAccessoire");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.TotalFraisRevenuAccessoire");
            this.addLineBreak();
            this.addEmptyCell(7);
            this.addLabelCell("label.stammdaten.enfants.print.revenuDeterminant", 4, true);
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.RevenuDeterminantEtudesEtAccessoire");
            this.addLineBreak();
            this.flushTable();
            this.yLine = EnfantsPrinter.this.drawHLine(this.writer, this.yLine);
            this.addLabelCell("label.stammdaten.enfants.print.revenuNetHorsEtudes", 5);
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.RevenuNet");
            this.addLineBreak();
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.dateDebut", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.dateFin", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.deplacement", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.repas", true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.pension", true);
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.fraisHorsEtudes", true);
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.DateDebut");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.DateFin");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.FraisDeplacement");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.FraisRepas");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.FraisChambreEtPension");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.TotalFrais");
            this.addLineBreak();
            this.addEmptyCell(7);
            this.addLabelCell("label.stammdaten.enfants.print.revenuDeterminant", 4, true);
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.RevenuDeterminant");
            this.flushTable(26.0f);
            this.startTable(new float[]{0.34f, 0.12f, 0.12f, 0.12f, 0.1f, 0.12f, 0.05f});
            this.addTitle("label.stammdaten.enfants.print.recapitulation");
            this.addLabelCell("label.stammdaten.enfants.print.instructionAuDehors", true);
            this.addLineBreak(6.0f);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.recapFraisRevenu", 1, 1, true);
            this.addLabelCell("label.stammdaten.enfants.print.recapFraisEtudes", 1, 1, true);
            this.addLabelCell("label.stammdaten.enfants.print.recapFraisHorsEtudes", 1, 1, true);
            this.addEmptyCell();
            this.addLabelCell("label.stammdaten.enfants.print.fraisAdmis", 1, 1, true);
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.recapRevenuNet");
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.RevenuNetApprentissage");
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.RevenuNetEtudes");
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.RevenuNet");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("Recapitulation.RevenuDeterminantTotal");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.bourse");
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.BourseApprentissage");
            this.addValueCellWithVAlignmentCenter("RevenuEtudes.BourseEtudes");
            this.addEmptyCell(2);
            this.addValueCellWithVAlignmentCenter("Recapitulation.BourseTotal");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.recapDeplacement");
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.FraisDeplacementApprentissage");
            this.addValueCellWithVAlignmentCenter("Recapitulation.FraisDeplacementEtudesEtAccessoire");
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.FraisDeplacement");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("Recapitulation.FraisDeplacementAdmis");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.recapRepas");
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.FraisRepasApprentissage");
            this.addValueCellWithVAlignmentCenter("Recapitulation.FraisRepasEtudesEtAccessoire");
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.FraisRepas");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("Recapitulation.FraisRepasAdmis");
            this.addLineBreak();
            this.addLabelCell("label.stammdaten.enfants.print.recapPension");
            this.addValueCellWithVAlignmentCenter("RevenuApprentissage.FraisChambreEtPensionApprentissage");
            this.addValueCellWithVAlignmentCenter("Recapitulation.FraisPensionEtudesEtAccessoire");
            this.addValueCellWithVAlignmentCenter("RevenuHorsEtudes.FraisChambreEtPension");
            this.addEmptyCell();
            this.addValueCellWithVAlignmentCenter("Recapitulation.FraisPensionAdmis");
            this.addLineBreak(12.0f);
            this.addLabelCell("label.stammdaten.enfants.print.instructionAuDehorsAdmis", 3, true);
            this.addValueCellWithVAlignmentCenter("Recapitulation.MontantAdmisPourInstructionExterieureICC", true);
            this.addLineBreak();
            this.flushTable();
        }
    }
}

