/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.printer;

import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.engine.printer.BasePrinter;
import ch.dvbern.tax.ju.engine.printer.TableBuilder;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfWriter;

public class FraisHomePrinter
extends BasePrinter {
    private boolean printFraisHomeHandicapCtr;
    private boolean printFraisHomeHandicapCjt;
    private boolean printFraisHomeMaladieCtr;
    private boolean printFraisHomeMaladieCjt;

    public FraisHomePrinter() {
        super("label.abzuege.fraisMaladieEtHandicap.home.print.title", "label.abzuege.fraisMaladieEtHandicap.home.print.outline", "fraismed_page1#");
    }

    @Override
    protected boolean initPrint() {
        this.printFraisHomeHandicapCtr = this.isActive("Abzuege.HomeHandicapContribuablePrintRowStateItem");
        this.printFraisHomeHandicapCjt = this.isActive("Abzuege.HomeHandicapConjointPrintRowStateItem");
        this.printFraisHomeMaladieCtr = this.isActive("Abzuege.HomeMaladieContribuablePrintRowStateItem");
        this.printFraisHomeMaladieCjt = this.isActive("Abzuege.HomeMaladieConjointPrintRowStateItem");
        return this.printFraisHomeHandicapCtr || this.printFraisHomeHandicapCjt || this.printFraisHomeMaladieCtr || this.printFraisHomeMaladieCjt;
    }

    private boolean isActive(String dmk) {
        ModelItemDTO item = this.dataModel.get((Object)dmk);
        return item != null && item.getState() != 12;
    }

    @Override
    protected void doPrintInternal(Document doc, PdfWriter writer, float topYLine) throws DocumentException {
        float yLine = topYLine;
        if (this.printFraisHomeHandicapCtr) {
            yLine = this.printTable(writer, yLine, "label.abzuege.fraisMaladieEtHandicap.home.print.titleHandicapContribuable", false, true);
        }
        if (this.printFraisHomeMaladieCtr) {
            yLine = this.printTable(writer, yLine, "label.abzuege.fraisMaladieEtHandicap.home.print.titleMaladieContribuable", false, false);
        }
        if (this.printFraisHomeHandicapCjt) {
            yLine = this.printTable(writer, yLine, "label.abzuege.fraisMaladieEtHandicap.home.print.titleHandicapConjoint", true, true);
        }
        if (this.printFraisHomeMaladieCjt) {
            this.printTable(writer, yLine, "label.abzuege.fraisMaladieEtHandicap.home.print.titleMaladieConjoint", true, false);
        }
    }

    private float printTable(PdfWriter writer, float yLine, String titleKey, boolean conjoint, boolean handicap) throws DocumentException {
        FraisHomeTableBuilder builder = new FraisHomeTableBuilder(this, this, writer, conjoint ? "Abzuege.FraisMaladieEtHandicapConjoint" : "Abzuege.FraisMaladieEtHandicapContribuable", yLine, titleKey, handicap);
        return builder.build();
    }

    private class FraisHomeTableBuilder
    extends TableBuilder {
        private final boolean handicap;
        private final String basePrefix;
        private final String titleKey;

        public FraisHomeTableBuilder(FraisHomePrinter fraisHomePrinter, BasePrinter printer, PdfWriter writer, String basePrefix, float yLine, String titleKey, boolean handicap) {
            super(printer, writer, null, yLine);
            this.basePrefix = basePrefix;
            this.handicap = handicap;
            this.titleKey = titleKey;
        }

        @Override
        protected void doBuild() {
            this.startTable(new float[]{0.03f, 0.25f, 0.12f, 0.05f, 0.17f, 0.12f, 0.11f, 0.03f, 0.12f});
            this.addTitle(this.titleKey);
            this.lmkPrefix = this.basePrefix + (this.handicap ? ".HomeHandicap" : ".HomeMaladie");
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.nombreJours", 2);
            this.addValueCellWithVAlignmentCenter("NombreJours");
            this.addLabelCell("label.multiply", 1, 1);
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.taxeJournaliere");
            this.addValueCellWithVAlignmentCenter("TaxeJournaliere");
            this.addEmptyCell(2);
            this.addValueCellWithVAlignmentCenter("TaxeJournaliereTotal", true);
            this.addLineBreak();
            this.addLabelCell("label.dont", 1, 1);
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.prestationsEnNature", 5);
            this.addEmptyCell();
            this.addLabelCell("label.minus", 1, 1);
            this.addValueCellWithVAlignmentCenter("PrestationsEnNature", true);
            this.addLineBreak();
            this.addLabelCell("label.dont", 1, 1);
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.prestationsComplementaire", 5);
            this.addEmptyCell();
            this.addLabelCell("label.minus", 1, 1);
            this.addValueCellWithVAlignmentCenter("PrestationsComplementaire");
            this.addLineBreak();
            this.addLabelCell("label.dont", 1, 1);
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.assurancesSociales", 5);
            this.addEmptyCell();
            this.addLabelCell("label.minus", 1, 1);
            this.addValueCellWithVAlignmentCenter("AssurancesSociales");
            this.addLineBreak();
            this.addLabelCell("label.plus", 1, 1);
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.participation", 8);
            this.addLineBreak();
            this.addEmptyCell();
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.nombreJoursSoins");
            this.addValueCellWithVAlignmentCenter("NombreJoursSoins");
            this.addLabelCell("label.multiply", 1, 1);
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.coutsSoins");
            this.addValueCellWithVAlignmentCenter("CoutsSoins");
            this.addEmptyCell();
            this.addLabelCell("label.plus", 1, 1);
            this.addValueCellWithVAlignmentCenter("CoutsSoinsTotal", true);
            this.addLineBreak();
            this.lmkPrefix = this.basePrefix + (this.handicap ? ".FraisHandicap" : ".FraisMaladie");
            this.addLabelCell("label.plus", 1, 1);
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.franchiseEtParticipation", 5);
            this.addEmptyCell();
            this.addLabelCell("label.plus", 1, 1);
            this.addValueCellWithVAlignmentCenter("TotalParticipations", 1, true);
            this.addLineBreak();
            this.addLabelCell("label.abzuege.fraisMaladieEtHandicap.home.total", 8);
            this.lmkPrefix = this.basePrefix + (this.handicap ? ".HomeHandicap" : ".HomeMaladie");
            this.addValueCellWithVAlignmentCenter("TotalDisplay", 1, true);
            this.flushTable(26.0f);
        }
    }
}

