/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.printer;

import ch.dvbern.tax.common.engine.FileData;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.transfer.dto.CustomPrinterDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.ju.engine.justificatifs.EReleveDocument;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedCategories;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedCategory;
import ch.dvbern.tax.ju.engine.justificatifs.ResolvedDocument;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JustificatifsPrinter
extends ExpertItemPrinter<CustomPrinterDTO> {
    private static final Font HEADER_FONT = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1);
    private static final Font LIST_FONT = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)0);
    private Map<String, LogicModelItem> logicModel = null;
    private LogicModelItem.ProtectedMap dataModel = null;

    protected void initalize(CustomPrinterDTO item) {
        this.dataModel = item.getDataModel();
        this.logicModel = item.getLogicModel();
    }

    protected void printInternal(float xOffset, float yOffset) throws FormRendererException {
        assert (this.dataModel != null && this.logicModel != null);
        List<EReleveDocument> ereleves = this.getEreleves();
        ResolvedCategories resolvedCategories = ResolvedCategories.resolve((Map<String, ModelItemDTO>)this.dataModel, this.logicModel);
        if (resolvedCategories.isAllRequired() || !resolvedCategories.getResolvedMap().isEmpty() || !ereleves.isEmpty()) {
            try {
                this.printDocument(resolvedCategories, xOffset, yOffset, ereleves);
            }
            catch (LocalizationHelper.LocalizationHelperException | DocumentException e) {
                throw new FormRendererException("Failed to print list", e);
            }
        }
    }

    private List<EReleveDocument> getEreleves() {
        Object taxTable = "TaxStatement.TaxStatementTable";
        HashSet erelevesNr = this.dataModel.get(taxTable) != null ? (HashSet)this.dataModel.get(taxTable).getValue() : null;
        ArrayList<EReleveDocument> ereleves = new ArrayList<EReleveDocument>();
        taxTable = (String)taxTable + ".";
        if (erelevesNr != null && !erelevesNr.isEmpty()) {
            for (String ereleveNr : erelevesNr) {
                String organisationName = String.valueOf(this.dataModel.get((Object)((String)taxTable + ereleveNr + ".OrganisationName")));
                String taxStatementFileName = String.valueOf(this.dataModel.get((Object)((String)taxTable + ereleveNr + ".TaxStatementFileName")));
                String clientFullName = String.valueOf(this.dataModel.get((Object)((String)taxTable + ereleveNr + ".ClientsFullNames")));
                FileData taxStatementPdf = (FileData)this.dataModel.get((Object)((String)taxTable + ereleveNr + ".TaxStatementPdf")).getValue();
                ereleves.add(new EReleveDocument(taxStatementFileName, organisationName, clientFullName, taxStatementPdf));
            }
        }
        return ereleves;
    }

    private void printDocument(ResolvedCategories resolvedCategories, float xOffset, float yOffset, List<EReleveDocument> ereleves) throws DocumentException, LocalizationHelper.LocalizationHelperException {
        int x = 50;
        int y = 390;
        int bottomMargin = 90;
        int extraPageY = 50;
        Document doc = this.getDocumentContext().getDocument();
        Rectangle pageSize = doc.getPageSize();
        float llx = 50.0f + xOffset;
        float lly = 90.0f + yOffset;
        float urx = pageSize.getWidth() - 50.0f;
        float ury = pageSize.getHeight() - 390.0f;
        float extraPageUry = pageSize.getHeight() - 50.0f;
        ColumnText ct = new ColumnText(this.getDirectContent());
        ct.setSimpleColumn(llx, lly, urx, ury);
        if (!ereleves.isEmpty()) {
            String headerEreleveStr = this.getGlobalConverterContext().getLocalizationHelper().translate("label.justificatifs.ereleve", new Object[0]);
            this.printEreleve(doc, llx, lly, urx, extraPageUry, ct, headerEreleveStr, ereleves);
        }
        if (resolvedCategories.isAllRequired()) {
            Chunk entry = new Chunk(this.getGlobalConverterContext().getLocalizationHelper().translate("label.justificatifs.tous", new Object[0]), LIST_FONT);
            ct.addText(entry);
            ct.go();
            return;
        }
        for (Map.Entry<ResolvedCategory, Set<ResolvedDocument>> entry : resolvedCategories.getResolvedMap().entrySet()) {
            ResolvedCategory category = entry.getKey();
            Set<ResolvedDocument> docLabels = entry.getValue();
            Iterator<ResolvedDocument> itr = docLabels.iterator();
            assert (itr.hasNext()) : "Category may not be empty";
            String categoryHeader = category.getLabel((Map<String, ModelItemDTO>)this.dataModel);
            Phrase header = new Phrase(categoryHeader, HEADER_FONT);
            Chunk firstEntry = new Chunk(itr.next().getLabel((Map<String, ModelItemDTO>)this.dataModel), LIST_FONT);
            float yLine = ct.getYLine();
            ct.addText(header);
            boolean pageBreak = false;
            if (ColumnText.hasMoreText((int)ct.go(true))) {
                pageBreak = true;
            } else {
                ct.addText(firstEntry);
                if (ColumnText.hasMoreText((int)ct.go(true))) {
                    pageBreak = true;
                }
            }
            if (pageBreak) {
                doc.newPage();
                ct.setSimpleColumn(llx, lly, urx, extraPageUry);
                yLine = extraPageUry;
            }
            ct.setYLine(yLine);
            this.printElements(doc, llx, lly, urx, extraPageUry, ct, categoryHeader, itr, header, firstEntry);
        }
    }

    private void printElements(Document doc, float llx, float lly, float urx, float extraPageUry, ColumnText ct, String categoryHeader, Iterator<ResolvedDocument> itr, Phrase header, Chunk firstEntry) throws DocumentException {
        ct.setText(header);
        ct.go();
        ct.addText(firstEntry);
        ct.go();
        while (itr.hasNext()) {
            float yLine = ct.getYLine();
            Chunk entry = new Chunk(itr.next().getLabel((Map<String, ModelItemDTO>)this.dataModel), LIST_FONT);
            ct.addText(entry);
            if (ColumnText.hasMoreText((int)ct.go(true))) {
                doc.newPage();
                ct.setSimpleColumn(llx, lly, urx, extraPageUry);
                ct.setYLine(extraPageUry);
                ct.setText(new Phrase(categoryHeader + " (suite)", HEADER_FONT));
                ct.go();
            } else {
                ct.setYLine(yLine);
            }
            ct.addText(entry);
            ct.go();
        }
    }

    private void printEreleve(Document doc, float llx, float lly, float urx, float extraPageUry, ColumnText ct, String headerEreleveStr, List<EReleveDocument> ereleves) throws DocumentException {
        Phrase headerEreleve = new Phrase(headerEreleveStr, HEADER_FONT);
        ct.setText(headerEreleve);
        ct.go();
        for (EReleveDocument ereleve : ereleves) {
            float yLine = ct.getYLine();
            String text = ereleve.getOrganisationName() + " - " + ereleve.getClientsFullNames();
            Chunk entry = new Chunk(text, LIST_FONT);
            ct.addText(entry);
            if (ColumnText.hasMoreText((int)ct.go(true))) {
                doc.newPage();
                ct.setSimpleColumn(llx, lly, urx, extraPageUry);
                ct.setYLine(extraPageUry);
                ct.setText(new Phrase(headerEreleveStr + " (suite)", HEADER_FONT));
                ct.go();
            } else {
                ct.setYLine(yLine);
            }
            ct.addText(entry);
            ct.go();
        }
    }
}

