/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.printer;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.engine.printer.BasePrinter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

abstract class TableBuilder {
    protected static final float GREY_FILL = 0.75f;
    protected static final float BORDER_WIDTH = 1.0f;
    private static final ThreadLocal<DateFormat> DATE_FMT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yy", JuUtil.APPLICATION_LOCALE);
            sdf.setTimeZone(ApplicationConfig.TIMEZONE);
            return sdf;
        }
    };
    private static final ThreadLocal<NumberFormat> NUMBER_FMT = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return NumberFormat.getInstance(JuUtil.APPLICATION_LOCALE);
        }
    };
    private final LogicModelItem.ProtectedMap dataModel;
    private final Map<String, LogicModelItem> logicModel;
    private int currentCellIndex;
    private PdfPTable currentTable;
    private int columnCount;
    protected float yLine;
    protected String lmkPrefix;
    protected String tableEntryDmk;
    protected BasePrinter printer;
    protected final PdfWriter writer;
    private static final PrintableValue EMPTY_VALUE = new PrintableValue("");

    TableBuilder(BasePrinter printer, PdfWriter writer, String tableEntryDmk, float yLine) {
        this.printer = printer;
        this.dataModel = printer.dataModel;
        this.logicModel = printer.logicModel;
        this.tableEntryDmk = tableEntryDmk;
        this.writer = writer;
        this.yLine = yLine;
    }

    public float build() throws DocumentException {
        this.doBuild();
        return this.yLine;
    }

    protected void flushTable() {
        this.flushTable(0.0f);
    }

    protected void flushTable(float spaceAfter) {
        this.yLine = this.currentTable.writeSelectedRows(0, -1, BasePrinter.PAGE_BODY.getLeft(), this.yLine, this.writer.getDirectContent());
        this.yLine -= spaceAfter;
        this.currentTable.deleteBodyRows();
    }

    protected void startTable(float[] headerWidths) {
        this.currentTable = new PdfPTable(headerWidths);
        this.columnCount = headerWidths.length;
        this.currentCellIndex = 0;
        this.currentTable.setTotalWidth(BasePrinter.PAGE_BODY.getWidth());
        this.currentTable.setLockedWidth(true);
    }

    protected void addTitle(String titleKey) {
        PdfPCell recapTitle = new PdfPCell(new Phrase(JuUtil.translate(titleKey, new Object[0]), BasePrinter.BOLD_FONT));
        recapTitle.setGrayFill(0.75f);
        recapTitle.setColspan(this.columnCount);
        recapTitle.setBorderWidth(1.0f);
        this.currentTable.addCell(recapTitle);
        this.addLineBreak(12.0f);
    }

    protected void addLineBreak() {
        this.addLineBreak(5.0f);
    }

    protected void addLineBreak(float height) {
        if (this.currentCellIndex > 0 && this.currentCellIndex < this.columnCount) {
            this.addEmptyCell(this.columnCount - this.currentCellIndex);
        }
        this.addEmptyCell(this.columnCount, height);
    }

    protected void addEmptyCell() {
        this.addEmptyCell(1);
    }

    protected void addEmptyCell(int colspan) {
        this.addEmptyCell(colspan, 3.0f, false);
    }

    protected void addEmptyCell(int colspan, boolean border) {
        this.addEmptyCell(colspan, 3.0f, border);
    }

    protected void addEmptyCell(int colspan, float height) {
        this.addEmptyCell(colspan, height, false);
    }

    protected void addEmptyCell(int colspan, float height, boolean border) {
        assert (colspan > 0 && this.currentCellIndex + colspan <= this.columnCount);
        PdfPCell cell = new PdfPCell();
        cell.setColspan(colspan);
        if (border) {
            cell.setBorderWidth(1.0f);
        } else {
            cell.setBorder(0);
        }
        cell.setMinimumHeight(height);
        this.currentTable.addCell(cell);
        this.currentCellIndex = (this.currentCellIndex + colspan) % this.columnCount;
    }

    protected void addLabelCell(String resKey) {
        this.addLabelCell(resKey, 1);
    }

    protected void addLabelCell(String resKey, boolean bold) {
        this.addLabelCell(resKey, 1, 0, bold, false);
    }

    protected void addLabelCell(String resKey, int colspan) {
        this.addLabelCell(resKey, colspan, 0, false, false);
    }

    protected void addLabelCell(String resKey, int colspan, boolean bold) {
        this.addLabelCell(resKey, colspan, 0, bold, false);
    }

    protected void addLabelCell(String resKey, int colspan, int hAlign) {
        this.addLabelCell(resKey, colspan, hAlign, false, false);
    }

    protected void addLabelCell(String resKey, int colspan, int hAlign, boolean bold) {
        this.addLabelCell(resKey, colspan, hAlign, bold, false);
    }

    protected void addLabelCell(String resKey, boolean bold, boolean border) {
        this.addLabelCell(resKey, 1, 0, bold, border);
    }

    protected void addLabelCell(String resKey, int colspan, int hAlign, boolean bold, boolean border) {
        assert (colspan > 0 && this.currentCellIndex + colspan <= this.columnCount);
        Phrase phrase = new Phrase(JuUtil.translate(resKey, new Object[0]), bold ? BasePrinter.BOLD_FONT : BasePrinter.DEFAULT_FONT);
        PdfPCell cell = new PdfPCell(phrase);
        cell.setVerticalAlignment(5);
        cell.setHorizontalAlignment(hAlign);
        if (border) {
            cell.setBorderWidth(1.0f);
        } else {
            cell.setBorder(0);
        }
        cell.setColspan(colspan);
        this.currentTable.addCell(cell);
        this.currentCellIndex = (this.currentCellIndex + colspan) % this.columnCount;
    }

    protected void addValueCell(String lmkSuffix) {
        this.addValueCell(lmkSuffix, 1, false);
    }

    protected void addValueCell(String lmkSuffix, boolean gray) {
        this.addValueCell(lmkSuffix, 1, gray);
    }

    protected void addValueCell(String lmkSuffix, int colspan) {
        this.addValueCell(lmkSuffix, colspan, false);
    }

    protected void addValueCellWithVAlignmentCenter(String lmkSuffix, int colspan) {
        this.addValueCellWithVAlignment(lmkSuffix, colspan, false, 1);
    }

    protected void addValueCellWithVAlignmentCenter(String lmkSuffix) {
        this.addValueCellWithVAlignment(lmkSuffix, 1, false, 1);
    }

    protected void addValueCellWithVAlignmentCenter(String lmkSuffix, boolean gray) {
        this.addValueCellWithVAlignment(lmkSuffix, 1, gray, 1);
    }

    protected void addValueCellWithVAlignmentCenter(String lmkSuffix, int colspan, boolean gray) {
        this.addValueCellWithVAlignment(lmkSuffix, colspan, gray, 1);
    }

    protected void addValueCell(String lmkSuffix, int colspan, boolean gray) {
        assert (lmkSuffix != null);
        PrintableValue value = this.getValue(lmkSuffix);
        PdfPCell cell = new PdfPCell(new Phrase(value.value, BasePrinter.DEFAULT_FONT));
        cell.setFixedHeight(BasePrinter.DEFAULT_FONT.getSize() + 5.0f);
        cell.setNoWrap(false);
        cell.setVerticalAlignment(5);
        cell.setHorizontalAlignment(value.aligment);
        cell.setColspan(colspan);
        cell.setBorderWidth(1.0f);
        if (gray) {
            cell.setGrayFill(0.75f);
        }
        this.currentTable.addCell(cell);
        this.currentCellIndex = (this.currentCellIndex + colspan) % this.columnCount;
    }

    protected void addValueCellWithVAlignment(String lmkSuffix, int colspan, boolean gray, int verticalAlignment) {
        assert (lmkSuffix != null);
        PrintableValue value = this.getValue(lmkSuffix);
        PdfPCell cell = new PdfPCell(new Phrase(value.value, BasePrinter.DEFAULT_FONT));
        cell.setFixedHeight(BasePrinter.DEFAULT_FONT.getSize() + 5.0f);
        cell.setNoWrap(false);
        cell.setVerticalAlignment(verticalAlignment);
        cell.setHorizontalAlignment(value.aligment);
        cell.setColspan(colspan);
        cell.setBorderWidth(1.0f);
        if (gray) {
            cell.setGrayFill(0.75f);
        }
        this.currentTable.addCell(cell);
        this.currentCellIndex = (this.currentCellIndex + colspan) % this.columnCount;
    }

    private PrintableValue getValue(String lmkSuffix) {
        assert (this.dataModel != null && lmkSuffix != null);
        String lmk = this.lmkPrefix != null ? this.lmkPrefix + "." + lmkSuffix : lmkSuffix;
        String dmk = this.tableEntryDmk != null ? EngineUtil.mergeModelKey((String)lmk, (String)this.tableEntryDmk) : lmk;
        ModelItemDTO item = this.dataModel.get((Object)dmk);
        LogicModelItem lmi = this.logicModel.get(lmk);
        if (lmi == null) {
            throw new IllegalStateException("Unknown logic model item: " + lmk);
        }
        if (item != null) {
            Object valueObj = item.getValue();
            if (lmi instanceof LogicModelItem.SelectItem && valueObj != null) {
                Object text;
                LogicModelItem.SelectItem select = (LogicModelItem.SelectItem)lmi;
                OptionItemsDTO optionsItems = select.getOptionItems(this.dataModel, this.tableEntryDmk);
                OptionItemDTO optionItem = optionsItems.get((Object)valueObj.toString());
                if (optionItem != null && (text = optionItem.getText()) != null) {
                    return new PrintableValue(JuUtil.translate(text.toString(), new Object[0]), 0);
                }
            } else {
                if (valueObj instanceof Number) {
                    return new PrintableValue(NUMBER_FMT.get().format(valueObj));
                }
                if (valueObj instanceof Date) {
                    return new PrintableValue(DATE_FMT.get().format(valueObj));
                }
                if (valueObj instanceof Boolean) {
                    if (((Boolean)valueObj).booleanValue()) {
                        return new PrintableValue(JuUtil.translate("label.ja", new Object[0]), 0);
                    }
                    return new PrintableValue(JuUtil.translate("label.nein", new Object[0]), 0);
                }
                if (valueObj instanceof String) {
                    return new PrintableValue((String)valueObj, 0);
                }
                if (valueObj != null) {
                    return new PrintableValue(valueObj.toString());
                }
            }
        }
        return EMPTY_VALUE;
    }

    protected abstract void doBuild();

    private static class PrintableValue {
        final String value;
        final int aligment;

        PrintableValue(String value) {
            this(value, 2);
        }

        PrintableValue(String value, int alignment) {
            assert (value != null);
            this.value = value;
            this.aligment = alignment;
        }
    }
}

