/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.util;

import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.DiagnosticModelVisitor;
import ch.dvbern.tax.ju.engine.util.PKeyTemplate;
import ch.dvbern.tax.ju.engine.util.PKeyTuple;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JuDiagnosticModelVisitor
extends DiagnosticModelVisitor {
    private final Set<PKeyTuple> dbTuple = new HashSet<PKeyTuple>();

    public JuDiagnosticModelVisitor() {
        super(true, false);
    }

    protected @Nullable Class<?> getLogicItemExpectedType(@NonNull LogicModelItem item) {
        Class<?> expectedType = null;
        List pKeyTemplates = item.getPersistenceKeyTemplates();
        for (int i = 0; i < item.getPersistenceKeyTemplates().size(); ++i) {
            PKeyTemplate template;
            try {
                template = PKeyTemplate.parse((String)pKeyTemplates.get(i));
            }
            catch (IllegalArgumentException e) {
                this.notifyError("Cannot parse pKey template %s for item %s: %s", new Object[]{item.getName(), pKeyTemplates.get(i), e.getMessage()});
                continue;
            }
            if (i == 0) {
                if (!this.dbTuple.add(template.pkTuple)) {
                    this.notifyError("pKey tuple detected multiple times: %s", new Object[]{template.pkTuple.toExternalForm()});
                }
            } else if (template.pkTuple.isIntern()) {
                this.notifyError("Intern pKey tuple should only be used for DB persistence: %s", new Object[]{template.pkTuple});
            }
            Class<?> templateType = template.type.getTargetType();
            if (expectedType == null) {
                expectedType = templateType;
                continue;
            }
            if (expectedType.equals(templateType)) continue;
            this.notifyError("Item %s defines multiple pKey template with different target types: %s", new Object[]{item.getName(), item.getPersistenceKeyTemplates()});
            return null;
        }
        return expectedType;
    }
}

