/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.util;

import ch.dvbern.tax.ju.engine.util.PKeyTuple;
import ch.dvbern.tax.ju.engine.util.PKeyType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PKey {
    private static final Pattern PTN = Pattern.compile(String.format("(%s);(%s)-(%s);(\\w+)(?:;([0-9]+)(?:;([0-9]+))?)?", PKeyTuple.DOCUMENT_PTN, PKeyTuple.ZIFFER_PTN, PKeyTuple.ZELLE_PTN));
    public final PKeyTuple pkTuple;
    public final PKeyType pkType;
    public final int lnDokument;
    public final int lnZelle;
    private final String externalForm;
    private final int hashcode;

    public PKey(@NonNull PKeyTuple pkTuple, @NonNull PKeyType pkType, int lnDokument, int lnZelle) {
        if (pkTuple == null) {
            throw new NullPointerException("PKey tuple cannot be null.");
        }
        if (pkType == null) {
            throw new NullPointerException("PKey type cannot be null.");
        }
        if (lnDokument < 0 || lnZelle < 0 || lnZelle != 0 && lnDokument == 0) {
            throw new IllegalArgumentException(String.format("Invalid indexes: lnDokument=%d, lnZelle=%d", lnDokument, lnZelle));
        }
        this.pkTuple = pkTuple;
        this.pkType = pkType;
        this.lnDokument = lnDokument;
        this.lnZelle = lnZelle;
        this.hashcode = new HashCodeBuilder(1659544927, 1807972489).append((Object)pkTuple).append((Object)pkType).append(lnDokument).append(lnZelle).build();
        StringBuilder sb = new StringBuilder(pkTuple.dokument + ";" + pkTuple.ziffer + "-" + pkTuple.zelle + ";" + String.valueOf((Object)pkType));
        if (lnDokument > 0) {
            sb.append(";").append(lnDokument);
        }
        if (lnZelle > 0) {
            assert (lnDokument > 0);
            sb.append(";").append(lnZelle);
        }
        this.externalForm = sb.toString();
    }

    public static PKey parse(String pKey) {
        int lnZelle;
        int lnDokument;
        if (pKey == null) {
            throw new NullPointerException("Persistence key string cannot be null");
        }
        Matcher m = PTN.matcher(pKey);
        if (!m.matches()) {
            throw new IllegalArgumentException("Cannot parse persistence key string: " + pKey);
        }
        PKeyTuple tuple = new PKeyTuple(m.group(1), m.group(2), m.group(3));
        PKeyType pkType = PKeyType.valueOf(m.group(4));
        String lnDokumentStr = m.group(5);
        if (lnDokumentStr != null) {
            lnDokument = Integer.parseInt(lnDokumentStr);
            String lnZelleStr = m.group(6);
            lnZelle = lnZelleStr != null ? Integer.parseInt(lnZelleStr) : 0;
        } else {
            assert (m.group(6) == null);
            lnZelle = 0;
            lnDokument = 0;
        }
        return new PKey(tuple, pkType, lnDokument, lnZelle);
    }

    public String toExternalForm() {
        return this.externalForm;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PKey) {
            PKey that = (PKey)obj;
            return this.hashcode == that.hashcode && this.pkTuple.equals(that.pkTuple) && this.pkType == that.pkType && this.lnDokument == that.lnDokument && this.lnZelle == that.lnZelle;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("pkTuple", (Object)this.pkTuple).append("pkType", (Object)this.pkType).append("lnDokument", this.lnDokument).append("lnZelle", this.lnZelle).toString();
    }
}

