/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.util;

import ch.dvbern.tax.ju.engine.util.PKey;
import ch.dvbern.tax.ju.engine.util.PKeyTuple;
import ch.dvbern.tax.ju.engine.util.PKeyType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PKeyTemplate {
    public static final Pattern MULTIPLE_FLAG_PTN = Pattern.compile(Pattern.quote("#"));
    public final PKeyTuple pkTuple;
    public final PKeyType type;
    public final boolean multipleDoc;
    public final boolean multipleLine;
    private static final Pattern PTN = Pattern.compile(String.format("(%s);(%s)-(%s);(\\w+)(;#)?(;#)?", PKeyTuple.DOCUMENT_PTN, PKeyTuple.ZIFFER_PTN, PKeyTuple.ZELLE_PTN));

    public PKeyTemplate(PKeyTuple pkTuple, PKeyType type, boolean multipleDoc, boolean multipleLine) {
        this.pkTuple = pkTuple;
        this.type = type;
        this.multipleDoc = multipleDoc;
        this.multipleLine = multipleLine;
    }

    public static PKeyTemplate parse(String pKeyTemplate) {
        if (pKeyTemplate == null) {
            throw new NullPointerException("Template string cannot be null");
        }
        Matcher m = PTN.matcher(pKeyTemplate);
        if (!m.matches()) {
            throw new IllegalArgumentException("Cannot parse template string: " + pKeyTemplate);
        }
        try {
            PKeyTuple tuple = new PKeyTuple(m.group(1), m.group(2), m.group(3));
            String pKeyTypeText = m.group(4);
            PKeyType type = PKeyType.valueOf(pKeyTypeText);
            boolean multipleDoc = m.group(5) != null;
            boolean multipleLine = m.group(6) != null;
            return new PKeyTemplate(tuple, type, multipleDoc, multipleLine);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse pKey template: " + pKeyTemplate, e);
        }
    }

    public PKey generatePKey(int lnDokument, int lnZelle) {
        if (lnDokument > 0 && !this.multipleDoc || lnZelle > 0 && !this.multipleLine) {
            throw new IllegalArgumentException("Incompatible indexes");
        }
        return new PKey(this.pkTuple, this.type, lnDokument, lnZelle);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("pkTuple", (Object)this.pkTuple).append("type", (Object)this.type).append("multipleDoc", this.multipleDoc).append("multipleLine", this.multipleLine).build();
    }
}

