/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PKeyTuple {
    public static final String INTERN_PKEY_DOCUMENT = "9999";
    public static final Pattern DOCUMENT_PTN = Pattern.compile("\\d{4}");
    public static final Pattern ZIFFER_PTN = Pattern.compile("\\p{Alnum}+(?:\\.\\d+)*");
    public static final Pattern ZELLE_PTN = Pattern.compile("\\d+");
    public final String dokument;
    public final String ziffer;
    public final String zelle;
    private final int hashcode;

    public PKeyTuple(String dokument, String ziffer, String zelle) {
        if (dokument == null) {
            throw new NullPointerException("Document cannot be null.");
        }
        if (ziffer == null) {
            throw new NullPointerException("Ziffer cannot be null");
        }
        if (zelle == null) {
            throw new NullPointerException("Zelle cannot be null");
        }
        if (!DOCUMENT_PTN.matcher(dokument).matches()) {
            throw new IllegalArgumentException("Invalid document: " + dokument);
        }
        if (!ZIFFER_PTN.matcher(ziffer).matches()) {
            throw new IllegalArgumentException("Invalid ziffer: " + ziffer);
        }
        if (!ZELLE_PTN.matcher(zelle).matches()) {
            throw new IllegalArgumentException("Invalid zelle: " + zelle);
        }
        this.dokument = dokument;
        this.ziffer = ziffer;
        this.zelle = zelle;
        this.hashcode = new HashCodeBuilder(1847723879, 1545624253).append((Object)dokument).append((Object)ziffer).append((Object)zelle).build();
    }

    public String toExternalForm() {
        return this.dokument + ";" + this.ziffer + "-" + this.zelle;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("dokument", (Object)this.dokument).append("ziffer", (Object)this.ziffer).append("zelle", (Object)this.zelle).build();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PKeyTuple)) {
            return false;
        }
        PKeyTuple that = (PKeyTuple)obj;
        return this.hashcode == that.hashcode && this.dokument.equals(that.dokument) && this.ziffer.equals(that.ziffer) && this.zelle.equals(that.zelle);
    }

    public boolean isIntern() {
        return INTERN_PKEY_DOCUMENT.equals(this.dokument);
    }

    public int hashCode() {
        return this.hashcode;
    }
}

