/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.validators;

import ch.dvbern.tax.common.ejb.util.CDIHelper;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.ValorDatabaseDTO;
import ch.dvbern.tax.ju.integration.valoren.Aktie;
import ch.dvbern.tax.ju.integration.valoren.Derivate;
import ch.dvbern.tax.ju.integration.valoren.Obligation;
import ch.dvbern.tax.ju.integration.valoren.Valor;
import ch.dvbern.tax.ju.integration.valoren.ValorenSearchService;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateFromValorNumber
implements Validator {
    private static final String KEP = "kep";
    private static final Logger LOG = LoggerFactory.getLogger(EvaluateFromValorNumber.class);
    private final @NonNull String code;
    private final @NonNull DataResource dataResource;
    private final @NonNull String resourceCodeValoren;
    private final @NonNull String resourceCodeWaehrungen;
    private final @NonNull Reference steuerjahrRef;
    private final @NonNull Reference valorNummerRef;
    private final @NonNull Reference commandItemRef;
    private final @NonNull String message;

    public EvaluateFromValorNumber(@NonNull String code, @NonNull DataResource dataResource, @NonNull String resourceCodeValoren, @NonNull String resourceCodeWaehrungen, @NonNull Reference steuerjahrRef, @NonNull Reference valorNummerRef, @NonNull Reference commandItemRef, @NonNull String message) {
        assert (code != null);
        this.code = code;
        assert (dataResource != null);
        this.dataResource = dataResource;
        assert (resourceCodeValoren != null);
        this.resourceCodeValoren = resourceCodeValoren;
        assert (resourceCodeWaehrungen != null);
        this.resourceCodeWaehrungen = resourceCodeWaehrungen;
        assert (steuerjahrRef != null);
        this.steuerjahrRef = steuerjahrRef;
        assert (valorNummerRef != null);
        this.valorNummerRef = valorNummerRef;
        assert (commandItemRef != null);
        this.commandItemRef = commandItemRef;
        assert (commandItemRef != null);
        this.message = message;
    }

    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.steuerjahrRef.registerListenerOnReference(logicModel, logicModelItem, false);
        this.valorNummerRef.registerListenerOnReference(logicModel, logicModelItem, false);
        this.commandItemRef.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        String command = "";
        ModelItemDTO miCommandItem = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.commandItemRef.getName(), (String)dataModelKey));
        if (miCommandItem != null && miCommandItem.getValue() != null) {
            command = miCommandItem.getValue().toString();
        }
        if ("doSearch".equalsIgnoreCase(command)) {
            Integer sj = null;
            ModelItemDTO miSteuerjahr = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.steuerjahrRef.getName(), (String)dataModelKey));
            if (miSteuerjahr != null && miSteuerjahr.getValue() instanceof Number) {
                sj = ((Number)miSteuerjahr.getValue()).intValue();
            }
            if (sj == null) {
                throw new IllegalArgumentException("Steuerjahr darf nicht null sein");
            }
            Long vn = null;
            ModelItemDTO miValorNummer = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.valorNummerRef.getName(), (String)dataModelKey));
            if (miValorNummer != null && miValorNummer.getValue() instanceof Number) {
                vn = ((Number)miValorNummer.getValue()).longValue();
            }
            if (vn != null) {
                try {
                    Object newValue = ApplicationConfig.getInstance().useICTax() != false ? this.evaluateWithICTax(sj, vn) : this.evaluateWithoutICTax(sj, vn);
                    if (newValue != null) {
                        if (this.message != null) {
                            modelItemDTO = modelItemDTO.clone(newValue, 2, this.message, null, 2);
                            modelItemDTO.setTouched();
                        } else {
                            modelItemDTO = modelItemDTO.clone(newValue);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn("could not evaluate valor number for: {}/n Cause: {}", new Object[]{this.valorNummerRef, e.getCause(), e});
                    return modelItemDTO;
                }
            }
        }
        return modelItemDTO;
    }

    private @Nullable Object evaluateWithoutICTax(int steuerjahr, Long valorNummer) {
        ValorDatabaseDTO vDTO = (ValorDatabaseDTO)this.dataResource.get(this.resourceCodeValoren, (Object)steuerjahr, null).get(valorNummer);
        Object newValue = null;
        if (vDTO != null && (vDTO.getType() == 1 || vDTO.getType() == 2)) {
            if ("WAEHRUNGSCODE".equalsIgnoreCase(this.code)) {
                try {
                    newValue = Long.valueOf(vDTO.getWaehrungscode());
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("could not convert currency code for: {}", (Object)vDTO.getWaehrungscode(), (Object)nfe);
                }
            }
            if ("BEZEICHNUNG".equalsIgnoreCase(this.code)) {
                newValue = vDTO.getBezeichnung();
            }
            if ("TERMIN".equalsIgnoreCase(this.code)) {
                newValue = vDTO.getTermin();
            }
            if ("ERTRAG".equalsIgnoreCase(this.code)) {
                newValue = vDTO.getErtrag();
            }
            if ("STEUERWERT".equalsIgnoreCase(this.code)) {
                newValue = vDTO.getSteuerwert();
            }
            if ("SICAVB".equalsIgnoreCase(this.code)) {
                newValue = vDTO.getSicavb();
            }
            if ("VSTUNTERLIEGEND".equalsIgnoreCase(this.code)) {
                newValue = vDTO.getVstUnterliegend();
            }
            if ("EMISSION".equalsIgnoreCase(this.code) && vDTO.getRueckzahlung() != null && vDTO.getEmissionsjahr() != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(vDTO.getRueckzahlung());
                c.set(1, vDTO.getEmissionsjahr());
                newValue = c.getTime();
            }
            if ("RUECKZAHLUNG".equalsIgnoreCase(this.code)) {
                newValue = vDTO.getRueckzahlung();
            }
            if ("ZINS".equalsIgnoreCase(this.code)) {
                newValue = vDTO.getZins();
            }
        }
        return newValue;
    }

    private static @Nullable Double toDouble(@Nullable BigDecimal bd) {
        if (bd == null) {
            return null;
        }
        return bd.doubleValue();
    }

    private @Nullable Object evaluateWithICTax(int steuerjahr, Long valorNummer) {
        ValorenSearchService valorSearch = (ValorenSearchService)CDIHelper.get(ValorenSearchService.class, (Annotation[])new Annotation[0]);
        List<Valor> valoren = valorSearch.readValoren(steuerjahr, null, valorNummer);
        if (valoren.isEmpty()) {
            return null;
        }
        Valor vDTO = valoren.get(0);
        Object newValue = null;
        if ("BEZEICHNUNG".equalsIgnoreCase(this.code)) {
            newValue = vDTO instanceof Obligation && ((Obligation)vDTO).isEinmalverzinsung() ? "" : vDTO.getBezeichnung();
        }
        if ("WAEHRUNGSCODE".equalsIgnoreCase(this.code)) {
            try {
                String isoCode = vDTO.getWaehrungsCode();
                Map isoCodes = this.dataResource.get(this.resourceCodeWaehrungen, null, null);
                OptionItemDTO dto = (OptionItemDTO)isoCodes.get(isoCode);
                newValue = dto.getValue();
            }
            catch (Exception nfe) {
                LOG.warn("could not convert currency code from icTax for:{}", (Object)vDTO.getWaehrungsCode());
            }
        }
        if ("VSTUNTERLIEGEND".equalsIgnoreCase(this.code)) {
            newValue = vDTO.isVstUnterliegend();
        }
        if (vDTO instanceof Aktie) {
            Aktie aktie = (Aktie)vDTO;
            if ("STEUERWERT".equalsIgnoreCase(this.code)) {
                newValue = EvaluateFromValorNumber.toDouble(aktie.getSteuerwertProStk());
            }
            if ("TERMIN".equalsIgnoreCase(this.code)) {
                newValue = aktie.getDividendentermin();
            }
            if ("ERTRAG_CHF".equalsIgnoreCase(this.code)) {
                newValue = aktie.getSign() != null && aktie.getSign().toLowerCase().equals(KEP) ? Double.valueOf(0.0) : EvaluateFromValorNumber.toDouble(aktie.getDividendeProStkCHF());
            }
            if ("ERTRAG_FW".equalsIgnoreCase(this.code)) {
                newValue = EvaluateFromValorNumber.toDouble(aktie.getDividendeProStkFW());
            }
        } else if (vDTO instanceof Obligation) {
            Obligation obligation = (Obligation)vDTO;
            if (!obligation.isEinmalverzinsung()) {
                Calendar c;
                if ("ZINS".equalsIgnoreCase(this.code)) {
                    newValue = EvaluateFromValorNumber.toDouble(obligation.getZinsInProzent());
                }
                if ("STEUERWERT".equalsIgnoreCase(this.code)) {
                    newValue = EvaluateFromValorNumber.toDouble(obligation.getSteuerwertInProzent());
                }
                if ("EMISSION".equalsIgnoreCase(this.code) && obligation.getDatumRueckzahlung() != null && obligation.getEmissionsJahr() != null) {
                    c = Calendar.getInstance();
                    c.setTime(obligation.getDatumRueckzahlung());
                    c.set(1, obligation.getEmissionsJahr().intValue());
                    newValue = c.getTime();
                }
                if ("ISSUEDATE".equalsIgnoreCase(this.code) && obligation.getIssueDate() != null) {
                    c = Calendar.getInstance();
                    c.setTime(obligation.getIssueDate());
                    newValue = c.getTime();
                }
                if ("RUECKZAHLUNG".equalsIgnoreCase(this.code)) {
                    newValue = obligation.getDatumRueckzahlung();
                }
                if ("ZINSTERMIN".equalsIgnoreCase(this.code) && obligation.getZinstermin() != null) {
                    c = Calendar.getInstance();
                    c.setTime(obligation.getZinstermin());
                    newValue = c.getTime();
                }
            } else {
                if ("ZINS".equalsIgnoreCase(this.code)) {
                    newValue = 0.0;
                }
                if ("STEUERWERT".equalsIgnoreCase(this.code)) {
                    newValue = 0.0;
                }
                if ("EMISSION".equalsIgnoreCase(this.code)) {
                    newValue = null;
                }
                if ("RUECKZAHLUNG".equalsIgnoreCase(this.code)) {
                    newValue = null;
                }
            }
        } else if (vDTO instanceof Derivate) {
            newValue = null;
        }
        return newValue;
    }
}

