/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.validators;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.transfer.dto.NoContribuable;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class VerifyNoContribuableCelibataire
implements Validator {
    private final Reference marie;
    private final String message;
    private final String emptyMessage;

    public VerifyNoContribuableCelibataire(Reference marie, String message, String emptyMessage) {
        this.message = message;
        this.emptyMessage = emptyMessage;
        this.marie = marie;
    }

    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.marie.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        boolean isMarie;
        Object value = modelItemDTO.getValue();
        if (value == null) {
            return modelItemDTO.clone(4, this.emptyMessage, null, 4);
        }
        ModelItemDTO miDTO = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.marie.getName(), (String)dataModelKey));
        if (miDTO != null && miDTO.getValue() != null && miDTO.getValue() instanceof Boolean && !this.numeroContribuableIsCorrect((String)value, isMarie = ((Boolean)miDTO.getValue()).booleanValue())) {
            return modelItemDTO.clone(4, this.message, null, 4);
        }
        return modelItemDTO;
    }

    private boolean numeroContribuableIsCorrect(String noContribuable, boolean isMarie) {
        String endOfNoContribuable = noContribuable.substring(12);
        try {
            if (NoContribuable.parse(noContribuable).isDummy()) {
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            return true;
        }
        boolean isEndOfNoContribuableForMarie = this.isEndOfNoContribuableForMarie(endOfNoContribuable);
        if (isMarie && !isEndOfNoContribuableForMarie) {
            return false;
        }
        return isMarie || !isEndOfNoContribuableForMarie;
    }

    private boolean isEndOfNoContribuableForMarie(String endOfNoContribuable) {
        return endOfNoContribuable.startsWith("5") || endOfNoContribuable.startsWith("7") || endOfNoContribuable.startsWith("8");
    }
}

