/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.engine.validators;

import ch.dvbern.tax.common.ejb.util.CDIHelper;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.ValorDatabaseDTO;
import ch.dvbern.tax.ju.integration.valoren.Aktie;
import ch.dvbern.tax.ju.integration.valoren.Derivate;
import ch.dvbern.tax.ju.integration.valoren.Obligation;
import ch.dvbern.tax.ju.integration.valoren.Valor;
import ch.dvbern.tax.ju.integration.valoren.ValorenSearchService;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyValorNumber
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(VerifyValorNumber.class);
    private final @Nullable Integer type;
    private final @NonNull DataResource dataResource;
    private final @NonNull String dataResourceValor;
    private final @NonNull Reference steuerjahr;
    private final @NonNull Reference valorNummer;
    private final @NonNull Reference commandItem;
    private final @NonNull String message;
    public static final int VALOR_TYPE_AKTIE = 1;
    public static final int VALOR_TYPE_OBLIGATION = 2;
    public static final int VALOR_TYPE_OBLIGATION_EINMALVERZINSUNG = 3;
    public static final int VALOR_TYPE_DERIVATE = 4;

    public VerifyValorNumber(@NonNull DataResource dataResource, @NonNull String dataResourceValor, @NonNull Reference steuerjahr, @NonNull Reference valorNummer, @NonNull Reference commandItem, @NonNull String message) {
        this.type = null;
        assert (dataResource != null);
        this.dataResource = dataResource;
        assert (dataResourceValor != null);
        this.dataResourceValor = dataResourceValor;
        assert (steuerjahr != null);
        this.steuerjahr = steuerjahr;
        assert (valorNummer != null);
        this.valorNummer = valorNummer;
        assert (commandItem != null);
        this.commandItem = commandItem;
        assert (message != null);
        this.message = message;
    }

    public VerifyValorNumber(int type, @NonNull DataResource dataResource, @NonNull String dataResourceValor, @NonNull Reference steuerjahr, @NonNull Reference valorNummer, @NonNull Reference commandItem, @NonNull String message) {
        this.type = type;
        this.dataResource = dataResource;
        this.dataResourceValor = dataResourceValor;
        this.steuerjahr = steuerjahr;
        this.valorNummer = valorNummer;
        this.commandItem = commandItem;
        this.message = message;
    }

    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.steuerjahr.registerListenerOnReference(logicModel, logicModelItem, false);
        this.valorNummer.registerListenerOnReference(logicModel, logicModelItem, false);
        this.commandItem.registerListenerOnReference(logicModel, logicModelItem, false);
    }

    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        String command = "";
        ModelItemDTO miDTOCommand = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.commandItem.getName(), (String)dataModelKey));
        if (miDTOCommand != null && miDTOCommand.getValue() != null) {
            command = miDTOCommand.getValue().toString();
        }
        if ("doSearch".equalsIgnoreCase(command)) {
            Long steuerJahr = null;
            ModelItemDTO miDTOSteuerjahr = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.steuerjahr.getName(), (String)dataModelKey));
            if (miDTOSteuerjahr != null && miDTOSteuerjahr.getValue() instanceof Number) {
                steuerJahr = ((Number)miDTOSteuerjahr.getValue()).longValue();
            }
            Long valorenNummer = null;
            ModelItemDTO itemDTOValorNummer = dataModel.get((Object)EngineUtil.mergeModelKey((String)this.valorNummer.getName(), (String)dataModelKey));
            if (itemDTOValorNummer != null && itemDTOValorNummer.getValue() instanceof Number) {
                valorenNummer = ((Number)itemDTOValorNummer.getValue()).longValue();
            }
            modelItemDTO = ApplicationConfig.getInstance().useICTax() != false ? this.validateWithICTax(valorenNummer, steuerJahr, modelItemDTO) : this.validateWithoutICTax(valorenNummer, steuerJahr, modelItemDTO);
        }
        return modelItemDTO;
    }

    public @NonNull ModelItemDTO validateWithoutICTax(@Nullable Long vn, @Nullable Long sj, @NonNull ModelItemDTO modelItemDTO) {
        ModelItemDTO result = modelItemDTO;
        ValorDatabaseDTO vDTO = (ValorDatabaseDTO)this.dataResource.get(this.dataResourceValor, (Object)sj, null).get(vn);
        if (this.type == null && vDTO == null) {
            result = result.clone(4, this.message, null, 4);
        }
        if (this.type != null && vDTO != null && this.type.equals(vDTO.getType())) {
            result = this.message.startsWith("error") ? result.clone(4, this.message, null, 4) : result.clone(2, this.message, null, 2);
        }
        return result;
    }

    public @NonNull ModelItemDTO validateWithICTax(@Nullable Long valorenNummer, @Nullable Long steuerJahr, @NonNull ModelItemDTO modelItemDTO) {
        ValorenSearchService valorSearch = (ValorenSearchService)CDIHelper.get(ValorenSearchService.class, (Annotation[])new Annotation[0]);
        ModelItemDTO result = modelItemDTO;
        Valor vDTO = null;
        try {
            if (valorenNummer != null && steuerJahr != null) {
                List<Valor> valoren = valorSearch.readValoren(steuerJahr.intValue(), null, valorenNummer);
                if (valoren.isEmpty()) {
                    return modelItemDTO.clone(4, "error.valor.valornotfound", null, 4);
                }
                vDTO = valoren.get(0);
            }
            if (this.type == null && vDTO == null) {
                result = result.clone(4, this.message, null, 4);
            } else if (this.type != null && vDTO != null) {
                boolean aktie_retValue = vDTO instanceof Aktie;
                boolean aktie_abfrage = this.type.equals(1);
                boolean obligation_retValue = vDTO instanceof Obligation;
                boolean obligation_abfrage = this.type.equals(2);
                boolean einmalVerzinsung = vDTO instanceof Obligation && ((Obligation)vDTO).isEinmalverzinsung();
                boolean einmalVerzinsung_abfrage = this.type.equals(3);
                boolean derivate_abfrage = this.type.equals(4);
                if (aktie_abfrage) {
                    if (aktie_retValue) {
                        result = this.message.startsWith("error") ? result.clone(4, this.message, null, 4) : result.clone(2, this.message, null, 2);
                    }
                } else if (obligation_abfrage) {
                    if (obligation_retValue) {
                        if (this.message.startsWith("error") && !einmalVerzinsung) {
                            result = result.clone(4, this.message, null, 4);
                        } else if (!einmalVerzinsung) {
                            result = result.clone(2, this.message, null, 2);
                        } else if (this.type.equals("2")) {
                            result = result.clone(4, this.message, null, 4);
                        }
                    }
                } else if (einmalVerzinsung && einmalVerzinsung_abfrage) {
                    result = result.clone(2, this.message, null, 2);
                } else if (derivate_abfrage && vDTO instanceof Derivate) {
                    result = result.clone(2, this.message, null, 2);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("could not verify valor number", (Throwable)e);
        }
        return result;
    }
}

