/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.common;

import ch.dvbern.tax.common.engine.DataResourceBase;
import ch.dvbern.tax.common.engine.util.Resource;
import ch.dvbern.tax.common.engine.util.ResourceLineIterator;
import ch.dvbern.tax.common.engine.util.ResourceProvider;
import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.ValorDatabaseDTO;
import ch.dvbern.tax.ju.JuUtil;
import ch.dvbern.tax.ju.transfer.dto.DeductionPersonnesAgeesOuInfirmesMariesModelItem;
import ch.dvbern.tax.ju.transfer.dto.DeductionPersonnesAgeesOuInfirmesNonMariesModelItem;
import ch.dvbern.tax.ju.transfer.dto.ImpotDTO;
import ch.dvbern.tax.ju.transfer.dto.ImpotsCommunauxModelItem;
import java.io.IOException;
import java.io.Reader;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class JuDataResourceBase
extends DataResourceBase {
    public static final String FILE_DELIMITER = "\t";
    private static final String ETRANGER_ID = "1";

    public JuDataResourceBase(@NonNull ResourceProvider resourceProvider) {
        super(resourceProvider);
    }

    protected @NonNull Resource getResource(String code) {
        return ResourceEnum.forCode(code);
    }

    private static ValorDatabaseDTO getValueLessValorDTO(ValorDatabaseDTO template, boolean mehrzeiler) {
        ValorDatabaseDTO result = new ValorDatabaseDTO();
        result.setNummer(template.getNummer());
        result.setType(template.getType());
        result.setBezeichnung(template.getBezeichnung());
        result.setWaehrungscode(template.getWaehrungscode());
        if (mehrzeiler) {
            result.setSteuerwert(template.getSteuerwert());
        }
        return result;
    }

    public static enum ResourceEnum implements Resource
    {
        COMMUNES_JU("communesJU"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, OptionItemDTO> communesJU = new LinkedHashMap<String, OptionItemDTO>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(8);
                    Long key = Long.valueOf(tokens[0]);
                    String shortText = tokens[2];
                    String bezeichnung = tokens[3];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)key, shortText, bezeichnung, false);
                    communesJU.put(key.toString(), optionItemDTO);
                }
                return communesJU;
            }
        }
        ,
        PROFESSION("profession"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, OptionItemDTO> myMap = new LinkedHashMap<String, OptionItemDTO>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    Long key = Long.valueOf(tokens[0]);
                    String description = tokens[1];
                    String activitePrincipale = tokens[2];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)key, activitePrincipale, description, false);
                    myMap.put(key.toString(), optionItemDTO);
                }
                return myMap;
            }
        }
        ,
        IMPOTS_COMMUNAUX("impotsCommunaux", "communesJU"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, ImpotsCommunauxModelItem> impotsCommunaux = new LinkedHashMap<String, ImpotsCommunauxModelItem>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(8);
                    Long key = Long.valueOf(tokens[0]);
                    String quotiteCommune = tokens[4];
                    String pourcentCatholique = tokens[5];
                    String pourcentReforme = tokens[6];
                    String pourcentTaxeImmobiliereCommune = tokens[7];
                    ImpotsCommunauxModelItem impotCommunauxModelItem = new ImpotsCommunauxModelItem(key, quotiteCommune, pourcentCatholique, pourcentReforme, pourcentTaxeImmobiliereCommune);
                    impotsCommunaux.put(key.toString(), impotCommunauxModelItem);
                }
                return impotsCommunaux;
            }
        }
        ,
        CANTONS("cantons", "cantonsEtEtranger"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                boolean idFound;
                Map<?, ?> cantons = CANTONS_ET_ETRANGER.parse(reader);
                boolean bl = idFound = cantons.remove(JuDataResourceBase.ETRANGER_ID) != null;
                assert (idFound);
                return cantons;
            }
        }
        ,
        CANTONS_ET_ETRANGER("cantonsEtEtranger"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, OptionItemDTO> myCantonsEtEtranger = new LinkedHashMap<String, OptionItemDTO>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    Long key = Long.valueOf(tokens[0]);
                    String bezeichnung = tokens[1];
                    String kurzbezeichnung = tokens[2];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)key, kurzbezeichnung, bezeichnung, false);
                    myCantonsEtEtranger.put(key.toString(), optionItemDTO);
                }
                return myCantonsEtEtranger;
            }
        }
        ,
        DEDUCTION_PERSONNE_AGEE_NON_MARIEES("deductionPersonneAgeeNonMariee"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, DeductionPersonnesAgeesOuInfirmesNonMariesModelItem> myMap = new LinkedHashMap<String, DeductionPersonnesAgeesOuInfirmesNonMariesModelItem>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String fourchetteMontantMin = tokens[0];
                    Long key = Long.valueOf(fourchetteMontantMin);
                    String fourchetteMontantMax = tokens[1];
                    String montant = tokens[2];
                    DeductionPersonnesAgeesOuInfirmesNonMariesModelItem deductionModel = new DeductionPersonnesAgeesOuInfirmesNonMariesModelItem(fourchetteMontantMin, fourchetteMontantMax, montant);
                    myMap.put(key.toString(), deductionModel);
                }
                return myMap;
            }
        }
        ,
        DEDUCTION_PERSONNE_AGEE_MARIEE("deductionPersonneAgeeMariee"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, DeductionPersonnesAgeesOuInfirmesMariesModelItem> myMap = new LinkedHashMap<String, DeductionPersonnesAgeesOuInfirmesMariesModelItem>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(4);
                    String fourchetteMontantMin = tokens[0];
                    Long key = Long.valueOf(fourchetteMontantMin);
                    String fourchetteMontantMax = tokens[1];
                    String montantUnique = tokens[2];
                    String montantDouble = tokens[3];
                    DeductionPersonnesAgeesOuInfirmesMariesModelItem deductionModel = new DeductionPersonnesAgeesOuInfirmesMariesModelItem(fourchetteMontantMin, fourchetteMontantMax, montantUnique, montantDouble);
                    myMap.put(key.toString(), deductionModel);
                }
                return myMap;
            }
        }
        ,
        VALOR("valoren"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                ArrayList<ValorDatabaseDTO> vDTOs = new ArrayList<ValorDatabaseDTO>(100000);
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                itr.next();
                while (itr.hasNext()) {
                    vDTOs.add(this.extractDTO(itr));
                }
                Collator collator = Collator.getInstance(JuUtil.APPLICATION_LOCALE);
                Collections.sort(vDTOs, (left, right) -> collator.compare(left.getBezeichnung().toLowerCase(), right.getBezeichnung().toLowerCase()));
                LinkedHashMap<Long, ValorDatabaseDTO> valoren = new LinkedHashMap<Long, ValorDatabaseDTO>();
                for (ValorDatabaseDTO vDTO : vDTOs) {
                    boolean anwendbar = vDTO.getAnwendbar();
                    if (!anwendbar || valoren.containsKey(vDTO.getNummer())) {
                        vDTO = JuDataResourceBase.getValueLessValorDTO(vDTO, anwendbar && valoren.containsKey(vDTO.getNummer()));
                    }
                    valoren.put(vDTO.getNummer(), vDTO);
                }
                return valoren;
            }
        }
        ,
        IMPOT_ICC_FORTUNE("impotIccFortune"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, OptionItemDTO> fortuneTmp = new LinkedHashMap<String, OptionItemDTO>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String montantDeterminant = tokens[0];
                    String impotAnnuel = tokens[1];
                    String par1000CHFSupp = tokens[2];
                    String values = impotAnnuel + JuDataResourceBase.FILE_DELIMITER + par1000CHFSupp;
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)montantDeterminant, null, values, false);
                    fortuneTmp.put(montantDeterminant, optionItemDTO);
                }
                return fortuneTmp;
            }
        }
        ,
        IMPOT_ICC_SUR_REVENU_CELIBATAIRE("impotIccSurRevenuCelibataire"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, ImpotDTO> revenuTmp = new LinkedHashMap<String, ImpotDTO>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String montantDeterminant = tokens[0];
                    String impotAnnuel = tokens[1];
                    String par100CHFSupp = tokens[2];
                    ImpotDTO dto = new ImpotDTO(montantDeterminant, impotAnnuel, par100CHFSupp);
                    revenuTmp.put(montantDeterminant, dto);
                }
                return revenuTmp;
            }
        }
        ,
        IMPOT_ICC_SUR_REVENU_MARIE("impotIccSurRevenuMarie"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, ImpotDTO> revenuTmp = new LinkedHashMap<String, ImpotDTO>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String montantDeterminant = tokens[0];
                    String impotAnnuel = tokens[1];
                    String par100CHFSupp = tokens[2];
                    ImpotDTO dto = new ImpotDTO(montantDeterminant, impotAnnuel, par100CHFSupp);
                    revenuTmp.put(montantDeterminant, dto);
                }
                return revenuTmp;
            }
        }
        ,
        IMPOT_IFD_MARIE("impotIfdMarie"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                return this.readSimpleMap(reader);
            }
        }
        ,
        IMPOT_IFD_CELIBATAIRE("impotIfdCelibataire"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                return this.readSimpleMap(reader);
            }
        }
        ,
        MONNAIE("monnaie"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, OptionItemDTO> tmpMonnaie = new LinkedHashMap<String, OptionItemDTO>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(2);
                    Long key = Long.valueOf(tokens[0]);
                    String designation = tokens[1];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)key, designation, designation, false);
                    tmpMonnaie.put(key.toString(), optionItemDTO);
                }
                return tmpMonnaie;
            }
        }
        ,
        ORIGINE_TITRES("origineTitres"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, OptionItemDTO> origineTmp = new LinkedHashMap<String, OptionItemDTO>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(3);
                    String value = tokens[0];
                    String shortText = tokens[1];
                    String text = tokens[2];
                    OptionItemDTO optionItemDTO = new OptionItemDTO((Object)value, shortText, text, true);
                    origineTmp.put(value, optionItemDTO);
                }
                return origineTmp;
            }
        }
        ,
        RESOURCES_TO_PRINT("resourcesToPrint"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext("=", 2);
                    String key = tokens[0];
                    String value = tokens[1];
                    result.put(key, value);
                }
                return result;
            }
        }
        ,
        COMMUNES_NO_FEDERAUX("communesNoFederaux", "communesJU"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                LinkedHashMap<Long, Long> communesNoFederaux = new LinkedHashMap<Long, Long>();
                ResourceLineIterator itr = new ResourceLineIterator(reader);
                while (itr.hasNext()) {
                    String[] tokens = itr.splitNext(8);
                    Long key = Long.valueOf(tokens[0]);
                    Long noFederal = Long.valueOf(tokens[1]);
                    communesNoFederaux.put(key, noFederal);
                }
                return communesNoFederaux;
            }
        }
        ,
        CONFIGURATIONS("configurations"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                return this.readProperties(reader);
            }
        }
        ,
        SHORT_HELP_MAPPING("shortHelpMapping"){

            @Override
            @NonNull Map<?, ?> parse(@NonNull Reader reader) throws IOException {
                return this.readProperties(reader);
            }
        };

        private final String code;
        private final String fileCode;

        Map<?, ?> readSimpleMap(Reader reader) throws IOException {
            LinkedHashMap<String, OptionItemDTO> result = new LinkedHashMap<String, OptionItemDTO>();
            ResourceLineIterator itr = new ResourceLineIterator(reader);
            while (itr.hasNext()) {
                String[] tokens = itr.splitNext(2);
                String key = tokens[0];
                String value = tokens[1];
                result.put(key, new OptionItemDTO((Object)key, null, value, false));
            }
            return result;
        }

        Map<?, ?> readProperties(Reader reader) throws IOException {
            Properties props = new Properties();
            props.load(reader);
            return props;
        }

        ValorDatabaseDTO extractDTO(ResourceLineIterator itr) {
            ValorDatabaseDTO result = new ValorDatabaseDTO();
            String[] tokens = itr.splitNext(13);
            result.setNummer(Long.valueOf(tokens[0]));
            result.setType(Integer.valueOf(tokens[1]));
            result.setBezeichnung(tokens[2]);
            result.setSteuerwert(Double.valueOf(tokens[3]));
            result.setZins(Double.valueOf(tokens[4]));
            result.setWaehrungscode(String.valueOf(tokens[5]));
            result.setEmissionsjahr(Integer.valueOf(tokens[6]));
            result.setRueckzahlung(this.parseDate(tokens[7]));
            result.setTermin(this.parseDate(tokens[8]));
            result.setErtrag(Double.valueOf(tokens[9]));
            result.setSicavb(Boolean.valueOf(tokens[10]));
            result.setAnwendbar(Boolean.valueOf(tokens[11]));
            result.setVstUnterliegend(Boolean.valueOf(tokens[12]));
            return result;
        }

        private Date parseDate(String token) {
            if (token == null || token.isEmpty()) {
                return null;
            }
            try {
                return new SimpleDateFormat("dd.MM.yyyy").parse(token);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Malformed date: " + token, e);
            }
        }

        private ResourceEnum(String code) {
            this(code, code);
        }

        private ResourceEnum(String code, String fileCode) {
            this.code = code;
            this.fileCode = fileCode;
        }

        public static ResourceEnum forCode(String code) {
            for (ResourceEnum res : ResourceEnum.values()) {
                if (!res.code.equals(code)) continue;
                return res;
            }
            throw new IllegalArgumentException("No resource defined with code: " + code);
        }

        public String getCode() {
            return this.code;
        }

        abstract Map<?, ?> parse(Reader var1) throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @NonNull Map<?, ?> parse(@NonNull ResourceProvider resourceProvider) throws IOException {
            Reader reader = resourceProvider.getReader(this.fileCode + ".txt");
            try {
                Map<?, ?> map = this.parse(reader);
                return map;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }

        public int getIndirectionLevelCount() {
            return 0;
        }
    }
}

