/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.common.eref;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.BankAccount;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Konten;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.util.Result;
import ch.dvbern.tax.ju.JuModelConstants;
import ch.dvbern.tax.ju.presentation.common.eref.TSUtils;
import ch.dvbern.tax.ju.transfer.Category;
import ch.dvbern.tax.ju.transfer.TransferMessage;
import ch.dvbern.tax.ju.transfer.dto.KontenDTO;
import ch.dvbern.tax.ju.transfer.dto.SpesenDTO;
import ch.dvbern.tax.ju.utils.TaxStatementModelMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankAccounts {
    private static final Logger LOG = LoggerFactory.getLogger(BankAccounts.class);
    private final @NonNull Map<String, LogicModelItem> logicModel;
    private final Map<String, ModelItemDTO> dataModel;
    private final @NonNull Consumer<Map<String, ModelItemDTO>> updater;
    private long steuerJahr;

    public BankAccounts(@NonNull Map<String, LogicModelItem> logicModel, Map<String, ModelItemDTO> dataModel, @NonNull Consumer<Map<String, ModelItemDTO>> updater, long steuerJahr) {
        this.logicModel = logicModel;
        this.dataModel = dataModel;
        this.updater = updater;
        this.steuerJahr = steuerJahr;
    }

    public List<Result<TransferMessage, Optional<TransferMessage>>> transferKonten(DMK srcRow) {
        LOG.info("EREF---> beginning import bank accounts");
        DMK kontenTable = srcRow.merge(JuModelConstants.TAXSTATEMENT_BANKACCOUNT_TABLE);
        Set rowDmks = kontenTable.findRowDMKs(this.dataModel).orElse(Collections.emptySet());
        LOG.info("EREF---> bank account to be imported: " + rowDmks.size());
        List<Result<TransferMessage, Optional<TransferMessage>>> result = rowDmks.stream().map(this::transferKonto).collect(Collectors.toList());
        return result;
    }

    public void writeBankaccountsTemporaryModel(@NonNull Steuerauszug steuerauszug, LogicModelItem.ProtectedMap protectedData, @NonNull DMK taxStatementRow) {
        boolean hasKonten;
        Konten konten = steuerauszug.getKonten();
        DMK kontenDmk = taxStatementRow.append("BankAccount");
        boolean bl = hasKonten = konten != null && konten.getBankAccounts() != null;
        if (hasKonten) {
            DMK bankAccountsTableDmk = kontenDmk.append("BankAccountTable");
            LogicModelItem.TableItem bankAccountsTable = (LogicModelItem.TableItem)this.logicModel.get(JuModelConstants.TAX_STATEMENTS_BANK_ACCOUNTS.toExternalForm());
            konten.getBankAccounts().forEach(bankAccount -> {
                int bankAccountIdx = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)protectedData, (LogicModelItem.TableItem)bankAccountsTable, (String)bankAccountsTableDmk.toExternalForm());
                DMK bankAccountRow = bankAccountsTableDmk.toTableRow((long)bankAccountIdx);
                this.updater.accept(this.getBankAccountItems(bankAccountRow, (BankAccount)bankAccount).getChanges());
            });
        }
        this.updater.accept(this.getKontenItems(kontenDmk, konten).getChanges());
    }

    private TaxStatementModelMap getKontenItems(@NonNull DMK kontenDmk, @Nullable Konten konten) {
        TaxStatementModelMap newKontenItems = new TaxStatementModelMap(kontenDmk);
        newKontenItems.add("TotalTaxValue", TSUtils.extract(konten, Konten::getTotalTaxValue));
        newKontenItems.add("TotalGrossRevenueA", TSUtils.extract(konten, Konten::getTotalGrossRevenueA));
        newKontenItems.add("TotalGrossRevenueB", TSUtils.extract(konten, Konten::getTotalGrossRevenueB));
        newKontenItems.add("TotalWithHoldingTaxClaim", TSUtils.extract(konten, Konten::getTotalWithHoldingTaxClaim));
        return newKontenItems;
    }

    private TaxStatementModelMap getBankAccountItems(DMK bankAccountRow, BankAccount bankAccount) {
        TaxStatementModelMap newBankAccountItems = new TaxStatementModelMap(bankAccountRow);
        newBankAccountItems.add("Iban", bankAccount.getIban());
        newBankAccountItems.add("BankAccountNr", bankAccount.getBankAccountNumber());
        newBankAccountItems.add("BankAccountName", bankAccount.getBankAccountName());
        newBankAccountItems.add("BankAccountCountry", bankAccount.getBankAccountCountry());
        newBankAccountItems.add("BankAccountCurrency", bankAccount.getBankAccountCurrency());
        newBankAccountItems.add("OpeningDate", bankAccount.getOpeningDate());
        newBankAccountItems.add("ClosingDate", bankAccount.getClosingDate());
        newBankAccountItems.add("TotalTaxValue", bankAccount.getTotalTaxValue());
        newBankAccountItems.add("TotalGrossRevenueA", bankAccount.getTotalGrossRevenueA());
        newBankAccountItems.add("TotalGrossRevenueB", bankAccount.getTotalGrossRevenueB());
        newBankAccountItems.add("TotalWithHoldingTaxClaim", bankAccount.getTotalWithHoldingTaxClaim());
        newBankAccountItems.add("ReferenceDate", bankAccount.getReferenceDate());
        newBankAccountItems.add("Name", bankAccount.getName());
        newBankAccountItems.add("BalanceCurrency", bankAccount.getBalanceCurrency());
        newBankAccountItems.add("Balance", bankAccount.getBalance());
        newBankAccountItems.add("ExchangeRate", bankAccount.getExchangeRate());
        newBankAccountItems.add("Value", bankAccount.getValue());
        return newBankAccountItems;
    }

    private @NonNull Result<TransferMessage, Optional<TransferMessage>> transferKonto(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        LMK givenIdentifier = JuModelConstants.WERTSCHRIFTEN_KONTI_DMK.append("Kontonummer").toLMK();
        String iban = TSUtils.asString(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_BANKACCOUNT_TABLE.append("Iban"), srcRow));
        Pair<DMK, String> duplicateEntry = TSUtils.getDuplicateEntry(this.logicModel, this.dataModel, JuModelConstants.WERTSCHRIFTEN_KONTI_DMK, givenIdentifier, iban);
        return TSUtils.handleTransferIfNeeded(this.dataModel, duplicateEntry, srcRow, Category.KONTEN, this::buildKontenDTO, this::writeKontoToStek);
    }

    private @NonNull Result<TransferMessage, KontenDTO> buildKontenDTO(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        LMK kontenTableLmk = LMK.parse((String)"TaxStatement.TaxStatementTable.BankAccount.BankAccountTable");
        DMK kontenTableDmk = srcRow.merge(kontenTableLmk);
        LMK ibanLmk = kontenTableDmk.append("Iban").toLMK();
        LMK waehrungLmk = kontenTableDmk.append("BankAccountCurrency").toLMK();
        LMK kursLmk = kontenTableDmk.append("ExchangeRate").toLMK();
        LMK eroeffnungLmk = kontenTableDmk.append("OpeningDate").toLMK();
        LMK aufloesungLmk = kontenTableDmk.append("ClosingDate").toLMK();
        LMK grossRevenueALmk = kontenTableDmk.append("TotalGrossRevenueA").toLMK();
        LMK grossRevenueBLmk = kontenTableDmk.append("TotalGrossRevenueB").toLMK();
        LMK balanceLmk = kontenTableDmk.append("Balance").toLMK();
        LMK valueLmk = kontenTableDmk.append("Value").toLMK();
        LMK organisationNameLmk = kontenTableDmk.append("OrganisationName").toLMK();
        LMK firstClientNumberLmk = kontenTableDmk.append("FirstClientNumber").toLMK();
        String eStAId = Objects.requireNonNull((String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_TABLE_ID, srcRow));
        Double grossRevenueA = TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, grossRevenueALmk, srcRow));
        Double grossRevenueB = TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, grossRevenueBLmk, srcRow));
        boolean vstPflichtig = TSUtils.hasGrossRevenueA(grossRevenueA);
        Double ertrag = vstPflichtig ? grossRevenueA : grossRevenueB;
        List<SpesenDTO> spesenDTOs = this.getSpesen(Objects.requireNonNull(srcRow.findOutermostTableRowDMK()));
        Double kostenKonto = null;
        KontenDTO konto = new KontenDTO(eStAId, (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, ibanLmk, srcRow), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_TABLE_ORGANISATION_NAME, srcRow), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, waehrungLmk, srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, kursLmk, srcRow)), (Date)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, eroeffnungLmk, srcRow), (Date)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aufloesungLmk, srcRow), vstPflichtig, ertrag, kostenKonto, TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, balanceLmk, srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, valueLmk, srcRow)), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, organisationNameLmk, srcRow), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, firstClientNumberLmk, srcRow));
        konto.setKostenKonto(this.getKostenKonto(spesenDTOs, konto));
        return Result.ok((Object)konto);
    }

    private void writeKontoToStek(@NonNull KontenDTO konto, @Nullable DMK existingRow) {
        GregorianCalendar cal;
        Objects.requireNonNull(konto);
        TSUtils.enableToplevelCheckbox(this.logicModel, this.dataModel, this.updater, LMK.parse((String)"Wertschriften.Selektion.CheckKonti"));
        DMK kontoRow = TSUtils.createNewRowIfNotExisting(this.logicModel, this.dataModel, JuModelConstants.WERTSCHRIFTEN_KONTI_DMK, existingRow);
        TaxStatementModelMap kontoItems = new TaxStatementModelMap(kontoRow);
        if (konto.getDatumAufloesung() != null) {
            cal = new GregorianCalendar();
            cal.setTime(konto.getDatumAufloesung());
            int yearAufloesung = cal.get(1);
            if ((long)yearAufloesung < this.steuerJahr) {
                return;
            }
            kontoItems.add("DatumAufloesung", (long)yearAufloesung == this.steuerJahr ? konto.getDatumAufloesung() : null);
        } else {
            kontoItems.add("DatumAufloesung", null);
        }
        if (konto.getDatumEroeffnung() != null) {
            cal = new GregorianCalendar();
            cal.setTime(konto.getDatumEroeffnung());
            int yearEroeffnung = cal.get(1);
            if ((long)yearEroeffnung == this.steuerJahr) {
                kontoItems.add("DatumEroeffnung", konto.getDatumEroeffnung());
            } else {
                kontoItems.add("DatumEroeffnung", null);
            }
        } else {
            kontoItems.add("DatumEroeffnung", null);
        }
        kontoItems.add("ESteuerauszugId", konto.getEStAId());
        kontoItems.add("Kontonummer", konto.getIban());
        kontoItems.add("Bankname", konto.getBank());
        kontoItems.add("Herkunft", konto.getHerkunft());
        if (konto.getWaehrung() != null) {
            Long waehrungsCode = TSUtils.getCurrencyCode(konto.getWaehrung());
            if (waehrungsCode == null) {
                waehrungsCode = TSUtils.getCurrencyOther();
            }
            kontoItems.add("Waehrung", waehrungsCode);
        }
        kontoItems.add("Waehrungskurs", konto.getWaehrungskurs());
        this.updater.accept(kontoItems.getChanges());
        TaxStatementModelMap kontoTotalen = new TaxStatementModelMap(kontoRow);
        kontoTotalen.add("VSTPflichtig", konto.getVstPflichtig());
        kontoTotalen.add("TotalErtragFW", null);
        kontoTotalen.add("TotalErtrag", TSUtils.asLong(konto.getErtrag()));
        kontoTotalen.add("TotalSteuerwertFW", TSUtils.asLong(konto.getSteuerwertFW()));
        kontoTotalen.add("TotalSteuerwert", TSUtils.asLong(konto.getSteuerwertCHF()));
        kontoTotalen.add("KostenKonto", TSUtils.asLong(konto.getKostenKonto()));
        this.updater.accept(kontoTotalen.getChanges());
    }

    private Double getKostenKonto(List<SpesenDTO> spesenDTOs, KontenDTO konto) {
        return spesenDTOs.stream().filter(spese -> Objects.equals(spese.getIban(), konto.getIban())).filter(spese -> spese.getExpenses() != null).mapToDouble(SpesenDTO::getExpenses).sum();
    }

    private List<SpesenDTO> getSpesen(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        ArrayList<SpesenDTO> spesenDTOs = new ArrayList<SpesenDTO>();
        LMK spesenTableLMK = LMK.parse((String)"TaxStatement.TaxStatementTable.Spesen.Expenses");
        DMK spesenTableDMK = srcRow.merge(spesenTableLMK);
        LMK expensesDMK = spesenTableDMK.append("Expenses").toLMK();
        LMK ibanDMK = spesenTableDMK.append("Iban").toLMK();
        Set spesenRowDMKs = spesenTableDMK.findRowDMKs(this.dataModel).orElse(Collections.emptySet());
        for (DMK rowDmk : spesenRowDMKs) {
            Double gebuehrenWertschriften = null;
            Double expensesDecuctible = null;
            spesenDTOs.add(new SpesenDTO(gebuehrenWertschriften, expensesDecuctible, TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, expensesDMK, rowDmk)), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, ibanDMK, rowDmk)));
        }
        return spesenDTOs;
    }
}

