/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.common.eref;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Client;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.ju.JuModelConstants;
import ch.dvbern.tax.ju.utils.TaxStatementModelMap;
import java.util.Map;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clients {
    private static final Logger LOG = LoggerFactory.getLogger(Clients.class);
    private final @NonNull Map<String, LogicModelItem> logicModel;
    private final Map<String, ModelItemDTO> dataModel;
    private final @NonNull Consumer<Map<String, ModelItemDTO>> updater;

    public Clients(@NonNull Map<String, LogicModelItem> logicModel, Map<String, ModelItemDTO> dataModel, @NonNull Consumer<Map<String, ModelItemDTO>> updater) {
        this.logicModel = logicModel;
        this.dataModel = dataModel;
        this.updater = updater;
    }

    public void writeClientsTemporaryModel(@NonNull Steuerauszug steuerauszug, LogicModelItem.ProtectedMap protectedData, @NonNull DMK taxStatementRow) {
        if (steuerauszug.getClients() != null) {
            DMK clientsTableDmk = taxStatementRow.append("Clients");
            LogicModelItem.TableItem clientsTable = (LogicModelItem.TableItem)this.logicModel.get(JuModelConstants.TAX_STATEMENTS_CLIENTS.toExternalForm());
            steuerauszug.getClients().forEach(client -> {
                int clientIdx = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)protectedData, (LogicModelItem.TableItem)clientsTable, (String)clientsTableDmk.toExternalForm());
                DMK clientRow = clientsTableDmk.toTableRow((long)clientIdx);
                this.updater.accept(this.getClientItems(clientRow, (Client)client).getChanges());
            });
        }
    }

    private TaxStatementModelMap getClientItems(DMK clientRow, Client client) {
        TaxStatementModelMap newClientItems = new TaxStatementModelMap(clientRow);
        newClientItems.add("ClientNumber", client.getClientNumber());
        newClientItems.add("Tin", client.getTin());
        newClientItems.add("Salutation", client.getSalutation());
        newClientItems.add("FirstName", client.getFirstName());
        newClientItems.add("LastName", client.getLastName());
        return newClientItems;
    }
}

