/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.common.eref;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Expense;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Spesen;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.util.Result;
import ch.dvbern.tax.ju.JuModelConstants;
import ch.dvbern.tax.ju.presentation.common.eref.TSUtils;
import ch.dvbern.tax.ju.transfer.Category;
import ch.dvbern.tax.ju.transfer.TransferMessage;
import ch.dvbern.tax.ju.transfer.dto.SpesenDTO;
import ch.dvbern.tax.ju.utils.TaxStatementModelMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expenses {
    private static final Logger LOG = LoggerFactory.getLogger(Expenses.class);
    private final @NonNull Map<String, LogicModelItem> logicModel;
    private final Map<String, ModelItemDTO> dataModel;
    private final @NonNull Consumer<Map<String, ModelItemDTO>> updater;

    public Expenses(@NonNull Map<String, LogicModelItem> logicModel, Map<String, ModelItemDTO> dataModel, @NonNull Consumer<Map<String, ModelItemDTO>> updater) {
        this.logicModel = logicModel;
        this.dataModel = dataModel;
        this.updater = updater;
    }

    public void writeExpensesTemporaryModel(@NonNull Steuerauszug steuerauszug, LogicModelItem.ProtectedMap protectedData, @NonNull DMK taxStatementRow) {
        boolean hasSpesen;
        Spesen spesen = steuerauszug.getSpesen();
        DMK spesenDmk = taxStatementRow.append("Spesen");
        boolean bl = hasSpesen = spesen != null && spesen.getExpenses() != null;
        if (hasSpesen) {
            DMK expensesTableDmk = spesenDmk.append("Expenses");
            LogicModelItem.TableItem expensesTable = (LogicModelItem.TableItem)this.logicModel.get(JuModelConstants.TAX_STATEMENTS_EXPENSES.toExternalForm());
            spesen.getExpenses().forEach(expense -> {
                int expenseIdx = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)protectedData, (LogicModelItem.TableItem)expensesTable, (String)expensesTableDmk.toExternalForm());
                DMK expenseRow = expensesTableDmk.toTableRow((long)expenseIdx);
                this.updater.accept(this.getExpenseItems(expenseRow, (Expense)expense).getChanges());
            });
        }
        this.updater.accept(this.getSpesenItems(spesenDmk, spesen).getChanges());
    }

    public List<Result<TransferMessage, Optional<TransferMessage>>> transferExpenses(DMK srcRow) {
        LOG.info("EREF---> beginning import Expenses");
        DMK aktienTable = srcRow.merge(JuModelConstants.TAXSTATEMENT_TABLE_EXPENSES);
        Set rowDmks = aktienTable.findRowDMKs(this.dataModel).orElse(Collections.emptySet());
        LOG.info("EREF---> Expenses to be imported: " + rowDmks.size());
        if (rowDmks.size() > 0) {
            TSUtils.enableToplevelCheckbox(this.logicModel, this.dataModel, this.updater, LMK.parse((String)"Wertschriften.Selektion.CheckAbzuege"));
        }
        List<Result<TransferMessage, Optional<TransferMessage>>> result = rowDmks.stream().map(this::transferExpense).collect(Collectors.toList());
        return result;
    }

    private @NonNull Result<TransferMessage, Optional<TransferMessage>> transferExpense(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        LMK givenIdentifier = JuModelConstants.TAX_STATEMENTS_EXPENSES.append("ValorenNr").toLMK();
        String valorNumber = TSUtils.asString(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_TABLE_SECURITY.append("ValorNumber"), srcRow));
        Pair<DMK, String> duplicateEntry = TSUtils.getDuplicateEntry(this.logicModel, this.dataModel, JuModelConstants.TAX_STATEMENTS_EXPENSES, givenIdentifier, valorNumber);
        return TSUtils.handleTransferIfNeeded(this.dataModel, duplicateEntry, srcRow, Category.WERTSCHRIFTEN, this::buildExpensesDTO, this::writeExpensesToStek);
    }

    private @NonNull Result<TransferMessage, SpesenDTO> buildExpensesDTO(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        LMK spesenTableLmk = LMK.parse((String)"TaxStatement.TaxStatementTable.Spesen.Expenses");
        DMK spesenTableDmk = srcRow.merge(spesenTableLmk);
        String eStAId = Objects.requireNonNull((String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_TABLE_ID, srcRow));
        SpesenDTO spesen = new SpesenDTO(eStAId, 0.0, TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, spesenTableDmk.append("ExpensesDeductible").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, spesenTableDmk.append("Expenses").toLMK(), srcRow)), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, spesenTableDmk.append("Iban").toLMK(), srcRow), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, spesenTableDmk.append("Name").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, spesenTableDmk.append("Amount").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, spesenTableDmk.append("UebrigeExpenses").toLMK(), srcRow)), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, spesenTableDmk.append("DepotNumber").toLMK(), srcRow));
        return Result.ok((Object)spesen);
    }

    private void writeExpensesToStek(@NonNull SpesenDTO spesen, @Nullable DMK existingRow) {
        Objects.requireNonNull(spesen);
        DMK spesenRow = TSUtils.createNewRowIfNotExisting(this.logicModel, this.dataModel, JuModelConstants.WERTSCHRIFTEN_ABZUEGE, existingRow);
        TaxStatementModelMap spesenItems = new TaxStatementModelMap(spesenRow);
        spesenItems.add("Name", spesen.getName());
        spesenItems.add("Iban", spesen.getIban());
        spesenItems.add("Amount", spesen.getExpenses());
        spesenItems.add("ESteuerauszugId", spesen.geteStAId());
        spesenItems.add("ValorenNr", spesen.getName().replaceAll("\\s+", ""));
        this.updater.accept(spesenItems.getChanges());
    }

    private TaxStatementModelMap getExpenseItems(DMK expenseRow, Expense expense) {
        TaxStatementModelMap newExpenseItems = new TaxStatementModelMap(expenseRow);
        newExpenseItems.add("ReferenceDate", expense.getReferenceDate());
        newExpenseItems.add("Name", expense.getName());
        newExpenseItems.add("Iban", expense.getIban());
        newExpenseItems.add("BankAccountNumber", expense.getBankAccountNumber());
        newExpenseItems.add("DepotNumber", expense.getDepotNumber());
        newExpenseItems.add("AmountCurrency", expense.getAmountCurrency());
        newExpenseItems.add("Amount", expense.getAmount());
        newExpenseItems.add("ExchangeRate", expense.getExchangeRate());
        newExpenseItems.add("Expenses", expense.getExpenses());
        newExpenseItems.add("ExpensesDeductible", expense.getExpensesDeductible());
        newExpenseItems.add("ExpensesDeducitbleCanton", expense.getExpensesDeductibleCanton());
        return newExpenseItems;
    }

    private TaxStatementModelMap getSpesenItems(@NonNull DMK spesenDmk, @Nullable Spesen spesen) {
        TaxStatementModelMap newSpesenItems = new TaxStatementModelMap(spesenDmk);
        newSpesenItems.add("TotalExpenses", TSUtils.extract(spesen, Spesen::getTotalExpenses));
        newSpesenItems.add("TotalExpensesDeductible", TSUtils.extract(spesen, Spesen::getTotalExpensesDeductible));
        newSpesenItems.add("TotalExpensesDeductibleCanton", TSUtils.extract(spesen, Spesen::getTotalExpensesDeductibleCanton));
        return newSpesenItems;
    }
}

