/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.common.eref;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.LiabilityAccount;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Schulden;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.util.Result;
import ch.dvbern.tax.ju.JuModelConstants;
import ch.dvbern.tax.ju.presentation.common.eref.TSUtils;
import ch.dvbern.tax.ju.transfer.Category;
import ch.dvbern.tax.ju.transfer.TransferMessage;
import ch.dvbern.tax.ju.transfer.dto.SchuldenDTO;
import ch.dvbern.tax.ju.utils.TaxStatementModelMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiabilityAccounts {
    public static final String LIABILITY_ACCOUNTS_TABLE_DMK_SUFFIX = "LiabilityAccountsTable";
    public static final String LIABILITY_ACCOUNTS_DMK_SUFFIX = "LiabilityAccounts";
    private static final Logger LOG = LoggerFactory.getLogger(LiabilityAccounts.class);
    private final @NonNull Map<String, LogicModelItem> logicModel;
    private final Map<String, ModelItemDTO> dataModel;
    private final @NonNull Consumer<Map<String, ModelItemDTO>> updater;

    public LiabilityAccounts(@NonNull Map<String, LogicModelItem> logicModel, Map<String, ModelItemDTO> dataModel, @NonNull Consumer<Map<String, ModelItemDTO>> updater) {
        this.logicModel = logicModel;
        this.dataModel = dataModel;
        this.updater = updater;
    }

    public void writeLiabilityaccountsTemporaryModel(@NonNull Steuerauszug steuerauszug, LogicModelItem.ProtectedMap protectedData, @NonNull DMK taxStatementRow) {
        boolean hasLiabilityAccounts;
        Schulden schulden = steuerauszug.getSchulden();
        DMK schuldenDmk = taxStatementRow.append(LIABILITY_ACCOUNTS_DMK_SUFFIX);
        boolean bl = hasLiabilityAccounts = schulden != null && schulden.getLiabilityAccounts() != null;
        if (hasLiabilityAccounts) {
            DMK liabilityAccountsTableDmk = schuldenDmk.append(LIABILITY_ACCOUNTS_TABLE_DMK_SUFFIX);
            LogicModelItem.TableItem liabilityAccountsTable = (LogicModelItem.TableItem)this.logicModel.get(JuModelConstants.TAX_STATEMENTS_LIABILITY_ACCOUNTS.toExternalForm());
            schulden.getLiabilityAccounts().forEach(liabilityAccount -> {
                int liabilityAccountIdx = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)protectedData, (LogicModelItem.TableItem)liabilityAccountsTable, (String)liabilityAccountsTableDmk.toExternalForm());
                DMK liabilityAccountRow = liabilityAccountsTableDmk.toTableRow((long)liabilityAccountIdx);
                this.updater.accept(this.mapLiabilityAccountsTemporaryModel(liabilityAccountRow, (LiabilityAccount)liabilityAccount).getChanges());
            });
        }
        this.updater.accept(new TaxStatementModelMap(taxStatementRow).add("HasLiabiltyAccounts", hasLiabilityAccounts).getChanges());
        this.updater.accept(this.mapLiabilityAccountsTotal(schuldenDmk, schulden).getChanges());
    }

    private TaxStatementModelMap mapLiabilityAccountsTemporaryModel(@NonNull DMK liabilityAccountRow, LiabilityAccount liabilityAccount) {
        TaxStatementModelMap newLiabilityAccountItems = new TaxStatementModelMap(liabilityAccountRow);
        newLiabilityAccountItems.add("Iban", liabilityAccount.getIban());
        newLiabilityAccountItems.add("BankAccountNr", liabilityAccount.getBankAccountNumber());
        newLiabilityAccountItems.add("BankAccountName", liabilityAccount.getBankAccountName());
        newLiabilityAccountItems.add("BankAccountCountry", liabilityAccount.getBankAccountCountry());
        newLiabilityAccountItems.add("BankAccountCurrency", liabilityAccount.getBankAccountCurrency());
        newLiabilityAccountItems.add("OpeningDate", liabilityAccount.getOpeningDate());
        newLiabilityAccountItems.add("ClosingDate", liabilityAccount.getClosingDate());
        newLiabilityAccountItems.add("TotalTaxValue", liabilityAccount.getTotalTaxValue());
        newLiabilityAccountItems.add("TotalGrossRevenueB", liabilityAccount.getTotalGrossRevenueB());
        newLiabilityAccountItems.add("ReferenceDate", liabilityAccount.getReferenceDate());
        newLiabilityAccountItems.add("Name", liabilityAccount.getName());
        newLiabilityAccountItems.add("BalanceCurrency", liabilityAccount.getBalanceCurrency());
        newLiabilityAccountItems.add("Balance", liabilityAccount.getBalance());
        newLiabilityAccountItems.add("ExchangeRate", liabilityAccount.getExchangeRate());
        newLiabilityAccountItems.add("Value", liabilityAccount.getValue());
        return newLiabilityAccountItems;
    }

    private TaxStatementModelMap mapLiabilityAccountsTotal(@NonNull DMK schuldenDmk, @Nullable Schulden schulden) {
        TaxStatementModelMap newSchuldenItems = new TaxStatementModelMap(schuldenDmk);
        newSchuldenItems.add("TotalTaxValue", TSUtils.extract(schulden, Schulden::getTotalTaxValue));
        newSchuldenItems.add("TotalGrossRevenueB", TSUtils.extract(schulden, Schulden::getTotalGrossRevenueB));
        return newSchuldenItems;
    }

    public List<Result<TransferMessage, Optional<TransferMessage>>> transferLiabilityAccountsrealModel(DMK srcRow) {
        LOG.info("EREF---> beginning import DEBTS");
        DMK kontenTable = srcRow.merge(JuModelConstants.TEMP_MODEL_LIABILITYACCOUNTS_TABLE);
        Set tmpMpdeelLiabilityAccountRows = kontenTable.findRowDMKs(this.dataModel).orElse(Collections.emptySet());
        LOG.info("EREF---> DEBTS to be imported: " + tmpMpdeelLiabilityAccountRows.size());
        List<Result<TransferMessage, Optional<TransferMessage>>> result = tmpMpdeelLiabilityAccountRows.stream().map(this::transferLiabilityAccount).collect(Collectors.toList());
        return result;
    }

    public @NonNull Result<TransferMessage, Optional<TransferMessage>> transferLiabilityAccount(@NonNull DMK tmpModelLiabilityAccountRow) {
        Objects.requireNonNull(tmpModelLiabilityAccountRow);
        return TSUtils.handleTransferIfNeeded(this.dataModel, (Pair<DMK, String>)Pair.of(null, null), tmpModelLiabilityAccountRow, Category.SCHULDEN, this::buildSchuldenDTO, this::writeHypothequeRealModel);
    }

    private @NonNull Result<TransferMessage, SchuldenDTO> buildSchuldenDTO(@NonNull DMK tmpModelLiabilityAccountRow) {
        LMK ESTEUERAUSZUG_TAXSTATEMENT_ID = LMK.parse((String)"TaxStatement.TaxStatementTable.Id");
        LMK ESTEUERAUSZUG_SCHULDEN_NAME = LMK.parse((String)"TaxStatement.TaxStatementTable.LiabilityAccounts.LiabilityAccountsTable.BankAccountName");
        LMK ESTEUERAUSZUG_SCHULDEN_KONTONR = LMK.parse((String)"TaxStatement.TaxStatementTable.LiabilityAccounts.LiabilityAccountsTable.Iban");
        LMK ESTEUERAUSZUG_SCHULDEN_BETRAG = LMK.parse((String)"TaxStatement.TaxStatementTable.LiabilityAccounts.LiabilityAccountsTable.TotalTaxValue");
        LMK ESTEUERAUSZUG_SCHULDEN_ZINSEN = LMK.parse((String)"TaxStatement.TaxStatementTable.LiabilityAccounts.LiabilityAccountsTable.TotalGrossRevenueB");
        LMK ESTEUERAUSZUG_SCHULDEN_ZINSFUSS = LMK.parse((String)"TaxStatement.TaxStatementTable.LiabilityAccounts.LiabilityAccountsTable.ExchangeRate");
        return Result.ok((Object)new SchuldenDTO((String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, ESTEUERAUSZUG_TAXSTATEMENT_ID, tmpModelLiabilityAccountRow), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, ESTEUERAUSZUG_SCHULDEN_KONTONR, tmpModelLiabilityAccountRow), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, ESTEUERAUSZUG_SCHULDEN_NAME, tmpModelLiabilityAccountRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, ESTEUERAUSZUG_SCHULDEN_BETRAG, tmpModelLiabilityAccountRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, ESTEUERAUSZUG_SCHULDEN_ZINSEN, tmpModelLiabilityAccountRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, ESTEUERAUSZUG_SCHULDEN_ZINSFUSS, tmpModelLiabilityAccountRow))));
    }

    private void writeHypothequeRealModel(@NonNull SchuldenDTO liabilityAccountDTO, DMK tmpModelLiabilityAccountRow) {
        DMK newLiabilityAccountRow;
        Objects.requireNonNull(liabilityAccountDTO);
        String liabilityAccountDescription = String.valueOf(liabilityAccountDTO.getBezeichnung()).toLowerCase();
        if (liabilityAccountDescription.contains("hypo")) {
            TSUtils.enableToplevelCheckbox(this.logicModel, this.dataModel, this.updater, JuModelConstants.REAL_MODEL_DETTES_HYPOTECAIRE_CHECKBOX);
            newLiabilityAccountRow = TSUtils.createNewRowIfNotExisting(this.logicModel, this.dataModel, JuModelConstants.REAL_MODEL_DETTES_HYPOTECAIRE_TABLE, tmpModelLiabilityAccountRow);
        } else {
            TSUtils.enableToplevelCheckbox(this.logicModel, this.dataModel, this.updater, JuModelConstants.REAL_MODEL_DETTES_AUTRES_CHECKBOX);
            newLiabilityAccountRow = TSUtils.createNewRowIfNotExisting(this.logicModel, this.dataModel, JuModelConstants.REAL_MODEL_DETTES_AUTRES_TABLE, tmpModelLiabilityAccountRow);
        }
        TaxStatementModelMap schuldenItems = new TaxStatementModelMap(newLiabilityAccountRow);
        schuldenItems.add("ESteuerauszugId", liabilityAccountDTO.getEStaId());
        schuldenItems.add("Glaeubiger", liabilityAccountDTO.getBezeichnung());
        schuldenItems.add("Kontonummer", liabilityAccountDTO.getKontoNR());
        schuldenItems.add("Betrag", liabilityAccountDTO.getSchuldbetrag());
        schuldenItems.add("Zins", liabilityAccountDTO.getZinsen());
        this.updater.accept(schuldenItems.getChanges());
    }
}

