/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ju.presentation.common.eref;

import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Payment;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.PurchaseDisposition;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Security;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Steuerauszug;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Stock;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.TaxValue;
import ch.dvbern.dvbtax.esteuerauszugextractor.dto.Wertschriften;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.util.Result;
import ch.dvbern.tax.ju.JuModelConstants;
import ch.dvbern.tax.ju.presentation.common.eref.TSUtils;
import ch.dvbern.tax.ju.transfer.Category;
import ch.dvbern.tax.ju.transfer.TransferMessage;
import ch.dvbern.tax.ju.transfer.dto.AktienDTO;
import ch.dvbern.tax.ju.transfer.dto.DiverseDTO;
import ch.dvbern.tax.ju.transfer.dto.ObligationenDTO;
import ch.dvbern.tax.ju.utils.TaxStatementModelMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Securities {
    private static final Logger LOG = LoggerFactory.getLogger(Securities.class);
    private static final Double ZEROD = 0.0;
    private final @NonNull Map<String, LogicModelItem> logicModel;
    private final Map<String, ModelItemDTO> dataModel;
    private final @NonNull Consumer<Map<String, ModelItemDTO>> updater;

    public Securities(@NonNull Map<String, LogicModelItem> logicModel, Map<String, ModelItemDTO> dataModel, @NonNull Consumer<Map<String, ModelItemDTO>> updater) {
        this.logicModel = logicModel;
        this.dataModel = dataModel;
        this.updater = updater;
    }

    public void writeSecuritiesTemporaryModel(@NonNull Steuerauszug steuerauszug, LogicModelItem.ProtectedMap protectedData, @NonNull DMK taxStatementRow) {
        boolean hasWertschriften;
        Wertschriften wertschriften = steuerauszug.getWertschriften();
        DMK wertschriftenDmk = taxStatementRow.append("Wertschriften");
        boolean bl = hasWertschriften = wertschriften != null && wertschriften.getSecurities() != null;
        if (hasWertschriften) {
            DMK securitiesTableDmk = wertschriftenDmk.append("Securities");
            LogicModelItem.TableItem securitiesTable = (LogicModelItem.TableItem)this.logicModel.get(JuModelConstants.TAX_STATEMENTS_SECURITIES.toExternalForm());
            wertschriften.getSecurities().forEach(security -> {
                int securityIdx = EngineUtil.getNextTableItemIndex((LogicModelItem.ProtectedMap)protectedData, (LogicModelItem.TableItem)securitiesTable, (String)securitiesTableDmk.toExternalForm());
                DMK securityRow = securitiesTableDmk.toTableRow((long)securityIdx);
                this.updater.accept(this.getSecurityItems(securityRow, (Security)security).getChanges());
            });
        }
        this.updater.accept(this.getWertschriftenItems(wertschriftenDmk, wertschriften).getChanges());
    }

    public List<Result<TransferMessage, Optional<TransferMessage>>> transferSecurities(DMK srcRow) {
        LOG.info("EREF---> beginning import Securities");
        DMK aktienTable = srcRow.merge(JuModelConstants.TAXSTATEMENT_TABLE_SECURITY);
        Set rowDmks = aktienTable.findRowDMKs(this.dataModel).orElse(Collections.emptySet());
        LOG.info("EREF---> Securities to be imported: " + rowDmks.size());
        List<Result<TransferMessage, Optional<TransferMessage>>> result = rowDmks.stream().map(this::transferSecurity).collect(Collectors.toList());
        return result;
    }

    private TaxStatementModelMap getSecurityItems(@NonNull DMK securityRow, @NonNull Security security) {
        TaxStatementModelMap newSecurityItems = new TaxStatementModelMap(securityRow);
        newSecurityItems.add("DepotNr", security.getDepotNumber());
        newSecurityItems.add("PositionId", TSUtils.castInt(security.getPositionId()));
        newSecurityItems.add("ValorNumber", security.getValorNumber());
        newSecurityItems.add("Isin", security.getIsin());
        newSecurityItems.add("Country", security.getCountry());
        newSecurityItems.add("City", security.getCity());
        newSecurityItems.add("Currency", security.getCurrency());
        newSecurityItems.add("QuotationType", TSUtils.castString(security.getQuotationType()));
        newSecurityItems.add("NominalValue", security.getNominalValue());
        newSecurityItems.add("SecurityCategory", TSUtils.castString(security.getSecurityCategory()));
        newSecurityItems.add("SecurityType", TSUtils.castString(security.getSecurityType()));
        newSecurityItems.add("SecurityName", security.getSecurityName());
        newSecurityItems.add("IssueDate", security.getIssueDate());
        newSecurityItems.add("RedemptionDate", security.getRedemptionDate());
        newSecurityItems.add("RedemptionDateEarly", security.getRedemptionDateEarly());
        newSecurityItems.add("IssuePrice", security.getIssuePrice());
        newSecurityItems.add("RedemptionPrice", security.getRedemptionPrice());
        newSecurityItems.add("RedemptionPriceEarly", security.getRedemptionPriceEarly());
        newSecurityItems.add("InterestRate", security.getInterestRate());
        newSecurityItems.add("VariableInterest", security.getVariableInterest());
        newSecurityItems.add("Iup", security.getIup());
        newSecurityItems.add("Bfb", security.getBfp());
        TaxValue taxValue = security.getTaxValue();
        if (taxValue != null) {
            newSecurityItems.add("TaxValueReferenceDate", taxValue.getReferenceDate());
            newSecurityItems.add("TaxValueName", taxValue.getName());
            newSecurityItems.add("TaxValueQuotationType", TSUtils.castString(taxValue.getQuotationType()));
            newSecurityItems.add("TaxValueQuantity", taxValue.getQuantity());
            newSecurityItems.add("TaxValueBalanceCurrency", taxValue.getBalanceCurrency());
            newSecurityItems.add("TaxValueUnitPrice", taxValue.getUnitPrice());
            newSecurityItems.add("TaxValueBalance", taxValue.getBalance());
            newSecurityItems.add("TaxValueExchangeRate", taxValue.getExchangeRate());
            newSecurityItems.add("TaxValueValue", taxValue.getValue());
            newSecurityItems.add("TaxValueBlocked", taxValue.getBlocked());
            newSecurityItems.add("TaxValueBlockingTo", taxValue.getBlockingTo());
            newSecurityItems.add("TaxValueUndefined", taxValue.getUndefined());
            newSecurityItems.add("TaxValueKursliste", taxValue.getKursliste());
        }
        BigDecimal sumAmount = this.sumErtragFW(security);
        newSecurityItems.add("PaymentAmount", sumAmount);
        BigDecimal sumGrossRevenueA = this.sumErtragCHF(security, true);
        newSecurityItems.add("PaymentGrossRevenueA", sumGrossRevenueA);
        BigDecimal sumGrossRevenueB = this.sumErtragCHF(security, false);
        newSecurityItems.add("PaymentGrossRevenueB", sumGrossRevenueB);
        newSecurityItems.add("lumpSumTaxCredit", this.isLumpSumTaxCredit(security));
        newSecurityItems.add("nonRecoverableTaxPercent", this.getNonRecoverableTaxPercent(security));
        newSecurityItems.add("nonRecoverableTaxAmount", this.sumNonRecoverableTaxAmaount(security));
        newSecurityItems.add("additionalWithHoldingTaxUSA", this.sumAdditionalWithHoldingTaxUSA(security));
        Payment lastPayment = this.getLastPayment(security.getPayments());
        BigDecimal lastXChangeRate = null;
        if (lastPayment != null) {
            lastXChangeRate = TSUtils.coalesce(lastPayment.getExchangeRate(), TSUtils.extract(lastPayment.getDisposition(), PurchaseDisposition::getExchangeRate));
        }
        Stock lastSale = this.getLastSale(security.getStocks());
        Date lastSaleDate = null;
        if (lastSale != null) {
            lastSaleDate = lastSale.getReferenceDate();
        }
        newSecurityItems.add("PaymentAmountCurrency", TSUtils.extract(lastPayment, Payment::getAmountCurrency));
        newSecurityItems.add("PaymentDate", TSUtils.extract(lastPayment, Payment::getPaymentDate));
        newSecurityItems.add("PaymentExchangeRate", lastXChangeRate);
        newSecurityItems.add("PaymentQuantity", TSUtils.extract(lastPayment, Payment::getQuantity));
        newSecurityItems.add("StockSaleDate", lastSaleDate);
        return newSecurityItems;
    }

    private @Nullable Payment getLastPayment(@Nullable List<Payment> payments) {
        if (payments == null || payments.isEmpty()) {
            return null;
        }
        Payment lastPayment = payments.stream().filter(payment -> payment.getPaymentDate() != null).max(Comparator.comparing(Payment::getPaymentDate)).orElse(null);
        return lastPayment;
    }

    private @Nullable Stock getLastSale(@Nullable List<Stock> stocks) {
        if (stocks == null || stocks.isEmpty()) {
            return null;
        }
        Stock lastSale = stocks.stream().filter(stock -> stock.getReferenceDate() != null).filter(stock -> stock.getQuantity() != null).filter(stock -> Objects.equals(stock.isMutation(), true)).filter(stock -> Objects.equals(stock.getQuantity().signum(), -1)).max(Comparator.comparing(Stock::getReferenceDate)).orElse(null);
        return lastSale;
    }

    private @Nullable BigDecimal sumErtragCHF(Security security, boolean rubrikA) {
        List payments = security.getPayments();
        if (payments == null) {
            return BigDecimal.ZERO;
        }
        if (payments.isEmpty()) {
            return null;
        }
        BigDecimal result = payments.stream().map(p -> TSUtils.coalesce(rubrikA ? p.getGrossRevenueA() : p.getGrossRevenueB(), BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return result;
    }

    private @NonNull BigDecimal sumErtragFW(Security security) {
        List payments = security.getPayments();
        if (payments == null) {
            return BigDecimal.ZERO;
        }
        if (payments.isEmpty()) {
            return BigDecimal.ZERO;
        }
        BigDecimal sumAmount = payments.stream().map(this::extractAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sumAmount;
    }

    private boolean isLumpSumTaxCredit(Security security) {
        List payments = security.getPayments();
        if (payments == null || payments.isEmpty()) {
            return false;
        }
        boolean result = payments.stream().map(p -> p.getNonRecoverableTaxPercent() != null).reduce(false, Boolean::logicalOr);
        return result;
    }

    private static boolean hasNonRecoverableTaxPercent(Payment p) {
        return p.getNonRecoverableTaxPercent() != null;
    }

    private BigDecimal getNonRecoverableTaxPercent(Security security) {
        List payments = security.getPayments();
        BigDecimal result = Objects.requireNonNull(payments).stream().filter(Securities::hasNonRecoverableTaxPercent).map(Payment::getNonRecoverableTaxPercent).findFirst().orElse(BigDecimal.ZERO);
        return result;
    }

    private BigDecimal sumNonRecoverableTaxAmaount(Security security) {
        List payments = security.getPayments();
        BigDecimal result = Objects.requireNonNull(payments).stream().filter(p -> p.getNonRecoverableTaxAmount() != null).map(Payment::getNonRecoverableTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return result;
    }

    private BigDecimal sumAdditionalWithHoldingTaxUSA(Security security) {
        List payments = security.getPayments();
        BigDecimal result = Objects.requireNonNull(payments).stream().filter(p -> p.getAdditionalWithHoldingTaxUSA() != null).map(Payment::getAdditionalWithHoldingTaxUSA).reduce(BigDecimal.ZERO, BigDecimal::add);
        return result;
    }

    private BigDecimal extractAmount(Payment payment) {
        if (payment.getAmount() != null) {
            return payment.getAmount();
        }
        if (payment.getDisposition() == null) {
            return BigDecimal.ZERO;
        }
        if (payment.getDisposition().getBalance() == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal purchaseSum = payment.getPurchases() == null ? BigDecimal.ZERO : payment.getPurchases().stream().map(purchase -> TSUtils.coalesce(purchase.getBalance(), BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return payment.getDisposition().getBalance().subtract(purchaseSum);
    }

    private TaxStatementModelMap getWertschriftenItems(@NonNull DMK wertschriftenDmk, @Nullable Wertschriften wertschriften) {
        TaxStatementModelMap newWertschriftenItems = new TaxStatementModelMap(wertschriftenDmk);
        if (wertschriften == null) {
            return newWertschriftenItems;
        }
        newWertschriftenItems.add("TotalTaxValue", wertschriften.getTotalTaxValue());
        newWertschriftenItems.add("TotalGrossRevenueA", wertschriften.getTotalGrossRevenueA());
        newWertschriftenItems.add("TotalGrossRevenueACanton", wertschriften.getTotalGrossRevenueACanton());
        newWertschriftenItems.add("TotalGrossRevenueB", wertschriften.getTotalGrossRevenueB());
        newWertschriftenItems.add("TotalGrossRevenueBCanton", wertschriften.getTotalGrossRevenueBCanton());
        newWertschriftenItems.add("TotalWithHoldingTaxClaim", wertschriften.getTotalWithHoldingTaxClaim());
        newWertschriftenItems.add("TotalLumpSumTaxCredit", wertschriften.getTotalLumpSumTaxCredit());
        newWertschriftenItems.add("TotalNonRecoverableTax", wertschriften.getTotalNonRecoverableTax());
        newWertschriftenItems.add("TotalAdditionalWithHoldingTaxUSA", wertschriften.getTotalAdditionalWithHoldingTaxUSA());
        newWertschriftenItems.add("TotalGrossRevenueIUP", wertschriften.getTotalGrossRevenueIUP());
        newWertschriftenItems.add("TotalGrossRevenueConversion", wertschriften.getTotalGrossRevenueConversion());
        return newWertschriftenItems;
    }

    private @NonNull Result<TransferMessage, Optional<TransferMessage>> transferSecurity(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        LMK givenIdentifier = JuModelConstants.WERTSCHRIFTEN_AKTIEN.append("ValorenNr").toLMK();
        String valorNumber = TSUtils.asString(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_TABLE_SECURITY.append("ValorNumber"), srcRow));
        String type = TSUtils.asString(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_TABLE_SECURITY.append("SecurityType"), srcRow));
        Pair<DMK, String> duplicateEntry = TSUtils.getDuplicateEntry(this.logicModel, this.dataModel, JuModelConstants.WERTSCHRIFTEN_AKTIEN, givenIdentifier, valorNumber);
        if (type != null && type.contains("BOND")) {
            if (type.equals("BOND_CONVERTIBLE")) {
                return TSUtils.handleTransferIfNeeded(this.dataModel, duplicateEntry, srcRow, Category.WERTSCHRIFTEN, this::buildDiverseDTO, this::writeDiverseToStek);
            }
            return TSUtils.handleTransferIfNeeded(this.dataModel, duplicateEntry, srcRow, Category.WERTSCHRIFTEN, this::buildObligationDTO, this::writeObligationToStek);
        }
        return TSUtils.handleTransferIfNeeded(this.dataModel, duplicateEntry, srcRow, Category.WERTSCHRIFTEN, this::buildAktienDTO, this::writeAktionToStek);
    }

    private @NonNull Result<TransferMessage, AktienDTO> buildAktienDTO(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        LMK aktienTableLmk = LMK.parse((String)"TaxStatement.TaxStatementTable.Wertschriften.Securities");
        DMK aktienTableDmk = srcRow.merge(aktienTableLmk);
        String eStAId = Objects.requireNonNull((String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_TABLE_ID, srcRow));
        AktienDTO action = new AktienDTO(eStAId, (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("SecurityName").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("ValorNumber").toLMK(), srcRow)), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("Currency").toLMK(), srcRow));
        action.setTaxValueQuantity(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("TaxValueQuantity").toLMK(), srcRow)));
        action.setPaymentQuantity(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("PaymentQuantity").toLMK(), srcRow)));
        action.setPaymentAmount(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("PaymentAmount").toLMK(), srcRow)));
        action.setTaxValueValue(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("TaxValueValue").toLMK(), srcRow)));
        action.setPaymentExchangeRate(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("PaymentExchangeRate").toLMK(), srcRow)));
        action.setTaxValueExchangeRate(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("TaxValueExchangeRate").toLMK(), srcRow)));
        action.setPaymentGrossRevenueA(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("PaymentGrossRevenueA").toLMK(), srcRow)));
        action.setPaymentGrossRevenueB(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("PaymentGrossRevenueB").toLMK(), srcRow)));
        action.setNonRecoverableTaxAmount(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("nonRecoverableTaxAmount").toLMK(), srcRow)));
        action.setTaxValueUnitPrice(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("TaxValueUnitPrice").toLMK(), srcRow)));
        action.setPaymentDate((Date)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("PaymentDate").toLMK(), srcRow));
        action.setAdditionalWithHoldingTaxUSA(TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, aktienTableDmk.append("additionalWithHoldingTaxUSA").toLMK(), srcRow)));
        return Result.ok((Object)action);
    }

    private @NonNull Result<TransferMessage, ObligationenDTO> buildObligationDTO(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        LMK obligationTableLmk = LMK.parse((String)"TaxStatement.TaxStatementTable.Wertschriften.Securities");
        DMK obligationTableDmk = srcRow.merge(obligationTableLmk);
        String eStAId = Objects.requireNonNull((String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_TABLE_ID, srcRow));
        ObligationenDTO obligation = new ObligationenDTO(eStAId, (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("SecurityName").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("ValorNumber").toLMK(), srcRow)), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("Currency").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("TaxValueUnitPrice").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("InterestRate").toLMK(), srcRow)), (Date)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("PaymentDate").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("TaxValueBalance").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("PaymentGrossRevenueA").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("PaymentGrossRevenueB").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("PaymentAmount").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("IssuePrice").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("PaymentExchangeRate").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("TaxValueExchangeRate").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("TaxValueValue").toLMK(), srcRow)), (Date)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("TaxValueReferenceDate").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, obligationTableDmk.append("PaymentQuantity").toLMK(), srcRow)));
        return Result.ok((Object)obligation);
    }

    private @NonNull Result<TransferMessage, DiverseDTO> buildDiverseDTO(@NonNull DMK srcRow) {
        Objects.requireNonNull(srcRow);
        LMK diverseTableLmk = LMK.parse((String)"TaxStatement.TaxStatementTable.Wertschriften.Securities");
        DMK diverseTableDmk = srcRow.merge(diverseTableLmk);
        String eStAId = Objects.requireNonNull((String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, JuModelConstants.TAXSTATEMENT_TABLE_ID, srcRow));
        DiverseDTO diverse = new DiverseDTO(eStAId, (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("SecurityName").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("ValorNumber").toLMK(), srcRow)), (String)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("Currency").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("TaxValueUnitPrice").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("InterestRate").toLMK(), srcRow)), (Date)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("PaymentDate").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("TaxValueBalance").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("PaymentGrossRevenueA").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("PaymentGrossRevenueB").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("PaymentAmount").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("IssuePrice").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("PaymentExchangeRate").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("TaxValueExchangeRate").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("TaxValueValue").toLMK(), srcRow)), (Date)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("TaxValueReferenceDate").toLMK(), srcRow), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("PaymentQuantity").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("NominalValue").toLMK(), srcRow)), TSUtils.asDouble(TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("RedemptionPrice").toLMK(), srcRow)), (Date)TSUtils.extractValueFromModel(this.logicModel, this.dataModel, diverseTableDmk.append("RedemptionDate").toLMK(), srcRow));
        return Result.ok((Object)diverse);
    }

    private void writeAktionToStek(@NonNull AktienDTO action, @Nullable DMK existingRow) {
        Objects.requireNonNull(action);
        if (TSUtils.getOrZero(action.getAdditionalWithHoldingTaxUSA()) > 0.0 || TSUtils.getOrZero(action.getNonRecoverableTaxAmount()) > 0.0) {
            this.writeDA1RUSToStek(action, existingRow);
            return;
        }
        TSUtils.enableToplevelCheckbox(this.logicModel, this.dataModel, this.updater, LMK.parse((String)"Wertschriften.Selektion.CheckAktien"));
        DMK actionRow = TSUtils.createNewRowIfNotExisting(this.logicModel, this.dataModel, JuModelConstants.WERTSCHRIFTEN_AKTIEN, existingRow);
        TaxStatementModelMap actionItems = new TaxStatementModelMap(actionRow);
        Double nbrTitleEnd = action.getPaymentQuantity();
        double nbrTitle = TSUtils.getOrZero(action.getTaxValueQuantity());
        Long currencyObject = action.getCurrency() != null ? TSUtils.getCurrencyCode(action.getCurrency()) : null;
        Long currencyCode = currencyObject != null ? currencyObject : 0L;
        double paymentGrossRevenueA = TSUtils.getOrZero(action.getPaymentGrossRevenueA());
        double paymentGrossRevenueB = TSUtils.getOrZero(action.getPaymentGrossRevenueB());
        boolean withGrossRevenueA = paymentGrossRevenueA > 0.0;
        double payementGrossRevenu = withGrossRevenueA ? paymentGrossRevenueA : paymentGrossRevenueB;
        double totalPaymentAmount = TSUtils.getOrZero(action.getPaymentAmount());
        double d = totalPaymentAmount = totalPaymentAmount > 0.0 ? totalPaymentAmount : payementGrossRevenu;
        double payementGrossRevenuPerSecurityCHF = nbrTitle > 0.0 ? (payementGrossRevenu > 0.0 ? TSUtils.divisionOrDefault(payementGrossRevenu, nbrTitle, ZEROD).doubleValue() : TSUtils.divisionOrDefault(totalPaymentAmount, nbrTitle, ZEROD).doubleValue()) : TSUtils.divisionOrDefault(totalPaymentAmount, nbrTitleEnd, ZEROD);
        Double valueProTitle = action.getTaxValueUnitPrice();
        double valueTotal = TSUtils.getOrZero(valueProTitle) * nbrTitle;
        double currencyRate = TSUtils.getOrZero(action.getPaymentExchangeRate());
        double currencyRateEnd = TSUtils.getOrZero(action.getTaxValueExchangeRate());
        currencyRateEnd = currencyRateEnd > 0.0 ? currencyRateEnd : currencyRate;
        actionItems.add("ESteuerauszugId", action.geteStAId());
        actionItems.add("Herkunft", "1");
        actionItems.add("ValorenNr", action.getValorNumber());
        actionItems.add("AnzahlEndeJahr", nbrTitle);
        actionItems.add("Waehrung", currencyCode);
        actionItems.add("Bezeichnung", action.getSecurityName());
        actionItems.add("DividendenTermin", action.getPaymentDate());
        actionItems.add("AnzahlDividendenTermin", nbrTitleEnd);
        actionItems.add("KeineBerechnung", "false");
        actionItems.add("ErtragProStkERL", payementGrossRevenuPerSecurityCHF);
        actionItems.add("TotalErtragERL", payementGrossRevenu);
        actionItems.add("TotalSteuerwertERL", action.getTaxValueValue());
        actionItems.add("VSTPflichtigERL", withGrossRevenueA);
        actionItems.add("SteuerwertOhneBerechnungFWERL", valueTotal);
        if (currencyCode > 1L) {
            double valueProTitleCHF = TSUtils.getOrZero(valueProTitle) * currencyRateEnd;
            actionItems.add("WaehrungskursZins", currencyRate);
            actionItems.add("WaehrungskursEndeJahr", currencyRateEnd);
            actionItems.add("ErtragProStkFWERL", TSUtils.divisionOrDefault(payementGrossRevenuPerSecurityCHF, currencyRate, ZEROD));
            actionItems.add("SteuerwertProStkERL", valueProTitleCHF);
            actionItems.add("SteuerwertProStkFWERL", valueProTitle);
            actionItems.add("SteuerwertOhneBerechnungERL", valueProTitleCHF * nbrTitle);
        } else {
            actionItems.add("SteuerwertProStkERL", valueProTitle);
        }
        this.updater.accept(actionItems.getChanges());
    }

    private void writeDA1RUSToStek(@NonNull AktienDTO action, @Nullable DMK existingRow) {
        DMK actionRow = TSUtils.createNewRowIfNotExisting(this.logicModel, this.dataModel, JuModelConstants.WERTSCHRIFTEN_DA1RUS, existingRow);
        TaxStatementModelMap actionItems = new TaxStatementModelMap(actionRow);
        TSUtils.enableToplevelCheckbox(this.logicModel, this.dataModel, this.updater, LMK.parse((String)"Wertschriften.Selektion.CheckErgaenzungsblaetter"));
        double paymentGrossRevenueA = TSUtils.getOrZero(action.getPaymentGrossRevenueA());
        double paymentGrossRevenueB = TSUtils.getOrZero(action.getPaymentGrossRevenueB());
        actionItems.add("ESteuerauszugId", action.geteStAId());
        actionItems.add("Name", action.getSecurityName());
        actionItems.add("Fortune", action.getTaxValueValue());
        actionItems.add("Rendement", paymentGrossRevenueA > 0.0 ? paymentGrossRevenueA : paymentGrossRevenueB);
        actionItems.add("MontantRetenueSupplementaire", action.getAdditionalWithHoldingTaxUSA());
        actionItems.add("MontantImpotEtranger", action.getNonRecoverableTaxAmount());
        this.updater.accept(actionItems.getChanges());
    }

    private void writeObligationToStek(@NonNull ObligationenDTO obligation, @Nullable DMK existingRow) {
        Objects.requireNonNull(obligation);
        TSUtils.enableToplevelCheckbox(this.logicModel, this.dataModel, this.updater, LMK.parse((String)"Wertschriften.Selektion.CheckObligationen"));
        DMK actionRow = TSUtils.createNewRowIfNotExisting(this.logicModel, this.dataModel, JuModelConstants.WERTSCHRIFTEN_OBLIGATIONEN, existingRow);
        TaxStatementModelMap obligationItems = new TaxStatementModelMap(actionRow);
        double paymentGrossRevenueA = TSUtils.getOrZero(obligation.getPaymentGrossRevenueA());
        double paymentGrossRevenueB = TSUtils.getOrZero(obligation.getPaymentGrossRevenueB());
        boolean withGrossRevenueA = paymentGrossRevenueA > 0.0;
        double payementGrossRevenu = withGrossRevenueA ? paymentGrossRevenueA : paymentGrossRevenueB;
        Long currencyObject = obligation.getCurrency() != null ? TSUtils.getCurrencyCode(obligation.getCurrency()) : null;
        Long currencyCode = currencyObject != null ? currencyObject : 0L;
        Double taxValueValue = obligation.getTaxValueValue();
        double paymentQuantity = TSUtils.getOrZero(obligation.getPaymentQuantity());
        double interestRate = TSUtils.getOrZero(obligation.getInterestRate());
        double taux = TSUtils.divisionOrDefault(taxValueValue, paymentQuantity, ZEROD) * 100.0;
        double rendementBrut = paymentQuantity * interestRate / 100.0;
        Date datumVerfall = obligation.getTaxValueReferenceDate() != null ? obligation.getTaxValueReferenceDate() : obligation.getPaymentDate();
        obligationItems.add("ESteuerauszugId", obligation.geteStAId());
        obligationItems.add("Herkunft", "1");
        obligationItems.add("VSTPflichtigERL", withGrossRevenueA);
        obligationItems.add("ValorenNr", obligation.getValorNumber());
        obligationItems.add("Bezeichnung", obligation.getSecurityName());
        obligationItems.add("TotalSteuerwert", obligation.getTaxValueBalance());
        obligationItems.add("Waehrung", currencyCode);
        obligationItems.add("DatumEroeffnungERL", obligation.getPaymentDate());
        obligationItems.add("DatumVerfallERL", datumVerfall);
        obligationItems.add("ZinssatzProzentERL", interestRate);
        obligationItems.add("TotalErtragERL", rendementBrut);
        obligationItems.add("SteuerwertProzentERL", taux);
        obligationItems.add("TotalSteuerwertERL", taxValueValue);
        if (currencyCode != 1L) {
            Double valNominal = obligation.getPaymentQuantity();
            Double courMonetaire = obligation.getPaymentExchangeRate();
            double valNominalCHF = TSUtils.getOrZero(valNominal) * TSUtils.getOrZero(courMonetaire);
            double rendementCHF = payementGrossRevenu;
            rendementCHF = rendementCHF > 0.0 ? rendementCHF : TSUtils.getOrZero(obligation.getPaymentAmount()) * TSUtils.getOrZero(courMonetaire);
            Double taxValueUnitPrice = obligation.getTaxValueUnitPrice();
            Double issuePrice = obligation.getIssuePrice();
            valNominalCHF = valNominalCHF != 0.0 ? valNominalCHF : paymentQuantity;
            obligationItems.add("WaehrungskursEndeJahr", obligation.getTaxValueExchangeRate());
            obligationItems.add("WaehrungskursZins", courMonetaire);
            obligationItems.add("NennwertFW", valNominal);
            obligationItems.add("NennwertERL", valNominalCHF);
            obligationItems.add("TotalErtragFWERL", obligation.getPaymentAmount());
            obligationItems.add("TotalErtragERL", rendementCHF);
            obligationItems.add("SteuerwertProzentERL", TSUtils.divisionOrDefault(taxValueUnitPrice, issuePrice, ZEROD) * 100.0);
            obligationItems.add("TotalSteuerwertERL", obligation.getTaxValueValue());
            obligationItems.add("TotalSteuerwertFW", TSUtils.divisionOrDefault(taxValueValue, courMonetaire, ZEROD));
        }
        this.updater.accept(obligationItems.getChanges());
    }

    private void writeDiverseToStek(@NonNull DiverseDTO diverse, @Nullable DMK existingRow) {
        Objects.requireNonNull(diverse);
        TSUtils.enableToplevelCheckbox(this.logicModel, this.dataModel, this.updater, LMK.parse((String)"Wertschriften.Selektion.CheckDiverse"));
        DMK actionRow = TSUtils.createNewRowIfNotExisting(this.logicModel, this.dataModel, JuModelConstants.WERTSCHRIFTEN_DIVERSE, existingRow);
        TaxStatementModelMap diverseItems = new TaxStatementModelMap(actionRow);
        Double redemptionPrice = diverse.getRedemptionPrice();
        Double interestRate = diverse.getInterestRate();
        Double paymentQuantity = diverse.getPaymentQuantity();
        Double nominalValue = diverse.getNominalValue();
        double rendementBrut = TSUtils.divisionOrDefault(nominalValue, interestRate, ZEROD) * 100.0;
        double fiscalValue = TSUtils.divisionOrDefault(nominalValue, paymentQuantity, ZEROD);
        Double paymentExchangeRate = diverse.getPaymentExchangeRate();
        double rendementBrutCHF = TSUtils.divisionOrDefault(rendementBrut, paymentExchangeRate, rendementBrut);
        Double fiscalValueCHF = TSUtils.divisionOrDefault(redemptionPrice, paymentExchangeRate, redemptionPrice);
        Long currencyCode = diverse.getCurrency() != null ? TSUtils.getCurrencyCode(diverse.getCurrency()) : 0L;
        currencyCode = currencyCode != null ? currencyCode : 0L;
        diverseItems.add("ESteuerauszugId", diverse.geteStAId());
        diverseItems.add("Herkunft", "1");
        diverseItems.add("VSTPflichtigERL", TSUtils.getOrZero(diverse.getPaymentGrossRevenueA()) > 0.0);
        diverseItems.add("ValorenNr", diverse.getValorNumber());
        diverseItems.add("Bezeichnung", diverse.getSecurityName());
        diverseItems.add("Waehrung", currencyCode);
        diverseItems.add("Nennwert", nominalValue);
        diverseItems.add("Stueckzahl", paymentQuantity);
        diverseItems.add("DatumEroeffnung", diverse.getPaymentDate());
        diverseItems.add("DatumVerfall", diverse.getRedemptionDate());
        diverseItems.add("ZinssatzProzent", interestRate);
        diverseItems.add("SteuerwertProzent", fiscalValue * 100.0);
        diverseItems.add("SteuerwertProStueck", fiscalValue);
        if (currencyCode > 1L) {
            diverseItems.add("WaehrungskursZins", paymentExchangeRate);
            diverseItems.add("WaehrungskursEndeJahr", paymentExchangeRate);
            diverseItems.add("TotalErtragFW", diverse.getPaymentAmount());
            diverseItems.add("TotalErtragERL", rendementBrutCHF);
            diverseItems.add("TotalSteuerwertFW", fiscalValueCHF);
            diverseItems.add("TotalSteuerwertERL", redemptionPrice);
        } else {
            diverseItems.add("TotalErtragERL", rendementBrut);
            diverseItems.add("TotalSteuerwertFW", redemptionPrice);
        }
        this.updater.accept(diverseItems.getChanges());
    }
}

